/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.storage.blob.models.BlobGetPropertiesHeaders;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.Metadata;
import java.util.Map;

public class BlobProperties {
    private final BlobType blobType;
    private final Metadata metadata;
    private final long blobSize;
    private final byte[] contentMD5;
    private final String contentEncoding;
    private final String contentDisposition;
    private final String contentLanguage;
    private final String cacheControl;

    BlobProperties(BlobGetPropertiesHeaders generatedHeaders) {
        this.blobType = generatedHeaders.blobType();
        this.metadata = new Metadata((Map<? extends String, ? extends String>)generatedHeaders.metadata());
        this.blobSize = generatedHeaders.contentLength() == null ? 0L : generatedHeaders.contentLength();
        this.contentMD5 = generatedHeaders.contentMD5();
        this.contentEncoding = generatedHeaders.contentEncoding();
        this.contentDisposition = generatedHeaders.contentDisposition();
        this.contentLanguage = generatedHeaders.contentLanguage();
        this.cacheControl = generatedHeaders.cacheControl();
    }

    public BlobType blobType() {
        return this.blobType;
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public long blobSize() {
        return this.blobSize;
    }

    public byte[] contentMD5() {
        return this.contentMD5;
    }

    public String contentEncoding() {
        return this.contentEncoding;
    }

    public String contentDisposition() {
        return this.contentDisposition;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public String cacheControl() {
        return this.cacheControl;
    }
}

