/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.http.rest.VoidResponse;
import com.azure.core.implementation.util.FluxUtil;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlockBlobAsyncRawClient;
import com.azure.storage.blob.BlockBlobClientBuilder;
import com.azure.storage.blob.implementation.AzureBlobStorageBuilder;
import com.azure.storage.blob.models.BlobAccessConditions;
import com.azure.storage.blob.models.BlobHTTPHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.Block;
import com.azure.storage.blob.models.BlockBlobCommitBlockListHeaders;
import com.azure.storage.blob.models.BlockBlobItem;
import com.azure.storage.blob.models.BlockBlobUploadHeaders;
import com.azure.storage.blob.models.BlockItem;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.blob.models.LeaseAccessConditions;
import com.azure.storage.blob.models.Metadata;
import com.azure.storage.blob.models.SourceModifiedAccessConditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BlockBlobAsyncClient
extends BlobAsyncClient {
    static final int BLOB_DEFAULT_UPLOAD_BLOCK_SIZE = 0x400000;
    static final int BLOB_MAX_UPLOAD_BLOCK_SIZE = 0x6400000;
    final BlockBlobAsyncRawClient blockBlobAsyncRawClient;
    public static final int MAX_UPLOAD_BLOB_BYTES = 0x10000000;
    public static final int MAX_STAGE_BLOCK_BYTES = 0x6400000;
    public static final int MAX_BLOCKS = 50000;

    BlockBlobAsyncClient(AzureBlobStorageBuilder azureBlobStorageBuilder, String snapshot) {
        super(azureBlobStorageBuilder, snapshot);
        this.blockBlobAsyncRawClient = new BlockBlobAsyncRawClient(azureBlobStorageBuilder.build(), snapshot);
    }

    public static BlockBlobClientBuilder blockBlobClientBuilder() {
        return new BlockBlobClientBuilder();
    }

    public Mono<Response<BlockBlobItem>> upload(Flux<ByteBuffer> data, long length) {
        return this.upload(data, length, null, null, null);
    }

    public Mono<Response<BlockBlobItem>> upload(Flux<ByteBuffer> data, long length, BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions) {
        return this.blockBlobAsyncRawClient.upload((Flux<ByteBuf>)data.map(Unpooled::wrappedBuffer), length, headers, metadata, accessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)new BlockBlobItem((BlockBlobUploadHeaders)rb.deserializedHeaders())));
    }

    public Mono<Void> uploadFromFile(String filePath) {
        return this.uploadFromFile(filePath, 0x400000, null, null, null);
    }

    public Mono<Void> uploadFromFile(String filePath, Integer blockSize, BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions) {
        if (blockSize < 0 || blockSize > 0x6400000) {
            throw new IllegalArgumentException("Block size should not exceed 100MB");
        }
        return Mono.using(() -> {
            try {
                return AsynchronousFileChannel.open(Paths.get(filePath, new String[0]), StandardOpenOption.READ);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, channel -> {
            TreeMap blockIds = new TreeMap();
            return Flux.fromIterable(this.sliceFile(filePath, blockSize)).doOnNext(chunk -> {
                String string = blockIds.put(chunk.offset(), this.getBlockID());
            }).flatMap(chunk -> {
                String blockId = (String)blockIds.get(chunk.offset());
                return this.stageBlock(blockId, (Flux<ByteBuf>)FluxUtil.byteBufStreamFromFile((AsynchronousFileChannel)channel, (long)chunk.offset(), (long)chunk.count()), chunk.count(), null);
            }).then(Mono.defer(() -> this.commitBlockList(new ArrayList<String>(blockIds.values()), headers, metadata, accessConditions))).then().doOnTerminate(() -> {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }, channel -> {
            try {
                channel.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private String getBlockID() {
        return Base64.getEncoder().encodeToString(UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8));
    }

    private List<BlobRange> sliceFile(String path, Integer blockSize) {
        if (blockSize == null) {
            blockSize = 0x400000;
        }
        File file = new File(path);
        assert (file.exists());
        ArrayList<BlobRange> ranges = new ArrayList<BlobRange>();
        long pos = 0L;
        while (pos < file.length()) {
            long count = blockSize.intValue();
            if (pos + count > file.length()) {
                count = file.length() - pos;
            }
            ranges.add(new BlobRange(pos, count));
            pos += (long)blockSize.intValue();
        }
        return ranges;
    }

    public Mono<VoidResponse> stageBlock(String base64BlockID, Flux<ByteBuf> data, long length) {
        return this.stageBlock(base64BlockID, data, length, null);
    }

    public Mono<VoidResponse> stageBlock(String base64BlockID, Flux<ByteBuf> data, long length, LeaseAccessConditions leaseAccessConditions) {
        return this.blockBlobAsyncRawClient.stageBlock(base64BlockID, data, length, leaseAccessConditions).map(VoidResponse::new);
    }

    public Mono<VoidResponse> stageBlockFromURL(String base64BlockID, URL sourceURL, BlobRange sourceRange) {
        return this.stageBlockFromURL(base64BlockID, sourceURL, sourceRange, null, null, null);
    }

    public Mono<VoidResponse> stageBlockFromURL(String base64BlockID, URL sourceURL, BlobRange sourceRange, byte[] sourceContentMD5, LeaseAccessConditions leaseAccessConditions, SourceModifiedAccessConditions sourceModifiedAccessConditions) {
        return this.blockBlobAsyncRawClient.stageBlockFromURL(base64BlockID, sourceURL, sourceRange, sourceContentMD5, leaseAccessConditions, sourceModifiedAccessConditions).map(VoidResponse::new);
    }

    public Flux<BlockItem> listBlocks(BlockListType listType) {
        return this.listBlocks(listType, null);
    }

    public Flux<BlockItem> listBlocks(BlockListType listType, LeaseAccessConditions leaseAccessConditions) {
        return this.blockBlobAsyncRawClient.listBlocks(listType, leaseAccessConditions).map(ResponseBase::value).flatMapMany(bl -> {
            Flux committed = Flux.fromIterable(bl.committedBlocks()).map(block -> new BlockItem((Block)block, true));
            Flux uncommitted = Flux.fromIterable(bl.uncommittedBlocks()).map(block -> new BlockItem((Block)block, false));
            return Flux.concat((Publisher[])new Publisher[]{committed, uncommitted});
        });
    }

    public Mono<Response<BlockBlobItem>> commitBlockList(List<String> base64BlockIDs) {
        return this.commitBlockList(base64BlockIDs, null, null, null);
    }

    public Mono<Response<BlockBlobItem>> commitBlockList(List<String> base64BlockIDs, BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions) {
        return this.blockBlobAsyncRawClient.commitBlockList(base64BlockIDs, headers, metadata, accessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)new BlockBlobItem((BlockBlobCommitBlockListHeaders)rb.deserializedHeaders())));
    }
}

