/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.util.Context;
import com.azure.storage.blob.BlobAsyncRawClient;
import com.azure.storage.blob.Utility;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.models.BlobAccessConditions;
import com.azure.storage.blob.models.BlobHTTPHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlockBlobsCommitBlockListResponse;
import com.azure.storage.blob.models.BlockBlobsGetBlockListResponse;
import com.azure.storage.blob.models.BlockBlobsStageBlockFromURLResponse;
import com.azure.storage.blob.models.BlockBlobsStageBlockResponse;
import com.azure.storage.blob.models.BlockBlobsUploadResponse;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.blob.models.BlockLookupList;
import com.azure.storage.blob.models.LeaseAccessConditions;
import com.azure.storage.blob.models.Metadata;
import com.azure.storage.blob.models.SourceModifiedAccessConditions;
import io.netty.buffer.ByteBuf;
import java.net.URL;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class BlockBlobAsyncRawClient
extends BlobAsyncRawClient {
    public static final int MAX_UPLOAD_BLOB_BYTES = 0x10000000;
    public static final int MAX_STAGE_BLOCK_BYTES = 0x6400000;
    public static final int MAX_BLOCKS = 50000;

    public BlockBlobAsyncRawClient(AzureBlobStorageImpl azureBlobStorage, String snapshot) {
        super(azureBlobStorage, snapshot);
    }

    public Mono<BlockBlobsUploadResponse> upload(Flux<ByteBuf> data, long length) {
        return this.upload(data, length, null, null, null);
    }

    public Mono<BlockBlobsUploadResponse> upload(Flux<ByteBuf> data, long length, BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions) {
        metadata = metadata == null ? new Metadata() : metadata;
        accessConditions = accessConditions == null ? new BlobAccessConditions() : accessConditions;
        return Utility.postProcessResponse(this.azureBlobStorage.blockBlobs().uploadWithRestResponseAsync(null, null, data, length, null, metadata, null, null, null, null, headers, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions(), Context.NONE));
    }

    public Mono<BlockBlobsStageBlockResponse> stageBlock(String base64BlockID, Flux<ByteBuf> data, long length) {
        return this.stageBlock(base64BlockID, data, length, null);
    }

    public Mono<BlockBlobsStageBlockResponse> stageBlock(String base64BlockID, Flux<ByteBuf> data, long length, LeaseAccessConditions leaseAccessConditions) {
        return Utility.postProcessResponse(this.azureBlobStorage.blockBlobs().stageBlockWithRestResponseAsync(null, null, base64BlockID, length, data, null, null, null, null, null, null, leaseAccessConditions, Context.NONE));
    }

    public Mono<BlockBlobsStageBlockFromURLResponse> stageBlockFromURL(String base64BlockID, URL sourceURL, BlobRange sourceRange) {
        return this.stageBlockFromURL(base64BlockID, sourceURL, sourceRange, null, null, null);
    }

    public Mono<BlockBlobsStageBlockFromURLResponse> stageBlockFromURL(String base64BlockID, URL sourceURL, BlobRange sourceRange, byte[] sourceContentMD5, LeaseAccessConditions leaseAccessConditions, SourceModifiedAccessConditions sourceModifiedAccessConditions) {
        sourceRange = sourceRange == null ? new BlobRange(0L) : sourceRange;
        return Utility.postProcessResponse(this.azureBlobStorage.blockBlobs().stageBlockFromURLWithRestResponseAsync(null, null, base64BlockID, 0L, sourceURL, sourceRange.toHeaderValue(), sourceContentMD5, null, null, null, null, null, leaseAccessConditions, sourceModifiedAccessConditions, Context.NONE));
    }

    public Mono<BlockBlobsGetBlockListResponse> listBlocks(BlockListType listType) {
        return this.listBlocks(listType, null);
    }

    public Mono<BlockBlobsGetBlockListResponse> listBlocks(BlockListType listType, LeaseAccessConditions leaseAccessConditions) {
        return Utility.postProcessResponse(this.azureBlobStorage.blockBlobs().getBlockListWithRestResponseAsync(null, null, listType, this.snapshot, null, null, null, leaseAccessConditions, Context.NONE));
    }

    public Mono<BlockBlobsCommitBlockListResponse> commitBlockList(List<String> base64BlockIDs) {
        return this.commitBlockList(base64BlockIDs, null, null, null);
    }

    public Mono<BlockBlobsCommitBlockListResponse> commitBlockList(List<String> base64BlockIDs, BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions) {
        metadata = metadata == null ? new Metadata() : metadata;
        accessConditions = accessConditions == null ? new BlobAccessConditions() : accessConditions;
        return Utility.postProcessResponse(this.azureBlobStorage.blockBlobs().commitBlockListWithRestResponseAsync(null, null, new BlockLookupList().latest(base64BlockIDs), null, metadata, null, null, null, null, headers, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions(), Context.NONE));
    }
}

