/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.http.rest.VoidResponse;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobOutputStream;
import com.azure.storage.blob.BlockBlobAsyncClient;
import com.azure.storage.blob.BlockBlobClientBuilder;
import com.azure.storage.blob.Utility;
import com.azure.storage.blob.models.BlobAccessConditions;
import com.azure.storage.blob.models.BlobHTTPHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlockBlobItem;
import com.azure.storage.blob.models.BlockBlobUploadHeaders;
import com.azure.storage.blob.models.BlockItem;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.blob.models.LeaseAccessConditions;
import com.azure.storage.blob.models.Metadata;
import com.azure.storage.blob.models.SourceModifiedAccessConditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public final class BlockBlobClient
extends BlobClient {
    private BlockBlobAsyncClient blockBlobAsyncClient;
    public static final int MAX_UPLOAD_BLOB_BYTES = 0x10000000;
    public static final int MAX_STAGE_BLOCK_BYTES = 0x6400000;
    public static final int MAX_BLOCKS = 50000;

    BlockBlobClient(BlockBlobAsyncClient blockBlobAsyncClient) {
        super(blockBlobAsyncClient);
        this.blockBlobAsyncClient = blockBlobAsyncClient;
    }

    public static BlockBlobClientBuilder blockBlobClientBuilder() {
        return new BlockBlobClientBuilder();
    }

    public BlobOutputStream getBlobOutputStream() {
        return this.getBlobOutputStream(null);
    }

    public BlobOutputStream getBlobOutputStream(BlobAccessConditions accessConditions) {
        return new BlobOutputStream(this.blockBlobAsyncClient, accessConditions);
    }

    public Response<BlockBlobItem> upload(InputStream data, long length) throws IOException {
        return this.upload(data, length, null, null, null, null);
    }

    public Response<BlockBlobItem> upload(InputStream data, long length, BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions, Duration timeout) throws IOException {
        Flux fbb = Flux.range((int)0, (int)((int)Math.ceil((double)length / 4194304.0))).map(i -> i * 0x400000).concatMap(pos -> Mono.fromCallable(() -> {
            long count = (long)(pos + 0x400000) > length ? length - (long)pos.intValue() : 0x400000L;
            byte[] cache = new byte[(int)count];
            int read = 0;
            while ((long)read < count) {
                read += data.read(cache, read, (int)count - read);
            }
            return ByteBufAllocator.DEFAULT.buffer((int)count).writeBytes(cache);
        }));
        Mono upload = this.blockBlobAsyncClient.blockBlobAsyncRawClient.upload((Flux<ByteBuf>)fbb.subscribeOn(Schedulers.elastic()), length, headers, metadata, accessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)new BlockBlobItem((BlockBlobUploadHeaders)rb.deserializedHeaders())));
        try {
            return (Response)Utility.blockWithOptionalTimeout(upload, timeout);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public void uploadFromFile(String filePath) throws IOException {
        this.uploadFromFile(filePath, null, null, null, null);
    }

    public void uploadFromFile(String filePath, BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions, Duration timeout) throws IOException {
        Mono<Void> upload = this.blockBlobAsyncClient.uploadFromFile(filePath, 0x400000, headers, metadata, accessConditions);
        try {
            if (timeout == null) {
                upload.block();
            } else {
                upload.block(timeout);
            }
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public VoidResponse stageBlock(String base64BlockID, InputStream data, long length) throws IOException {
        return this.stageBlock(base64BlockID, data, length, null, null);
    }

    public VoidResponse stageBlock(String base64BlockID, InputStream data, long length, LeaseAccessConditions leaseAccessConditions, Duration timeout) {
        Flux fbb = Flux.range((int)0, (int)((int)Math.ceil((double)length / 4194304.0))).map(i -> i * 0x400000).concatMap(pos -> Mono.fromCallable(() -> {
            long count = (long)(pos + 0x400000) > length ? length - (long)pos.intValue() : 0x400000L;
            byte[] cache = new byte[(int)count];
            int read = 0;
            while ((long)read < count) {
                read += data.read(cache, read, (int)count - read);
            }
            return ByteBufAllocator.DEFAULT.buffer((int)count).writeBytes(cache);
        }));
        Mono<VoidResponse> response = this.blockBlobAsyncClient.stageBlock(base64BlockID, (Flux<ByteBuf>)fbb.subscribeOn(Schedulers.elastic()), length, leaseAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public VoidResponse stageBlockFromURL(String base64BlockID, URL sourceURL, BlobRange sourceRange) {
        return this.stageBlockFromURL(base64BlockID, sourceURL, sourceRange, null, null, null, null);
    }

    public VoidResponse stageBlockFromURL(String base64BlockID, URL sourceURL, BlobRange sourceRange, byte[] sourceContentMD5, LeaseAccessConditions leaseAccessConditions, SourceModifiedAccessConditions sourceModifiedAccessConditions, Duration timeout) {
        Mono<VoidResponse> response = this.blockBlobAsyncClient.stageBlockFromURL(base64BlockID, sourceURL, sourceRange, sourceContentMD5, leaseAccessConditions, sourceModifiedAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Iterable<BlockItem> listBlocks(BlockListType listType) {
        return this.listBlocks(listType, null, null);
    }

    public Iterable<BlockItem> listBlocks(BlockListType listType, LeaseAccessConditions leaseAccessConditions, Duration timeout) {
        Flux<BlockItem> response = this.blockBlobAsyncClient.listBlocks(listType, leaseAccessConditions);
        return timeout == null ? response.toIterable() : response.timeout(timeout).toIterable();
    }

    public Response<BlockBlobItem> commitBlockList(List<String> base64BlockIDs) {
        return this.commitBlockList(base64BlockIDs, null, null, null, null);
    }

    public Response<BlockBlobItem> commitBlockList(List<String> base64BlockIDs, BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions, Duration timeout) {
        Mono<Response<BlockBlobItem>> response = this.blockBlobAsyncClient.commitBlockList(base64BlockIDs, headers, metadata, accessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }
}

