/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.http.rest.VoidResponse;
import com.azure.core.util.Context;
import com.azure.storage.blob.AppendBlobAsyncClient;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlockBlobAsyncClient;
import com.azure.storage.blob.ContainerAsyncRawClient;
import com.azure.storage.blob.ContainerClientBuilder;
import com.azure.storage.blob.ContainerProperties;
import com.azure.storage.blob.PageBlobAsyncClient;
import com.azure.storage.blob.StorageAsyncClient;
import com.azure.storage.blob.StorageException;
import com.azure.storage.blob.Utility;
import com.azure.storage.blob.implementation.AzureBlobStorageBuilder;
import com.azure.storage.blob.models.BlobFlatListSegment;
import com.azure.storage.blob.models.BlobHierarchyListSegment;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.ContainerAccessConditions;
import com.azure.storage.blob.models.ContainerAccessPolicies;
import com.azure.storage.blob.models.ContainerAcquireLeaseHeaders;
import com.azure.storage.blob.models.ContainerBreakLeaseHeaders;
import com.azure.storage.blob.models.ContainerChangeLeaseHeaders;
import com.azure.storage.blob.models.ContainerGetAccountInfoHeaders;
import com.azure.storage.blob.models.ContainerGetPropertiesHeaders;
import com.azure.storage.blob.models.ContainerRenewLeaseHeaders;
import com.azure.storage.blob.models.ContainersListBlobFlatSegmentResponse;
import com.azure.storage.blob.models.ContainersListBlobHierarchySegmentResponse;
import com.azure.storage.blob.models.LeaseAccessConditions;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.models.Metadata;
import com.azure.storage.blob.models.ModifiedAccessConditions;
import com.azure.storage.blob.models.PublicAccessType;
import com.azure.storage.blob.models.SignedIdentifier;
import com.azure.storage.blob.models.StorageAccountInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ContainerAsyncClient {
    ContainerAsyncRawClient containerAsyncRawClient;
    private AzureBlobStorageBuilder azureBlobStorageBuilder;
    public static final String ROOT_CONTAINER_NAME = "$root";
    public static final String STATIC_WEBSITE_CONTAINER_NAME = "$web";
    public static final String LOG_CONTAINER_NAME = "$logs";

    ContainerAsyncClient(AzureBlobStorageBuilder azureBlobStorageBuilder) {
        this.azureBlobStorageBuilder = azureBlobStorageBuilder;
        this.containerAsyncRawClient = new ContainerAsyncRawClient(azureBlobStorageBuilder.build());
    }

    public static ContainerClientBuilder containerClientBuilder() {
        return new ContainerClientBuilder();
    }

    public BlockBlobAsyncClient getBlockBlobAsyncClient(String blobName) {
        return this.getBlockBlobAsyncClient(blobName, null);
    }

    public BlockBlobAsyncClient getBlockBlobAsyncClient(String blobName, String snapshot) {
        return new BlockBlobAsyncClient(new AzureBlobStorageBuilder().url(Utility.appendToURLPath(this.getContainerUrl(), blobName).toString()).pipeline(this.containerAsyncRawClient.azureBlobStorage.httpPipeline()), snapshot);
    }

    public PageBlobAsyncClient getPageBlobAsyncClient(String blobName) {
        return this.getPageBlobAsyncClient(blobName, null);
    }

    public PageBlobAsyncClient getPageBlobAsyncClient(String blobName, String snapshot) {
        return new PageBlobAsyncClient(new AzureBlobStorageBuilder().url(Utility.appendToURLPath(this.getContainerUrl(), blobName).toString()).pipeline(this.containerAsyncRawClient.azureBlobStorage.httpPipeline()), snapshot);
    }

    public AppendBlobAsyncClient getAppendBlobAsyncClient(String blobName) {
        return this.getAppendBlobAsyncClient(blobName, null);
    }

    public AppendBlobAsyncClient getAppendBlobAsyncClient(String blobName, String snapshot) {
        return new AppendBlobAsyncClient(new AzureBlobStorageBuilder().url(Utility.appendToURLPath(this.getContainerUrl(), blobName).toString()).pipeline(this.containerAsyncRawClient.azureBlobStorage.httpPipeline()), snapshot);
    }

    public BlobAsyncClient getBlobAsyncClient(String blobName) {
        return this.getBlobAsyncClient(blobName, null);
    }

    public BlobAsyncClient getBlobAsyncClient(String blobName, String snapshot) {
        return new BlobAsyncClient(new AzureBlobStorageBuilder().url(Utility.appendToURLPath(this.getContainerUrl(), blobName).toString()).pipeline(this.containerAsyncRawClient.azureBlobStorage.httpPipeline()), snapshot);
    }

    public StorageAsyncClient getStorageAsyncClient() {
        return new StorageAsyncClient(new AzureBlobStorageBuilder().url(Utility.stripLastPathSegment(this.getContainerUrl()).toString()).pipeline(this.containerAsyncRawClient.azureBlobStorage.httpPipeline()));
    }

    public URL getContainerUrl() {
        try {
            return new URL(this.containerAsyncRawClient.azureBlobStorage.url());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(String.format("Invalid URL on %s: %s" + this.getClass().getSimpleName(), this.containerAsyncRawClient.azureBlobStorage.url()), e);
        }
    }

    public Mono<Response<Boolean>> exists() {
        return this.getProperties(null).map(cp -> new SimpleResponse(cp, (Object)true)).onErrorResume(t -> t instanceof StorageException && ((StorageException)((Object)((Object)t))).statusCode() == 404, t -> {
            HttpResponse response = ((StorageException)((Object)((Object)t))).response();
            return Mono.just((Object)new SimpleResponse(response.request(), response.statusCode(), response.headers(), (Object)false));
        });
    }

    public Mono<VoidResponse> create() {
        return this.create(null, null);
    }

    public Mono<VoidResponse> create(Metadata metadata, PublicAccessType accessType) {
        return this.containerAsyncRawClient.create(metadata, accessType).map(VoidResponse::new);
    }

    public Mono<VoidResponse> delete() {
        return this.delete(null);
    }

    public Mono<VoidResponse> delete(ContainerAccessConditions accessConditions) {
        return this.containerAsyncRawClient.delete(accessConditions).map(VoidResponse::new);
    }

    public Mono<Response<ContainerProperties>> getProperties() {
        return this.getProperties(null);
    }

    public Mono<Response<ContainerProperties>> getProperties(LeaseAccessConditions leaseAccessConditions) {
        return this.containerAsyncRawClient.getProperties(leaseAccessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)new ContainerProperties((ContainerGetPropertiesHeaders)rb.deserializedHeaders())));
    }

    public Mono<VoidResponse> setMetadata(Metadata metadata) {
        return this.setMetadata(metadata, null);
    }

    public Mono<VoidResponse> setMetadata(Metadata metadata, ContainerAccessConditions accessConditions) {
        return this.containerAsyncRawClient.setMetadata(metadata, accessConditions).map(VoidResponse::new);
    }

    public Mono<Response<ContainerAccessPolicies>> getAccessPolicy() {
        return this.getAccessPolicy(null);
    }

    public Mono<Response<ContainerAccessPolicies>> getAccessPolicy(LeaseAccessConditions leaseAccessConditions) {
        return this.containerAsyncRawClient.getAccessPolicy(leaseAccessConditions);
    }

    public Mono<VoidResponse> setAccessPolicy(PublicAccessType accessType, List<SignedIdentifier> identifiers) {
        return this.setAccessPolicy(accessType, identifiers, null);
    }

    public Mono<VoidResponse> setAccessPolicy(PublicAccessType accessType, List<SignedIdentifier> identifiers, ContainerAccessConditions accessConditions) {
        return this.containerAsyncRawClient.setAccessPolicy(accessType, identifiers, accessConditions).map(VoidResponse::new);
    }

    private boolean validateNoEtag(ModifiedAccessConditions modifiedAccessConditions) {
        if (modifiedAccessConditions == null) {
            return true;
        }
        return modifiedAccessConditions.ifMatch() == null && modifiedAccessConditions.ifNoneMatch() == null;
    }

    public Flux<BlobItem> listBlobsFlat() {
        return this.listBlobsFlat(new ListBlobsOptions());
    }

    public Flux<BlobItem> listBlobsFlat(ListBlobsOptions options) {
        return this.containerAsyncRawClient.listBlobsFlatSegment(null, options).flatMapMany(response -> this.listBlobsFlatHelper(options, (ContainersListBlobFlatSegmentResponse)((Object)response)));
    }

    private Flux<BlobItem> listBlobsFlatHelper(ListBlobsOptions options, ContainersListBlobFlatSegmentResponse response) {
        BlobFlatListSegment segment = response.value().segment();
        Flux result = segment != null && segment.blobItems() != null ? Flux.fromIterable(segment.blobItems()) : Flux.empty();
        if (response.value().nextMarker() != null) {
            result = result.concatWith((Publisher)this.containerAsyncRawClient.listBlobsFlatSegment(response.value().nextMarker(), options).flatMapMany(r -> this.listBlobsFlatHelper(options, (ContainersListBlobFlatSegmentResponse)((Object)r))));
        }
        return result;
    }

    public Flux<BlobItem> listBlobsHierarchy(String directory) {
        return this.listBlobsHierarchy("/", new ListBlobsOptions().prefix(directory));
    }

    public Flux<BlobItem> listBlobsHierarchy(String delimiter, ListBlobsOptions options) {
        return this.containerAsyncRawClient.listBlobsHierarchySegment(null, delimiter, options).flatMapMany(response -> this.listBlobsHierarchyHelper(delimiter, options, Context.NONE, (ContainersListBlobHierarchySegmentResponse)((Object)response)));
    }

    private Flux<BlobItem> listBlobsHierarchyHelper(String delimiter, ListBlobsOptions options, Context context, ContainersListBlobHierarchySegmentResponse response) {
        BlobHierarchyListSegment segment = response.value().segment();
        Flux blobs = segment != null && segment.blobItems() != null ? Flux.fromIterable(segment.blobItems()) : Flux.empty();
        Flux prefixes = segment != null && segment.blobPrefixes() != null ? Flux.fromIterable(segment.blobPrefixes()) : Flux.empty();
        Flux result = blobs.concatWith((Publisher)prefixes.map(prefix -> new BlobItem().name(prefix.name()).isPrefix(true)));
        if (response.value().nextMarker() != null) {
            result = result.concatWith((Publisher)this.containerAsyncRawClient.listBlobsHierarchySegment(response.value().nextMarker(), delimiter, options).flatMapMany(r -> this.listBlobsHierarchyHelper(delimiter, options, context, (ContainersListBlobHierarchySegmentResponse)((Object)r))));
        }
        return result;
    }

    public Mono<Response<String>> acquireLease(String proposedId, int duration) {
        return this.acquireLease(proposedId, duration, null);
    }

    public Mono<Response<String>> acquireLease(String proposedID, int duration, ModifiedAccessConditions modifiedAccessConditions) {
        return this.containerAsyncRawClient.acquireLease(proposedID, duration, modifiedAccessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)((ContainerAcquireLeaseHeaders)rb.deserializedHeaders()).leaseId()));
    }

    public Mono<Response<String>> renewLease(String leaseID) {
        return this.renewLease(leaseID, null);
    }

    public Mono<Response<String>> renewLease(String leaseID, ModifiedAccessConditions modifiedAccessConditions) {
        return this.containerAsyncRawClient.renewLease(leaseID, modifiedAccessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)((ContainerRenewLeaseHeaders)rb.deserializedHeaders()).leaseId()));
    }

    public Mono<VoidResponse> releaseLease(String leaseID) {
        return this.releaseLease(leaseID, null);
    }

    public Mono<VoidResponse> releaseLease(String leaseID, ModifiedAccessConditions modifiedAccessConditions) {
        return this.containerAsyncRawClient.releaseLease(leaseID, modifiedAccessConditions).map(VoidResponse::new);
    }

    public Mono<Response<Duration>> breakLease() {
        return this.breakLease(null, null);
    }

    public Mono<Response<Duration>> breakLease(Integer breakPeriodInSeconds, ModifiedAccessConditions modifiedAccessConditions) {
        return this.containerAsyncRawClient.breakLease(breakPeriodInSeconds, modifiedAccessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)Duration.ofSeconds(((ContainerBreakLeaseHeaders)rb.deserializedHeaders()).leaseTime().intValue())));
    }

    public Mono<Response<String>> changeLease(String leaseId, String proposedID) {
        return this.changeLease(leaseId, proposedID, null);
    }

    public Mono<Response<String>> changeLease(String leaseId, String proposedID, ModifiedAccessConditions modifiedAccessConditions) {
        return this.containerAsyncRawClient.changeLease(leaseId, proposedID, modifiedAccessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)((ContainerChangeLeaseHeaders)rb.deserializedHeaders()).leaseId()));
    }

    public Mono<Response<StorageAccountInfo>> getAccountInfo() {
        return this.containerAsyncRawClient.getAccountInfo().map(rb -> new SimpleResponse((Response)rb, (Object)new StorageAccountInfo((ContainerGetAccountInfoHeaders)rb.deserializedHeaders())));
    }
}

