/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.storage.blob.Utility;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.models.ContainerAccessConditions;
import com.azure.storage.blob.models.ContainerAccessPolicies;
import com.azure.storage.blob.models.ContainerGetAccessPolicyHeaders;
import com.azure.storage.blob.models.ContainersAcquireLeaseResponse;
import com.azure.storage.blob.models.ContainersBreakLeaseResponse;
import com.azure.storage.blob.models.ContainersChangeLeaseResponse;
import com.azure.storage.blob.models.ContainersCreateResponse;
import com.azure.storage.blob.models.ContainersDeleteResponse;
import com.azure.storage.blob.models.ContainersGetAccountInfoResponse;
import com.azure.storage.blob.models.ContainersGetPropertiesResponse;
import com.azure.storage.blob.models.ContainersListBlobFlatSegmentResponse;
import com.azure.storage.blob.models.ContainersListBlobHierarchySegmentResponse;
import com.azure.storage.blob.models.ContainersReleaseLeaseResponse;
import com.azure.storage.blob.models.ContainersRenewLeaseResponse;
import com.azure.storage.blob.models.ContainersSetAccessPolicyResponse;
import com.azure.storage.blob.models.ContainersSetMetadataResponse;
import com.azure.storage.blob.models.LeaseAccessConditions;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.models.Metadata;
import com.azure.storage.blob.models.ModifiedAccessConditions;
import com.azure.storage.blob.models.PublicAccessType;
import com.azure.storage.blob.models.SignedIdentifier;
import java.time.temporal.ChronoUnit;
import java.util.List;
import reactor.core.publisher.Mono;

final class ContainerAsyncRawClient {
    public static final String ROOT_CONTAINER_NAME = "$root";
    public static final String STATIC_WEBSITE_CONTAINER_NAME = "$web";
    public static final String LOG_CONTAINER_NAME = "$logs";
    AzureBlobStorageImpl azureBlobStorage;

    ContainerAsyncRawClient(AzureBlobStorageImpl azureBlobStorage) {
        this.azureBlobStorage = azureBlobStorage;
    }

    public Mono<ContainersCreateResponse> create() {
        return this.create(null, null);
    }

    public Mono<ContainersCreateResponse> create(Metadata metadata, PublicAccessType accessType) {
        metadata = metadata == null ? new Metadata() : metadata;
        return Utility.postProcessResponse(this.azureBlobStorage.containers().createWithRestResponseAsync(null, null, metadata, accessType, null, Context.NONE));
    }

    public Mono<ContainersDeleteResponse> delete() {
        return this.delete(null);
    }

    public Mono<ContainersDeleteResponse> delete(ContainerAccessConditions accessConditions) {
        ContainerAccessConditions containerAccessConditions = accessConditions = accessConditions == null ? new ContainerAccessConditions() : accessConditions;
        if (!this.validateNoEtag(accessConditions.modifiedAccessConditions())) {
            throw new UnsupportedOperationException("ETag access conditions are not supported for this API.");
        }
        return Utility.postProcessResponse(this.azureBlobStorage.containers().deleteWithRestResponseAsync(null, null, null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions(), Context.NONE));
    }

    public Mono<ContainersGetPropertiesResponse> getProperties() {
        return this.getProperties(null);
    }

    public Mono<ContainersGetPropertiesResponse> getProperties(LeaseAccessConditions leaseAccessConditions) {
        return Utility.postProcessResponse(this.azureBlobStorage.containers().getPropertiesWithRestResponseAsync(null, null, null, leaseAccessConditions, Context.NONE));
    }

    public Mono<ContainersSetMetadataResponse> setMetadata(Metadata metadata) {
        return this.setMetadata(metadata, null);
    }

    public Mono<ContainersSetMetadataResponse> setMetadata(Metadata metadata, ContainerAccessConditions accessConditions) {
        metadata = metadata == null ? new Metadata() : metadata;
        ContainerAccessConditions containerAccessConditions = accessConditions = accessConditions == null ? new ContainerAccessConditions() : accessConditions;
        if (!this.validateNoEtag(accessConditions.modifiedAccessConditions()) || accessConditions.modifiedAccessConditions().ifUnmodifiedSince() != null) {
            throw new UnsupportedOperationException("If-Modified-Since is the only HTTP access condition supported for this API");
        }
        return Utility.postProcessResponse(this.azureBlobStorage.containers().setMetadataWithRestResponseAsync(null, null, metadata, null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions(), Context.NONE));
    }

    public Mono<Response<ContainerAccessPolicies>> getAccessPolicy() {
        return this.getAccessPolicy(null);
    }

    public Mono<Response<ContainerAccessPolicies>> getAccessPolicy(LeaseAccessConditions leaseAccessConditions) {
        return Utility.postProcessResponse(this.azureBlobStorage.containers().getAccessPolicyWithRestResponseAsync(null, null, null, leaseAccessConditions, Context.NONE).map(response -> new SimpleResponse((Response)response, (Object)new ContainerAccessPolicies(((ContainerGetAccessPolicyHeaders)response.deserializedHeaders()).blobPublicAccess(), (List<SignedIdentifier>)response.value()))));
    }

    public Mono<ContainersSetAccessPolicyResponse> setAccessPolicy(PublicAccessType accessType, List<SignedIdentifier> identifiers) {
        return this.setAccessPolicy(accessType, identifiers, null);
    }

    public Mono<ContainersSetAccessPolicyResponse> setAccessPolicy(PublicAccessType accessType, List<SignedIdentifier> identifiers, ContainerAccessConditions accessConditions) {
        ContainerAccessConditions containerAccessConditions = accessConditions = accessConditions == null ? new ContainerAccessConditions() : accessConditions;
        if (!this.validateNoEtag(accessConditions.modifiedAccessConditions())) {
            throw new UnsupportedOperationException("ETag access conditions are not supported for this API.");
        }
        if (identifiers != null) {
            for (SignedIdentifier identifier : identifiers) {
                if (identifier.accessPolicy() != null && identifier.accessPolicy().start() != null) {
                    identifier.accessPolicy().start(identifier.accessPolicy().start().truncatedTo(ChronoUnit.SECONDS));
                }
                if (identifier.accessPolicy() == null || identifier.accessPolicy().expiry() == null) continue;
                identifier.accessPolicy().expiry(identifier.accessPolicy().expiry().truncatedTo(ChronoUnit.SECONDS));
            }
        }
        return Utility.postProcessResponse(this.azureBlobStorage.containers().setAccessPolicyWithRestResponseAsync(null, identifiers, null, accessType, null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions(), Context.NONE));
    }

    private boolean validateNoEtag(ModifiedAccessConditions modifiedAccessConditions) {
        if (modifiedAccessConditions == null) {
            return true;
        }
        return modifiedAccessConditions.ifMatch() == null && modifiedAccessConditions.ifNoneMatch() == null;
    }

    public Mono<ContainersAcquireLeaseResponse> acquireLease(String proposedId, int duration) {
        return this.acquireLease(proposedId, duration, null);
    }

    public Mono<ContainersAcquireLeaseResponse> acquireLease(String proposedID, int duration, ModifiedAccessConditions modifiedAccessConditions) {
        if (!this.validateNoEtag(modifiedAccessConditions)) {
            throw new UnsupportedOperationException("ETag access conditions are not supported for this API.");
        }
        return Utility.postProcessResponse(this.azureBlobStorage.containers().acquireLeaseWithRestResponseAsync(null, null, duration, proposedID, null, modifiedAccessConditions, Context.NONE));
    }

    public Mono<ContainersRenewLeaseResponse> renewLease(String leaseID) {
        return this.renewLease(leaseID, null);
    }

    public Mono<ContainersRenewLeaseResponse> renewLease(String leaseID, ModifiedAccessConditions modifiedAccessConditions) {
        if (!this.validateNoEtag(modifiedAccessConditions)) {
            throw new UnsupportedOperationException("ETag access conditions are not supported for this API.");
        }
        return Utility.postProcessResponse(this.azureBlobStorage.containers().renewLeaseWithRestResponseAsync(null, leaseID, null, null, modifiedAccessConditions, Context.NONE));
    }

    public Mono<ContainersReleaseLeaseResponse> releaseLease(String leaseID) {
        return this.releaseLease(leaseID, null);
    }

    public Mono<ContainersReleaseLeaseResponse> releaseLease(String leaseID, ModifiedAccessConditions modifiedAccessConditions) {
        if (!this.validateNoEtag(modifiedAccessConditions)) {
            throw new UnsupportedOperationException("ETag access conditions are not supported for this API.");
        }
        return Utility.postProcessResponse(this.azureBlobStorage.containers().releaseLeaseWithRestResponseAsync(null, leaseID, null, null, modifiedAccessConditions, Context.NONE));
    }

    public Mono<ContainersBreakLeaseResponse> breakLease() {
        return this.breakLease(null, null);
    }

    public Mono<ContainersBreakLeaseResponse> breakLease(Integer breakPeriodInSeconds, ModifiedAccessConditions modifiedAccessConditions) {
        if (!this.validateNoEtag(modifiedAccessConditions)) {
            throw new UnsupportedOperationException("ETag access conditions are not supported for this API.");
        }
        return Utility.postProcessResponse(this.azureBlobStorage.containers().breakLeaseWithRestResponseAsync(null, null, breakPeriodInSeconds, null, modifiedAccessConditions, Context.NONE));
    }

    public Mono<ContainersChangeLeaseResponse> changeLease(String leaseID, String proposedID) {
        return this.changeLease(leaseID, proposedID, null);
    }

    public Mono<ContainersChangeLeaseResponse> changeLease(String leaseID, String proposedID, ModifiedAccessConditions modifiedAccessConditions) {
        if (!this.validateNoEtag(modifiedAccessConditions)) {
            throw new UnsupportedOperationException("ETag access conditions are not supported for this API.");
        }
        return Utility.postProcessResponse(this.azureBlobStorage.containers().changeLeaseWithRestResponseAsync(null, leaseID, proposedID, null, null, modifiedAccessConditions, Context.NONE));
    }

    public Mono<ContainersListBlobFlatSegmentResponse> listBlobsFlatSegment(String marker, ListBlobsOptions options) {
        options = options == null ? new ListBlobsOptions() : options;
        return Utility.postProcessResponse(this.azureBlobStorage.containers().listBlobFlatSegmentWithRestResponseAsync(null, options.prefix(), marker, options.maxResults(), options.details().toList(), null, null, Context.NONE));
    }

    public Mono<ContainersListBlobHierarchySegmentResponse> listBlobsHierarchySegment(String marker, String delimiter, ListBlobsOptions options) {
        ListBlobsOptions listBlobsOptions = options = options == null ? new ListBlobsOptions() : options;
        if (options.details().snapshots()) {
            throw new UnsupportedOperationException("Including snapshots in a hierarchical listing is not supported.");
        }
        return Utility.postProcessResponse(this.azureBlobStorage.containers().listBlobHierarchySegmentWithRestResponseAsync(null, delimiter, options.prefix(), marker, options.maxResults(), options.details().toList(), null, null, Context.NONE));
    }

    public Mono<ContainersGetAccountInfoResponse> getAccountInfo() {
        return Utility.postProcessResponse(this.azureBlobStorage.containers().getAccountInfoWithRestResponseAsync(null, Context.NONE));
    }
}

