/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.VoidResponse;
import com.azure.storage.blob.AppendBlobClient;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlockBlobClient;
import com.azure.storage.blob.ContainerAsyncClient;
import com.azure.storage.blob.ContainerClientBuilder;
import com.azure.storage.blob.ContainerProperties;
import com.azure.storage.blob.PageBlobClient;
import com.azure.storage.blob.StorageClient;
import com.azure.storage.blob.Utility;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.ContainerAccessConditions;
import com.azure.storage.blob.models.ContainerAccessPolicies;
import com.azure.storage.blob.models.LeaseAccessConditions;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.models.Metadata;
import com.azure.storage.blob.models.ModifiedAccessConditions;
import com.azure.storage.blob.models.PublicAccessType;
import com.azure.storage.blob.models.SignedIdentifier;
import com.azure.storage.blob.models.StorageAccountInfo;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ContainerClient {
    private ContainerAsyncClient containerAsyncClient;
    public static final String ROOT_CONTAINER_NAME = "$root";
    public static final String STATIC_WEBSITE_CONTAINER_NAME = "$web";
    public static final String LOG_CONTAINER_NAME = "$logs";

    ContainerClient(ContainerAsyncClient containerAsyncClient) {
        this.containerAsyncClient = containerAsyncClient;
    }

    public static ContainerClientBuilder containerClientBuilder() {
        return new ContainerClientBuilder();
    }

    public BlockBlobClient getBlockBlobClient(String blobName) {
        return new BlockBlobClient(this.containerAsyncClient.getBlockBlobAsyncClient(blobName));
    }

    public BlockBlobClient getBlockBlobClient(String blobName, String snapshot) {
        return new BlockBlobClient(this.containerAsyncClient.getBlockBlobAsyncClient(blobName, snapshot));
    }

    public PageBlobClient getPageBlobClient(String blobName) {
        return new PageBlobClient(this.containerAsyncClient.getPageBlobAsyncClient(blobName));
    }

    public PageBlobClient getPageBlobClient(String blobName, String snapshot) {
        return new PageBlobClient(this.containerAsyncClient.getPageBlobAsyncClient(blobName, snapshot));
    }

    public AppendBlobClient getAppendBlobClient(String blobName) {
        return new AppendBlobClient(this.containerAsyncClient.getAppendBlobAsyncClient(blobName));
    }

    public BlobClient getBlobClient(String blobName) {
        return new BlobClient(this.containerAsyncClient.getBlobAsyncClient(blobName));
    }

    public BlobClient getBlobClient(String blobName, String snapshot) {
        return new BlobClient(this.containerAsyncClient.getBlobAsyncClient(blobName, snapshot));
    }

    public StorageClient getStorageClient() {
        return new StorageClient(this.containerAsyncClient.getStorageAsyncClient());
    }

    public URL getContainerUrl() {
        return this.containerAsyncClient.getContainerUrl();
    }

    public Response<Boolean> exists() {
        return this.exists(null);
    }

    public Response<Boolean> exists(Duration timeout) {
        Mono<Response<Boolean>> response = this.containerAsyncClient.exists();
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public VoidResponse create() {
        return this.create(null, null, null);
    }

    public VoidResponse create(Metadata metadata, PublicAccessType accessType, Duration timeout) {
        Mono<VoidResponse> response = this.containerAsyncClient.create(metadata, accessType);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public VoidResponse delete() {
        return this.delete(null, null);
    }

    public VoidResponse delete(ContainerAccessConditions accessConditions, Duration timeout) {
        Mono<VoidResponse> response = this.containerAsyncClient.delete(accessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<ContainerProperties> getProperties() {
        return this.getProperties(null, null);
    }

    public Response<ContainerProperties> getProperties(LeaseAccessConditions leaseAccessConditions, Duration timeout) {
        Mono<Response<ContainerProperties>> response = this.containerAsyncClient.getProperties(leaseAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public VoidResponse setMetadata(Metadata metadata) {
        return this.setMetadata(metadata, null, null);
    }

    public VoidResponse setMetadata(Metadata metadata, ContainerAccessConditions accessConditions, Duration timeout) {
        Mono<VoidResponse> response = this.containerAsyncClient.setMetadata(metadata, accessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<ContainerAccessPolicies> getAccessPolicy() {
        return this.getAccessPolicy(null, null);
    }

    public Response<ContainerAccessPolicies> getAccessPolicy(LeaseAccessConditions leaseAccessConditions, Duration timeout) {
        Mono<Response<ContainerAccessPolicies>> response = this.containerAsyncClient.getAccessPolicy(leaseAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public VoidResponse setAccessPolicy(PublicAccessType accessType, List<SignedIdentifier> identifiers) {
        return this.setAccessPolicy(accessType, identifiers, null, null);
    }

    public VoidResponse setAccessPolicy(PublicAccessType accessType, List<SignedIdentifier> identifiers, ContainerAccessConditions accessConditions, Duration timeout) {
        Mono<VoidResponse> response = this.containerAsyncClient.setAccessPolicy(accessType, identifiers, accessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Iterable<BlobItem> listBlobsFlat() {
        return this.listBlobsFlat(new ListBlobsOptions(), null);
    }

    public Iterable<BlobItem> listBlobsFlat(ListBlobsOptions options, Duration timeout) {
        Flux<BlobItem> response = this.containerAsyncClient.listBlobsFlat(options);
        return timeout == null ? response.toIterable() : response.timeout(timeout).toIterable();
    }

    public Iterable<BlobItem> listBlobsHierarchy(String directory) {
        return this.listBlobsHierarchy("/", new ListBlobsOptions().prefix(directory), null);
    }

    public Iterable<BlobItem> listBlobsHierarchy(String delimiter, ListBlobsOptions options, Duration timeout) {
        Flux<BlobItem> response = this.containerAsyncClient.listBlobsHierarchy(delimiter, options);
        return timeout == null ? response.toIterable() : response.timeout(timeout).toIterable();
    }

    public Response<String> acquireLease(String proposedId, int duration) {
        return this.acquireLease(proposedId, duration, null, null);
    }

    public Response<String> acquireLease(String proposedID, int duration, ModifiedAccessConditions modifiedAccessConditions, Duration timeout) {
        Mono<Response<String>> response = this.containerAsyncClient.acquireLease(proposedID, duration, modifiedAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<String> renewLease(String leaseID) {
        return this.renewLease(leaseID, null, null);
    }

    public Response<String> renewLease(String leaseID, ModifiedAccessConditions modifiedAccessConditions, Duration timeout) {
        Mono<Response<String>> response = this.containerAsyncClient.renewLease(leaseID, modifiedAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public VoidResponse releaseLease(String leaseID) {
        return this.releaseLease(leaseID, null, null);
    }

    public VoidResponse releaseLease(String leaseID, ModifiedAccessConditions modifiedAccessConditions, Duration timeout) {
        Mono<VoidResponse> response = this.containerAsyncClient.releaseLease(leaseID, modifiedAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<Duration> breakLease() {
        return this.breakLease(null, null, null);
    }

    public Response<Duration> breakLease(Integer breakPeriodInSeconds, ModifiedAccessConditions modifiedAccessConditions, Duration timeout) {
        Mono<Response<Duration>> response = this.containerAsyncClient.breakLease(breakPeriodInSeconds, modifiedAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<String> changeLease(String leaseId, String proposedID) {
        return this.changeLease(leaseId, proposedID, null, null);
    }

    public Response<String> changeLease(String leaseId, String proposedID, ModifiedAccessConditions modifiedAccessConditions, Duration timeout) {
        Mono<Response<String>> response = this.containerAsyncClient.changeLease(leaseId, proposedID, modifiedAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<StorageAccountInfo> getAccountInfo(Duration timeout) {
        Mono<Response<StorageAccountInfo>> response = this.containerAsyncClient.getAccountInfo();
        return Utility.blockWithOptionalTimeout(response, timeout);
    }
}

