/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.rest.Response;
import com.azure.storage.blob.ContainerAsyncRawClient;
import com.azure.storage.blob.Utility;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.models.ContainerAccessConditions;
import com.azure.storage.blob.models.ContainerAccessPolicies;
import com.azure.storage.blob.models.ContainersAcquireLeaseResponse;
import com.azure.storage.blob.models.ContainersBreakLeaseResponse;
import com.azure.storage.blob.models.ContainersChangeLeaseResponse;
import com.azure.storage.blob.models.ContainersCreateResponse;
import com.azure.storage.blob.models.ContainersDeleteResponse;
import com.azure.storage.blob.models.ContainersGetAccountInfoResponse;
import com.azure.storage.blob.models.ContainersGetPropertiesResponse;
import com.azure.storage.blob.models.ContainersListBlobFlatSegmentResponse;
import com.azure.storage.blob.models.ContainersListBlobHierarchySegmentResponse;
import com.azure.storage.blob.models.ContainersReleaseLeaseResponse;
import com.azure.storage.blob.models.ContainersRenewLeaseResponse;
import com.azure.storage.blob.models.ContainersSetAccessPolicyResponse;
import com.azure.storage.blob.models.ContainersSetMetadataResponse;
import com.azure.storage.blob.models.LeaseAccessConditions;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.models.Metadata;
import com.azure.storage.blob.models.ModifiedAccessConditions;
import com.azure.storage.blob.models.PublicAccessType;
import com.azure.storage.blob.models.SignedIdentifier;
import java.time.Duration;
import java.util.List;
import reactor.core.publisher.Mono;

final class ContainerRawClient {
    private ContainerAsyncRawClient containerAsyncRawClient;
    public static final String ROOT_CONTAINER_NAME = "$root";
    public static final String STATIC_WEBSITE_CONTAINER_NAME = "$web";
    public static final String LOG_CONTAINER_NAME = "$logs";

    public ContainerRawClient(AzureBlobStorageImpl azureBlobStorage) {
        this.containerAsyncRawClient = new ContainerAsyncRawClient(azureBlobStorage);
    }

    public ContainersCreateResponse create() {
        return this.create(null, null, null);
    }

    public ContainersCreateResponse create(Metadata metadata, PublicAccessType accessType, Duration timeout) {
        Mono<ContainersCreateResponse> response = this.containerAsyncRawClient.create(metadata, accessType);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public ContainersDeleteResponse delete() {
        return this.delete(null, null);
    }

    public ContainersDeleteResponse delete(ContainerAccessConditions accessConditions, Duration timeout) {
        Mono<ContainersDeleteResponse> response = this.containerAsyncRawClient.delete(accessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public ContainersGetPropertiesResponse getProperties() {
        return this.getProperties(null, null);
    }

    public ContainersGetPropertiesResponse getProperties(LeaseAccessConditions leaseAccessConditions, Duration timeout) {
        Mono<ContainersGetPropertiesResponse> response = this.containerAsyncRawClient.getProperties(leaseAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public ContainersSetMetadataResponse setMetadata(Metadata metadata) {
        return this.setMetadata(metadata, null, null);
    }

    public ContainersSetMetadataResponse setMetadata(Metadata metadata, ContainerAccessConditions accessConditions, Duration timeout) {
        Mono<ContainersSetMetadataResponse> response = this.containerAsyncRawClient.setMetadata(metadata, accessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<ContainerAccessPolicies> getAccessPolicy() {
        return this.getAccessPolicy(null, null);
    }

    public Response<ContainerAccessPolicies> getAccessPolicy(LeaseAccessConditions leaseAccessConditions, Duration timeout) {
        Mono<Response<ContainerAccessPolicies>> response = this.containerAsyncRawClient.getAccessPolicy(leaseAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public ContainersSetAccessPolicyResponse setAccessPolicy(PublicAccessType accessType, List<SignedIdentifier> identifiers) {
        return this.setAccessPolicy(accessType, identifiers, null, null);
    }

    public ContainersSetAccessPolicyResponse setAccessPolicy(PublicAccessType accessType, List<SignedIdentifier> identifiers, ContainerAccessConditions accessConditions, Duration timeout) {
        Mono<ContainersSetAccessPolicyResponse> response = this.containerAsyncRawClient.setAccessPolicy(accessType, identifiers, accessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public ContainersAcquireLeaseResponse acquireLease(String proposedId, int duration) {
        return this.acquireLease(proposedId, duration, null, null);
    }

    public ContainersAcquireLeaseResponse acquireLease(String proposedID, int duration, ModifiedAccessConditions modifiedAccessConditions, Duration timeout) {
        Mono<ContainersAcquireLeaseResponse> response = this.containerAsyncRawClient.acquireLease(proposedID, duration, modifiedAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public ContainersRenewLeaseResponse renewLease(String leaseID) {
        return this.renewLease(leaseID, null, null);
    }

    public ContainersRenewLeaseResponse renewLease(String leaseID, ModifiedAccessConditions modifiedAccessConditions, Duration timeout) {
        Mono<ContainersRenewLeaseResponse> response = this.containerAsyncRawClient.renewLease(leaseID, modifiedAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public ContainersReleaseLeaseResponse releaseLease(String leaseID) {
        return this.releaseLease(leaseID, null, null);
    }

    public ContainersReleaseLeaseResponse releaseLease(String leaseID, ModifiedAccessConditions modifiedAccessConditions, Duration timeout) {
        Mono<ContainersReleaseLeaseResponse> response = this.containerAsyncRawClient.releaseLease(leaseID, modifiedAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public ContainersBreakLeaseResponse breakLease() {
        return this.breakLease(null, null, null);
    }

    public ContainersBreakLeaseResponse breakLease(Integer breakPeriodInSeconds, ModifiedAccessConditions modifiedAccessConditions, Duration timeout) {
        Mono<ContainersBreakLeaseResponse> response = this.containerAsyncRawClient.breakLease(breakPeriodInSeconds, modifiedAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public ContainersChangeLeaseResponse changeLease(String leaseID, String proposedID) {
        return this.changeLease(leaseID, proposedID, null, null);
    }

    public ContainersChangeLeaseResponse changeLease(String leaseID, String proposedID, ModifiedAccessConditions modifiedAccessConditions, Duration timeout) {
        Mono<ContainersChangeLeaseResponse> response = this.containerAsyncRawClient.changeLease(leaseID, proposedID, modifiedAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public ContainersListBlobFlatSegmentResponse listBlobsFlatSegment(String marker, ListBlobsOptions options) {
        return this.listBlobsFlatSegment(marker, options, null);
    }

    public ContainersListBlobFlatSegmentResponse listBlobsFlatSegment(String marker, ListBlobsOptions options, Duration timeout) {
        Mono<ContainersListBlobFlatSegmentResponse> response = this.containerAsyncRawClient.listBlobsFlatSegment(marker, options);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public ContainersListBlobHierarchySegmentResponse listBlobsHierarchySegment(String marker, String delimiter, ListBlobsOptions options) {
        return this.listBlobsHierarchySegment(marker, delimiter, options, null);
    }

    public ContainersListBlobHierarchySegmentResponse listBlobsHierarchySegment(String marker, String delimiter, ListBlobsOptions options, Duration timeout) {
        Mono<ContainersListBlobHierarchySegmentResponse> response = this.containerAsyncRawClient.listBlobsHierarchySegment(marker, delimiter, options);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public ContainersGetAccountInfoResponse getAccountInfo() {
        return this.getAccountInfo(null);
    }

    public ContainersGetAccountInfoResponse getAccountInfo(Duration timeout) {
        Mono<ContainersGetAccountInfoResponse> response = this.containerAsyncRawClient.getAccountInfo();
        return Utility.blockWithOptionalTimeout(response, timeout);
    }
}

