/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.rest.ResponseBase;
import com.azure.storage.blob.HTTPGetterInfo;
import com.azure.storage.blob.Utility;
import com.azure.storage.blob.models.BlobDownloadHeaders;
import com.azure.storage.blob.models.ReliableDownloadOptions;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DownloadAsyncResponse {
    private final HTTPGetterInfo info;
    private final ResponseBase<BlobDownloadHeaders, Flux<ByteBuf>> rawResponse;
    private final Function<HTTPGetterInfo, Mono<DownloadAsyncResponse>> getter;

    public DownloadAsyncResponse(ResponseBase<BlobDownloadHeaders, Flux<ByteBuf>> response, HTTPGetterInfo info, Function<HTTPGetterInfo, Mono<DownloadAsyncResponse>> getter) {
        Utility.assertNotNull("getter", getter);
        Utility.assertNotNull("info", info);
        Utility.assertNotNull("info.eTag", info.eTag());
        this.rawResponse = response;
        this.info = info;
        this.getter = getter;
    }

    public Flux<ByteBuf> body(ReliableDownloadOptions options) {
        ReliableDownloadOptions optionsReal;
        ReliableDownloadOptions reliableDownloadOptions = optionsReal = options == null ? new ReliableDownloadOptions() : options;
        if (optionsReal.maxRetryRequests() == 0) {
            return (Flux)this.rawResponse.value();
        }
        return this.applyReliableDownload((Flux<ByteBuf>)((Flux)this.rawResponse.value()), -1, optionsReal);
    }

    private Flux<ByteBuf> tryContinueFlux(Throwable t, int retryCount, ReliableDownloadOptions options) {
        if (retryCount > options.maxRetryRequests() || !(t instanceof IOException)) {
            return Flux.error((Throwable)t);
        }
        try {
            return this.getter.apply(this.info).flatMapMany(response -> this.applyReliableDownload((Flux<ByteBuf>)((Flux)this.rawResponse.value()), retryCount, options));
        }
        catch (Exception e) {
            return Flux.error((Throwable)e);
        }
    }

    private Flux<ByteBuf> applyReliableDownload(Flux<ByteBuf> data, int currentRetryCount, ReliableDownloadOptions options) {
        return data.doOnNext(buffer -> {
            this.info.offset(this.info.offset() + (long)buffer.readableBytes());
            if (this.info.count() != null) {
                this.info.count(this.info.count() - (long)buffer.readableBytes());
            }
        }).onErrorResume(t2 -> this.tryContinueFlux((Throwable)t2, currentRetryCount + 1, options));
    }

    public int statusCode() {
        return this.rawResponse.statusCode();
    }

    public BlobDownloadHeaders headers() {
        return (BlobDownloadHeaders)this.rawResponse.deserializedHeaders();
    }

    public Map<String, String> rawHeaders() {
        return this.rawResponse.headers().toMap();
    }

    public ResponseBase<BlobDownloadHeaders, Flux<ByteBuf>> rawResponse() {
        return this.rawResponse;
    }
}

