/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.PageBlobAsyncRawClient;
import com.azure.storage.blob.PageBlobClientBuilder;
import com.azure.storage.blob.implementation.AzureBlobStorageBuilder;
import com.azure.storage.blob.models.BlobAccessConditions;
import com.azure.storage.blob.models.BlobHTTPHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.Metadata;
import com.azure.storage.blob.models.ModifiedAccessConditions;
import com.azure.storage.blob.models.PageBlobAccessConditions;
import com.azure.storage.blob.models.PageBlobClearPagesHeaders;
import com.azure.storage.blob.models.PageBlobCopyIncrementalHeaders;
import com.azure.storage.blob.models.PageBlobCreateHeaders;
import com.azure.storage.blob.models.PageBlobItem;
import com.azure.storage.blob.models.PageBlobResizeHeaders;
import com.azure.storage.blob.models.PageBlobUpdateSequenceNumberHeaders;
import com.azure.storage.blob.models.PageBlobUploadPagesFromURLHeaders;
import com.azure.storage.blob.models.PageBlobUploadPagesHeaders;
import com.azure.storage.blob.models.PageRange;
import com.azure.storage.blob.models.SequenceNumberActionType;
import com.azure.storage.blob.models.SourceModifiedAccessConditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.net.URL;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PageBlobAsyncClient
extends BlobAsyncClient {
    final PageBlobAsyncRawClient pageBlobAsyncRawClient;
    public static final int PAGE_BYTES = 512;
    public static final int MAX_PUT_PAGES_BYTES = 0x400000;

    PageBlobAsyncClient(AzureBlobStorageBuilder azureBlobStorageBuilder, String snapshot) {
        super(azureBlobStorageBuilder, snapshot);
        this.pageBlobAsyncRawClient = new PageBlobAsyncRawClient(azureBlobStorageBuilder.build(), snapshot);
    }

    public static PageBlobClientBuilder builder() {
        return new PageBlobClientBuilder();
    }

    public Mono<Response<PageBlobItem>> create(long size) {
        return this.create(size, null, null, null, null);
    }

    public Mono<Response<PageBlobItem>> create(long size, Long sequenceNumber, BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions) {
        return this.pageBlobAsyncRawClient.create(size, sequenceNumber, headers, metadata, accessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)new PageBlobItem((PageBlobCreateHeaders)rb.deserializedHeaders())));
    }

    public Mono<Response<PageBlobItem>> uploadPages(PageRange pageRange, Flux<ByteBuffer> body) {
        return this.uploadPages(pageRange, body, null);
    }

    public Mono<Response<PageBlobItem>> uploadPages(PageRange pageRange, Flux<ByteBuffer> body, PageBlobAccessConditions pageBlobAccessConditions) {
        return this.pageBlobAsyncRawClient.uploadPages(pageRange, (Flux<ByteBuf>)body.map(Unpooled::wrappedBuffer), pageBlobAccessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)new PageBlobItem((PageBlobUploadPagesHeaders)rb.deserializedHeaders())));
    }

    public Mono<Response<PageBlobItem>> uploadPagesFromURL(PageRange range, URL sourceURL, Long sourceOffset) {
        return this.uploadPagesFromURL(range, sourceURL, sourceOffset, null, null, null);
    }

    public Mono<Response<PageBlobItem>> uploadPagesFromURL(PageRange range, URL sourceURL, Long sourceOffset, byte[] sourceContentMD5, PageBlobAccessConditions destAccessConditions, SourceModifiedAccessConditions sourceAccessConditions) {
        return this.pageBlobAsyncRawClient.uploadPagesFromURL(range, sourceURL, sourceOffset, sourceContentMD5, destAccessConditions, sourceAccessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)new PageBlobItem((PageBlobUploadPagesFromURLHeaders)rb.deserializedHeaders())));
    }

    public Mono<Response<PageBlobItem>> clearPages(PageRange pageRange) {
        return this.clearPages(pageRange, null);
    }

    public Mono<Response<PageBlobItem>> clearPages(PageRange pageRange, PageBlobAccessConditions pageBlobAccessConditions) {
        return this.pageBlobAsyncRawClient.clearPages(pageRange, pageBlobAccessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)new PageBlobItem((PageBlobClearPagesHeaders)rb.deserializedHeaders())));
    }

    public Flux<PageRange> getPageRanges(BlobRange blobRange) {
        return this.getPageRanges(blobRange, null);
    }

    public Flux<PageRange> getPageRanges(BlobRange blobRange, BlobAccessConditions accessConditions) {
        return this.pageBlobAsyncRawClient.getPageRanges(blobRange, accessConditions).flatMapMany(response -> Flux.fromIterable(response.value().pageRange()));
    }

    public Flux<PageRange> getPageRangesDiff(BlobRange blobRange, String prevSnapshot) {
        return this.getPageRangesDiff(blobRange, prevSnapshot, null);
    }

    public Flux<PageRange> getPageRangesDiff(BlobRange blobRange, String prevSnapshot, BlobAccessConditions accessConditions) {
        return this.pageBlobAsyncRawClient.getPageRangesDiff(blobRange, prevSnapshot, accessConditions).flatMapMany(response -> Flux.fromIterable(response.value().pageRange()));
    }

    public Mono<Response<PageBlobItem>> resize(long size) {
        return this.resize(size, null);
    }

    public Mono<Response<PageBlobItem>> resize(long size, BlobAccessConditions accessConditions) {
        return this.pageBlobAsyncRawClient.resize(size, accessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)new PageBlobItem((PageBlobResizeHeaders)rb.deserializedHeaders())));
    }

    public Mono<Response<PageBlobItem>> updateSequenceNumber(SequenceNumberActionType action, Long sequenceNumber) {
        return this.updateSequenceNumber(action, sequenceNumber, null);
    }

    public Mono<Response<PageBlobItem>> updateSequenceNumber(SequenceNumberActionType action, Long sequenceNumber, BlobAccessConditions accessConditions) {
        return this.pageBlobAsyncRawClient.updateSequenceNumber(action, sequenceNumber, accessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)new PageBlobItem((PageBlobUpdateSequenceNumberHeaders)rb.deserializedHeaders())));
    }

    public Mono<Response<CopyStatusType>> copyIncremental(URL source, String snapshot) {
        return this.copyIncremental(source, snapshot, null);
    }

    public Mono<Response<CopyStatusType>> copyIncremental(URL source, String snapshot, ModifiedAccessConditions modifiedAccessConditions) {
        return this.pageBlobAsyncRawClient.copyIncremental(source, snapshot, modifiedAccessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)((PageBlobCopyIncrementalHeaders)rb.deserializedHeaders()).copyStatus()));
    }
}

