/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.implementation.http.UrlBuilder;
import com.azure.core.util.Context;
import com.azure.storage.blob.BlobAsyncRawClient;
import com.azure.storage.blob.Utility;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.models.BlobAccessConditions;
import com.azure.storage.blob.models.BlobHTTPHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.Metadata;
import com.azure.storage.blob.models.ModifiedAccessConditions;
import com.azure.storage.blob.models.PageBlobAccessConditions;
import com.azure.storage.blob.models.PageBlobsClearPagesResponse;
import com.azure.storage.blob.models.PageBlobsCopyIncrementalResponse;
import com.azure.storage.blob.models.PageBlobsCreateResponse;
import com.azure.storage.blob.models.PageBlobsGetPageRangesDiffResponse;
import com.azure.storage.blob.models.PageBlobsGetPageRangesResponse;
import com.azure.storage.blob.models.PageBlobsResizeResponse;
import com.azure.storage.blob.models.PageBlobsUpdateSequenceNumberResponse;
import com.azure.storage.blob.models.PageBlobsUploadPagesFromURLResponse;
import com.azure.storage.blob.models.PageBlobsUploadPagesResponse;
import com.azure.storage.blob.models.PageRange;
import com.azure.storage.blob.models.SequenceNumberActionType;
import com.azure.storage.blob.models.SourceModifiedAccessConditions;
import io.netty.buffer.ByteBuf;
import java.net.MalformedURLException;
import java.net.URL;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class PageBlobAsyncRawClient
extends BlobAsyncRawClient {
    public static final int PAGE_BYTES = 512;
    public static final int MAX_PUT_PAGES_BYTES = 0x400000;

    public PageBlobAsyncRawClient(AzureBlobStorageImpl azureBlobStorage, String snapshot) {
        super(azureBlobStorage, snapshot);
    }

    private static String pageRangeToString(PageRange pageRange) {
        if (pageRange.start() < 0L || pageRange.end() <= 0L) {
            throw new IllegalArgumentException("PageRange's start and end values must be greater than or equal to 0 if specified.");
        }
        if (pageRange.start() % 512L != 0L) {
            throw new IllegalArgumentException("PageRange's start value must be a multiple of 512.");
        }
        if (pageRange.end() % 512L != 511L) {
            throw new IllegalArgumentException("PageRange's end value must be 1 less than a multiple of 512.");
        }
        if (pageRange.end() <= pageRange.start()) {
            throw new IllegalArgumentException("PageRange's End value must be after the start.");
        }
        return "bytes=" + pageRange.start() + '-' + pageRange.end();
    }

    public Mono<PageBlobsCreateResponse> create(long size) {
        return this.create(size, null, null, null, null);
    }

    public Mono<PageBlobsCreateResponse> create(long size, Long sequenceNumber, BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions) {
        BlobAccessConditions blobAccessConditions = accessConditions = accessConditions == null ? new BlobAccessConditions() : accessConditions;
        if (size % 512L != 0L) {
            throw new IllegalArgumentException("size must be a multiple of PageBlobAsyncRawClient.PAGE_BYTES.");
        }
        if (sequenceNumber != null && sequenceNumber < 0L) {
            throw new IllegalArgumentException("SequenceNumber must be greater than or equal to 0.");
        }
        metadata = metadata == null ? new Metadata() : metadata;
        return Utility.postProcessResponse(this.azureBlobStorage.pageBlobs().createWithRestResponseAsync(null, null, 0L, size, null, metadata, null, null, null, sequenceNumber, null, headers, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions(), Context.NONE));
    }

    public Mono<PageBlobsUploadPagesResponse> uploadPages(PageRange pageRange, Flux<ByteBuf> body) {
        return this.uploadPages(pageRange, body, null);
    }

    public Mono<PageBlobsUploadPagesResponse> uploadPages(PageRange pageRange, Flux<ByteBuf> body, PageBlobAccessConditions pageBlobAccessConditions) {
        PageBlobAccessConditions pageBlobAccessConditions2 = pageBlobAccessConditions = pageBlobAccessConditions == null ? new PageBlobAccessConditions() : pageBlobAccessConditions;
        if (pageRange == null) {
            throw new IllegalArgumentException("pageRange cannot be null.");
        }
        String pageRangeStr = PageBlobAsyncRawClient.pageRangeToString(pageRange);
        return Utility.postProcessResponse(this.azureBlobStorage.pageBlobs().uploadPagesWithRestResponseAsync(null, null, body, pageRange.end() - pageRange.start() + 1L, null, null, pageRangeStr, null, null, null, null, pageBlobAccessConditions.leaseAccessConditions(), pageBlobAccessConditions.sequenceNumberAccessConditions(), pageBlobAccessConditions.modifiedAccessConditions(), Context.NONE));
    }

    public Mono<PageBlobsUploadPagesFromURLResponse> uploadPagesFromURL(PageRange range, URL sourceURL, Long sourceOffset) {
        return this.uploadPagesFromURL(range, sourceURL, sourceOffset, null, null, null);
    }

    public Mono<PageBlobsUploadPagesFromURLResponse> uploadPagesFromURL(PageRange range, URL sourceURL, Long sourceOffset, byte[] sourceContentMD5, PageBlobAccessConditions destAccessConditions, SourceModifiedAccessConditions sourceAccessConditions) {
        if (range == null) {
            throw new IllegalArgumentException("range cannot be null.");
        }
        String rangeString = PageBlobAsyncRawClient.pageRangeToString(range);
        if (sourceOffset == null) {
            sourceOffset = 0L;
        }
        String sourceRangeString = PageBlobAsyncRawClient.pageRangeToString(new PageRange().start(sourceOffset).end(sourceOffset + (range.end() - range.start())));
        destAccessConditions = destAccessConditions == null ? new PageBlobAccessConditions() : destAccessConditions;
        return Utility.postProcessResponse(this.azureBlobStorage.pageBlobs().uploadPagesFromURLWithRestResponseAsync(null, null, sourceURL, sourceRangeString, 0L, rangeString, sourceContentMD5, null, null, destAccessConditions.leaseAccessConditions(), destAccessConditions.sequenceNumberAccessConditions(), destAccessConditions.modifiedAccessConditions(), sourceAccessConditions, Context.NONE));
    }

    public Mono<PageBlobsClearPagesResponse> clearPages(PageRange pageRange) {
        return this.clearPages(pageRange, null);
    }

    public Mono<PageBlobsClearPagesResponse> clearPages(PageRange pageRange, PageBlobAccessConditions pageBlobAccessConditions) {
        PageBlobAccessConditions pageBlobAccessConditions2 = pageBlobAccessConditions = pageBlobAccessConditions == null ? new PageBlobAccessConditions() : pageBlobAccessConditions;
        if (pageRange == null) {
            throw new IllegalArgumentException("pageRange cannot be null.");
        }
        String pageRangeStr = PageBlobAsyncRawClient.pageRangeToString(pageRange);
        return Utility.postProcessResponse(this.azureBlobStorage.pageBlobs().clearPagesWithRestResponseAsync(null, null, 0L, null, pageRangeStr, null, pageBlobAccessConditions.leaseAccessConditions(), pageBlobAccessConditions.sequenceNumberAccessConditions(), pageBlobAccessConditions.modifiedAccessConditions(), Context.NONE));
    }

    public Mono<PageBlobsGetPageRangesResponse> getPageRanges(BlobRange blobRange) {
        return this.getPageRanges(blobRange, null);
    }

    public Mono<PageBlobsGetPageRangesResponse> getPageRanges(BlobRange blobRange, BlobAccessConditions accessConditions) {
        blobRange = blobRange == null ? new BlobRange(0L) : blobRange;
        accessConditions = accessConditions == null ? new BlobAccessConditions() : accessConditions;
        return Utility.postProcessResponse(this.azureBlobStorage.pageBlobs().getPageRangesWithRestResponseAsync(null, null, this.snapshot, null, null, blobRange.toHeaderValue(), null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions(), Context.NONE));
    }

    public Mono<PageBlobsGetPageRangesDiffResponse> getPageRangesDiff(BlobRange blobRange, String prevSnapshot) {
        return this.getPageRangesDiff(blobRange, prevSnapshot, null);
    }

    public Mono<PageBlobsGetPageRangesDiffResponse> getPageRangesDiff(BlobRange blobRange, String prevSnapshot, BlobAccessConditions accessConditions) {
        blobRange = blobRange == null ? new BlobRange(0L) : blobRange;
        BlobAccessConditions blobAccessConditions = accessConditions = accessConditions == null ? new BlobAccessConditions() : accessConditions;
        if (prevSnapshot == null) {
            throw new IllegalArgumentException("prevSnapshot cannot be null");
        }
        return Utility.postProcessResponse(this.azureBlobStorage.pageBlobs().getPageRangesDiffWithRestResponseAsync(null, null, this.snapshot, null, null, prevSnapshot, blobRange.toHeaderValue(), null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions(), Context.NONE));
    }

    public Mono<PageBlobsResizeResponse> resize(long size) {
        return this.resize(size, null);
    }

    public Mono<PageBlobsResizeResponse> resize(long size, BlobAccessConditions accessConditions) {
        if (size % 512L != 0L) {
            throw new IllegalArgumentException("size must be a multiple of PageBlobAsyncRawClient.PAGE_BYTES.");
        }
        accessConditions = accessConditions == null ? new BlobAccessConditions() : accessConditions;
        return Utility.postProcessResponse(this.azureBlobStorage.pageBlobs().resizeWithRestResponseAsync(null, null, size, null, null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions(), Context.NONE));
    }

    public Mono<PageBlobsUpdateSequenceNumberResponse> updateSequenceNumber(SequenceNumberActionType action, Long sequenceNumber) {
        return this.updateSequenceNumber(action, sequenceNumber, null);
    }

    public Mono<PageBlobsUpdateSequenceNumberResponse> updateSequenceNumber(SequenceNumberActionType action, Long sequenceNumber, BlobAccessConditions accessConditions) {
        if (sequenceNumber != null && sequenceNumber < 0L) {
            throw new IllegalArgumentException("SequenceNumber must be greater than or equal to 0.");
        }
        accessConditions = accessConditions == null ? new BlobAccessConditions() : accessConditions;
        sequenceNumber = action == SequenceNumberActionType.INCREMENT ? null : sequenceNumber;
        return Utility.postProcessResponse(this.azureBlobStorage.pageBlobs().updateSequenceNumberWithRestResponseAsync(null, null, action, null, sequenceNumber, null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions(), Context.NONE));
    }

    public Mono<PageBlobsCopyIncrementalResponse> copyIncremental(URL source, String snapshot) {
        return this.copyIncremental(source, snapshot, null);
    }

    public Mono<PageBlobsCopyIncrementalResponse> copyIncremental(URL source, String snapshot, ModifiedAccessConditions modifiedAccessConditions) {
        UrlBuilder builder = UrlBuilder.parse((URL)source);
        builder.setQueryParameter("snapshot", snapshot);
        try {
            source = builder.toURL();
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
        return Utility.postProcessResponse(this.azureBlobStorage.pageBlobs().copyIncrementalWithRestResponseAsync(null, null, source, null, null, modifiedAccessConditions, Context.NONE));
    }
}

