/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.rest.Response;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobOutputStream;
import com.azure.storage.blob.PageBlobAsyncClient;
import com.azure.storage.blob.PageBlobClientBuilder;
import com.azure.storage.blob.Utility;
import com.azure.storage.blob.models.BlobAccessConditions;
import com.azure.storage.blob.models.BlobHTTPHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.Metadata;
import com.azure.storage.blob.models.ModifiedAccessConditions;
import com.azure.storage.blob.models.PageBlobAccessConditions;
import com.azure.storage.blob.models.PageBlobItem;
import com.azure.storage.blob.models.PageRange;
import com.azure.storage.blob.models.SequenceNumberActionType;
import com.azure.storage.blob.models.SourceModifiedAccessConditions;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public final class PageBlobClient
extends BlobClient {
    private final PageBlobAsyncClient pageBlobAsyncClient;
    public static final int PAGE_BYTES = 512;
    public static final int MAX_PUT_PAGES_BYTES = 0x400000;

    PageBlobClient(PageBlobAsyncClient pageBlobAsyncClient) {
        super(pageBlobAsyncClient);
        this.pageBlobAsyncClient = pageBlobAsyncClient;
    }

    public static PageBlobClientBuilder pageBlobClientBuilder() {
        return new PageBlobClientBuilder();
    }

    public BlobOutputStream getBlobOutputStream(long length) {
        return this.getBlobOutputStream(length, null);
    }

    public BlobOutputStream getBlobOutputStream(long length, BlobAccessConditions accessConditions) {
        return new BlobOutputStream(this.pageBlobAsyncClient, length, accessConditions);
    }

    private static String pageRangeToString(PageRange pageRange) {
        if (pageRange.start() < 0L || pageRange.end() <= 0L) {
            throw new IllegalArgumentException("PageRange's start and end values must be greater than or equal to 0 if specified.");
        }
        if (pageRange.start() % 512L != 0L) {
            throw new IllegalArgumentException("PageRange's start value must be a multiple of 512.");
        }
        if (pageRange.end() % 512L != 511L) {
            throw new IllegalArgumentException("PageRange's end value must be 1 less than a multiple of 512.");
        }
        if (pageRange.end() <= pageRange.start()) {
            throw new IllegalArgumentException("PageRange's End value must be after the start.");
        }
        return "bytes=" + pageRange.start() + '-' + pageRange.end();
    }

    public Response<PageBlobItem> create(long size) {
        return this.create(size, null, null, null, null, null);
    }

    public Response<PageBlobItem> create(long size, Long sequenceNumber, BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions, Duration timeout) {
        Mono<Response<PageBlobItem>> response = this.pageBlobAsyncClient.create(size, sequenceNumber, headers, metadata, accessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<PageBlobItem> uploadPages(PageRange pageRange, InputStream body) {
        return this.uploadPages(pageRange, body, null, null);
    }

    public Response<PageBlobItem> uploadPages(PageRange pageRange, InputStream body, PageBlobAccessConditions pageBlobAccessConditions, Duration timeout) {
        long length = pageRange.end() - pageRange.start();
        Flux fbb = Flux.range((int)0, (int)((int)Math.ceil((double)length / 512.0))).map(i -> i * 512).concatMap(pos -> Mono.fromCallable(() -> {
            byte[] cache = new byte[512];
            int read = 0;
            while (read < 512) {
                read += body.read(cache, read, 512 - read);
            }
            return ByteBuffer.wrap(cache);
        }));
        Mono<Response<PageBlobItem>> response = this.pageBlobAsyncClient.uploadPages(pageRange, (Flux<ByteBuffer>)fbb.subscribeOn(Schedulers.elastic()), pageBlobAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<PageBlobItem> uploadPagesFromURL(PageRange range, URL sourceURL, Long sourceOffset) {
        return this.uploadPagesFromURL(range, sourceURL, sourceOffset, null, null, null, null);
    }

    public Response<PageBlobItem> uploadPagesFromURL(PageRange range, URL sourceURL, Long sourceOffset, byte[] sourceContentMD5, PageBlobAccessConditions destAccessConditions, SourceModifiedAccessConditions sourceAccessConditions, Duration timeout) {
        Mono<Response<PageBlobItem>> response = this.pageBlobAsyncClient.uploadPagesFromURL(range, sourceURL, sourceOffset, sourceContentMD5, destAccessConditions, sourceAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<PageBlobItem> clearPages(PageRange pageRange) {
        return this.clearPages(pageRange, null, null);
    }

    public Response<PageBlobItem> clearPages(PageRange pageRange, PageBlobAccessConditions pageBlobAccessConditions, Duration timeout) {
        Mono<Response<PageBlobItem>> response = this.pageBlobAsyncClient.clearPages(pageRange, pageBlobAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Iterable<PageRange> getPageRanges(BlobRange blobRange) {
        return this.getPageRanges(blobRange, null, null);
    }

    public Iterable<PageRange> getPageRanges(BlobRange blobRange, BlobAccessConditions accessConditions, Duration timeout) {
        Flux<PageRange> response = this.pageBlobAsyncClient.getPageRanges(blobRange, accessConditions);
        return timeout == null ? response.toIterable() : response.timeout(timeout).toIterable();
    }

    public Iterable<PageRange> getPageRangesDiff(BlobRange blobRange, String prevSnapshot) {
        return this.getPageRangesDiff(blobRange, prevSnapshot, null, null);
    }

    public Iterable<PageRange> getPageRangesDiff(BlobRange blobRange, String prevSnapshot, BlobAccessConditions accessConditions, Duration timeout) {
        Flux<PageRange> response = this.pageBlobAsyncClient.getPageRangesDiff(blobRange, prevSnapshot, accessConditions);
        return timeout == null ? response.toIterable() : response.timeout(timeout).toIterable();
    }

    public Response<PageBlobItem> resize(long size) {
        return this.resize(size, null, null);
    }

    public Response<PageBlobItem> resize(long size, BlobAccessConditions accessConditions, Duration timeout) {
        Mono<Response<PageBlobItem>> response = this.pageBlobAsyncClient.resize(size, accessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<PageBlobItem> updateSequenceNumber(SequenceNumberActionType action, Long sequenceNumber) {
        return this.updateSequenceNumber(action, sequenceNumber, null, null);
    }

    public Response<PageBlobItem> updateSequenceNumber(SequenceNumberActionType action, Long sequenceNumber, BlobAccessConditions accessConditions, Duration timeout) {
        Mono<Response<PageBlobItem>> response = this.pageBlobAsyncClient.updateSequenceNumber(action, sequenceNumber, accessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<CopyStatusType> copyIncremental(URL source, String snapshot) {
        return this.copyIncremental(source, snapshot, null, null);
    }

    public Response<CopyStatusType> copyIncremental(URL source, String snapshot, ModifiedAccessConditions modifiedAccessConditions, Duration timeout) {
        Mono<Response<CopyStatusType>> response = this.pageBlobAsyncClient.copyIncremental(source, snapshot, modifiedAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }
}

