/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.credentials.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.implementation.util.ImplUtils;
import com.azure.core.util.configuration.Configuration;
import com.azure.core.util.configuration.ConfigurationManager;
import com.azure.storage.blob.AnonymousCredentialPolicy;
import com.azure.storage.blob.BlobURLParts;
import com.azure.storage.blob.PageBlobAsyncClient;
import com.azure.storage.blob.PageBlobClient;
import com.azure.storage.blob.URLParser;
import com.azure.storage.blob.implementation.AzureBlobStorageBuilder;
import com.azure.storage.common.credentials.SASTokenCredential;
import com.azure.storage.common.credentials.SharedKeyCredential;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.common.policy.RequestRetryPolicy;
import com.azure.storage.common.policy.SASTokenCredentialPolicy;
import com.azure.storage.common.policy.SharedKeyCredentialPolicy;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public final class PageBlobClientBuilder {
    private static final String ACCOUNT_NAME = "accountname";
    private static final String ACCOUNT_KEY = "accountkey";
    private static final String ENDPOINT_PROTOCOL = "defaultendpointsprotocol";
    private static final String ENDPOINT_SUFFIX = "endpointsuffix";
    private final List<HttpPipelinePolicy> policies;
    private String endpoint;
    private String containerName;
    private String blobName;
    private String snapshot;
    private SharedKeyCredential sharedKeyCredential;
    private TokenCredential tokenCredential;
    private SASTokenCredential sasTokenCredential;
    private HttpClient httpClient;
    private HttpLogDetailLevel logLevel;
    private RequestRetryOptions retryOptions = new RequestRetryOptions();
    private Configuration configuration;

    public PageBlobClientBuilder() {
        this.logLevel = HttpLogDetailLevel.NONE;
        this.policies = new ArrayList<HttpPipelinePolicy>();
    }

    private AzureBlobStorageBuilder buildImpl() {
        Objects.requireNonNull(this.endpoint);
        Objects.requireNonNull(this.containerName);
        Objects.requireNonNull(this.blobName);
        ArrayList<Object> policies = new ArrayList<Object>();
        if (this.configuration == null) {
            this.configuration = ConfigurationManager.getConfiguration();
        }
        policies.add(new UserAgentPolicy("storage-blob", "1.0.0-SNAPSHOT", this.configuration));
        policies.add(new RequestIdPolicy());
        policies.add(new AddDatePolicy());
        if (this.sharedKeyCredential != null) {
            policies.add(new SharedKeyCredentialPolicy(this.sharedKeyCredential));
        } else if (this.tokenCredential != null) {
            policies.add(new BearerTokenAuthenticationPolicy(this.tokenCredential, String.format("%s/.default", this.endpoint)));
        } else if (this.sasTokenCredential != null) {
            policies.add(new SASTokenCredentialPolicy(this.sasTokenCredential));
        } else {
            policies.add(new AnonymousCredentialPolicy());
        }
        policies.add(new RequestRetryPolicy(this.retryOptions));
        policies.addAll(this.policies);
        policies.add(new HttpLoggingPolicy(this.logLevel));
        HttpPipeline pipeline = HttpPipeline.builder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).build();
        return new AzureBlobStorageBuilder().url(String.format("%s/%s/%s", this.endpoint.toString(), this.containerName, this.blobName)).pipeline(pipeline);
    }

    public PageBlobClient buildClient() {
        return new PageBlobClient(this.buildAsyncClient());
    }

    public PageBlobAsyncClient buildAsyncClient() {
        return new PageBlobAsyncClient(this.buildImpl(), this.snapshot);
    }

    public PageBlobClientBuilder endpoint(String endpoint) {
        URL url;
        Objects.requireNonNull(endpoint);
        try {
            url = new URL(endpoint);
            BlobURLParts parts = URLParser.parse(url);
            this.endpoint = String.valueOf(parts.scheme()) + "://" + parts.host();
            if (parts.containerName() != null) {
                this.containerName = parts.containerName();
            }
            if (parts.blobName() != null) {
                this.blobName = parts.blobName();
            }
            if (parts.snapshot() != null) {
                this.snapshot = parts.snapshot();
            }
        }
        catch (MalformedURLException | UnknownHostException iOException) {
            throw new IllegalArgumentException("The Azure Storage Blob endpoint url is malformed.");
        }
        SASTokenCredential credential = SASTokenCredential.fromQuery(url.getQuery());
        if (credential != null) {
            this.credential(credential);
        }
        return this;
    }

    public PageBlobClientBuilder containerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    public PageBlobClientBuilder blobName(String blobName) {
        this.blobName = blobName;
        return this;
    }

    public PageBlobClientBuilder snapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public PageBlobClientBuilder credential(SharedKeyCredential credential) {
        this.sharedKeyCredential = credential;
        this.tokenCredential = null;
        this.sasTokenCredential = null;
        return this;
    }

    public PageBlobClientBuilder credential(TokenCredential credential) {
        this.tokenCredential = credential;
        this.sharedKeyCredential = null;
        this.sasTokenCredential = null;
        return this;
    }

    public PageBlobClientBuilder credential(SASTokenCredential credential) {
        this.sasTokenCredential = credential;
        this.sharedKeyCredential = null;
        this.tokenCredential = null;
        return this;
    }

    public PageBlobClientBuilder anonymousCredential() {
        this.sharedKeyCredential = null;
        this.tokenCredential = null;
        this.sasTokenCredential = null;
        return this;
    }

    public PageBlobClientBuilder connectionString(String connectionString) {
        Objects.requireNonNull(connectionString);
        HashMap<String, String> connectionKVPs = new HashMap<String, String>();
        String[] stringArray = connectionString.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] kvp = s.split("=", 2);
            connectionKVPs.put(kvp[0].toLowerCase(), kvp[1]);
            ++n2;
        }
        String accountName = (String)connectionKVPs.get(ACCOUNT_NAME);
        String accountKey = (String)connectionKVPs.get(ACCOUNT_KEY);
        String endpointProtocol = (String)connectionKVPs.get(ENDPOINT_PROTOCOL);
        String endpointSuffix = (String)connectionKVPs.get(ENDPOINT_SUFFIX);
        if (ImplUtils.isNullOrEmpty((CharSequence)accountName) || ImplUtils.isNullOrEmpty((CharSequence)accountKey)) {
            throw new IllegalArgumentException("Connection string must contain 'AccountName' and 'AccountKey'.");
        }
        if (!ImplUtils.isNullOrEmpty((CharSequence)endpointProtocol) && !ImplUtils.isNullOrEmpty((CharSequence)endpointSuffix)) {
            String endpoint = String.format("%s://%s.blob.%s", endpointProtocol, accountName, endpointSuffix.replaceFirst("^\\.", ""));
            this.endpoint(endpoint);
        }
        return this.credential(new SharedKeyCredential(accountName, accountKey));
    }

    public PageBlobClientBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public PageBlobClientBuilder addPolicy(HttpPipelinePolicy pipelinePolicy) {
        this.policies.add(pipelinePolicy);
        return this;
    }

    public PageBlobClientBuilder httpLogDetailLevel(HttpLogDetailLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public PageBlobClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public PageBlobClientBuilder retryOptions(RequestRetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }
}

