/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.storage.blob.IPRange;
import com.azure.storage.blob.SASProtocol;
import com.azure.storage.blob.Utility;
import com.azure.storage.blob.models.UserDelegationKey;
import java.net.UnknownHostException;
import java.time.OffsetDateTime;
import java.util.Map;

final class SASQueryParameters {
    private final String version;
    private final String services;
    private final String resourceTypes;
    private final SASProtocol protocol;
    private final OffsetDateTime startTime;
    private final OffsetDateTime expiryTime;
    private final IPRange ipRange;
    private final String identifier;
    private final String keyOid;
    private final String keyTid;
    private final OffsetDateTime keyStart;
    private final OffsetDateTime keyExpiry;
    private final String keyService;
    private final String keyVersion;
    private final String resource;
    private final String permissions;
    private final String signature;
    private final String cacheControl;
    private final String contentDisposition;
    private final String contentEncoding;
    private final String contentLanguage;
    private final String contentType;

    SASQueryParameters(Map<String, String[]> queryParamsMap, boolean removeSASParametersFromMap) throws UnknownHostException {
        String[] queryValue = queryParamsMap.get("sv");
        if (queryValue != null) {
            this.version = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("sv");
            }
        } else {
            this.version = null;
        }
        if ((queryValue = queryParamsMap.get("ss")) != null) {
            this.services = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("ss");
            }
        } else {
            this.services = null;
        }
        if ((queryValue = queryParamsMap.get("srt")) != null) {
            this.resourceTypes = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("srt");
            }
        } else {
            this.resourceTypes = null;
        }
        if ((queryValue = queryParamsMap.get("spr")) != null) {
            this.protocol = SASProtocol.parse(queryValue[0]);
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("spr");
            }
        } else {
            this.protocol = null;
        }
        if ((queryValue = queryParamsMap.get("st")) != null) {
            this.startTime = Utility.parseDate(queryValue[0]);
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("st");
            }
        } else {
            this.startTime = null;
        }
        if ((queryValue = queryParamsMap.get("se")) != null) {
            this.expiryTime = Utility.parseDate(queryValue[0]);
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("se");
            }
        } else {
            this.expiryTime = null;
        }
        if ((queryValue = queryParamsMap.get("sip")) != null) {
            this.ipRange = IPRange.parse(queryValue[0]);
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("sip");
            }
        } else {
            this.ipRange = null;
        }
        if ((queryValue = queryParamsMap.get("si")) != null) {
            this.identifier = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("si");
            }
        } else {
            this.identifier = null;
        }
        if ((queryValue = queryParamsMap.get("skoid")) != null) {
            this.keyOid = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("skoid");
            }
        } else {
            this.keyOid = null;
        }
        if ((queryValue = queryParamsMap.get("sktid")) != null) {
            this.keyTid = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("sktid");
            }
        } else {
            this.keyTid = null;
        }
        if ((queryValue = queryParamsMap.get("skt")) != null) {
            this.keyStart = Utility.parseDate(queryValue[0]);
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("skt");
            }
        } else {
            this.keyStart = null;
        }
        if ((queryValue = queryParamsMap.get("ske")) != null) {
            this.keyExpiry = Utility.parseDate(queryValue[0]);
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("ske");
            }
        } else {
            this.keyExpiry = null;
        }
        if ((queryValue = queryParamsMap.get("sks")) != null) {
            this.keyService = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("sks");
            }
        } else {
            this.keyService = null;
        }
        if ((queryValue = queryParamsMap.get("skv")) != null) {
            this.keyVersion = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("skv");
            }
        } else {
            this.keyVersion = null;
        }
        if ((queryValue = queryParamsMap.get("sr")) != null) {
            this.resource = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("sr");
            }
        } else {
            this.resource = null;
        }
        if ((queryValue = queryParamsMap.get("sp")) != null) {
            this.permissions = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("sp");
            }
        } else {
            this.permissions = null;
        }
        if ((queryValue = queryParamsMap.get("sig")) != null) {
            this.signature = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("sig");
            }
        } else {
            this.signature = null;
        }
        if ((queryValue = queryParamsMap.get("rscc")) != null) {
            this.cacheControl = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("rscc");
            }
        } else {
            this.cacheControl = null;
        }
        if ((queryValue = queryParamsMap.get("rscd")) != null) {
            this.contentDisposition = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("rscd");
            }
        } else {
            this.contentDisposition = null;
        }
        if ((queryValue = queryParamsMap.get("rsce")) != null) {
            this.contentEncoding = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("rsce");
            }
        } else {
            this.contentEncoding = null;
        }
        if ((queryValue = queryParamsMap.get("rscl")) != null) {
            this.contentLanguage = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("rscl");
            }
        } else {
            this.contentLanguage = null;
        }
        if ((queryValue = queryParamsMap.get("rsct")) != null) {
            this.contentType = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("rsct");
            }
        } else {
            this.contentType = null;
        }
    }

    SASQueryParameters(String version, String services, String resourceTypes, SASProtocol protocol, OffsetDateTime startTime, OffsetDateTime expiryTime, IPRange ipRange, String identifier, String resource, String permissions, String signature, String cacheControl, String contentDisposition, String contentEncoding, String contentLanguage, String contentType, UserDelegationKey key) {
        this.version = version;
        this.services = services;
        this.resourceTypes = resourceTypes;
        this.protocol = protocol;
        this.startTime = startTime;
        this.expiryTime = expiryTime;
        this.ipRange = ipRange;
        this.identifier = identifier;
        this.resource = resource;
        this.permissions = permissions;
        this.signature = signature;
        this.cacheControl = cacheControl;
        this.contentDisposition = contentDisposition;
        this.contentEncoding = contentEncoding;
        this.contentLanguage = contentLanguage;
        this.contentType = contentType;
        if (key != null) {
            this.keyOid = key.signedOid();
            this.keyTid = key.signedTid();
            this.keyStart = key.signedStart();
            this.keyExpiry = key.signedExpiry();
            this.keyService = key.signedService();
            this.keyVersion = key.signedVersion();
        } else {
            this.keyOid = null;
            this.keyTid = null;
            this.keyStart = null;
            this.keyExpiry = null;
            this.keyService = null;
            this.keyVersion = null;
        }
    }

    public String version() {
        return this.version;
    }

    public String services() {
        return this.services;
    }

    public String resourceTypes() {
        return this.resourceTypes;
    }

    public SASProtocol protocol() {
        return this.protocol;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    public IPRange ipRange() {
        return this.ipRange;
    }

    public String identifier() {
        return this.identifier;
    }

    public String resource() {
        return this.resource;
    }

    public String permissions() {
        return this.permissions;
    }

    public String signature() {
        return this.signature;
    }

    public String cacheControl() {
        return this.cacheControl;
    }

    public String contentDisposition() {
        return this.contentDisposition;
    }

    public String contentEncoding() {
        return this.contentEncoding;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public String contentType() {
        return this.contentType;
    }

    public String keyOid() {
        return this.keyOid;
    }

    public String keyTid() {
        return this.keyTid;
    }

    public OffsetDateTime keyStart() {
        return this.keyStart;
    }

    public OffsetDateTime keyExpiry() {
        return this.keyExpiry;
    }

    public String keyService() {
        return this.keyService;
    }

    public String keyVersion() {
        return this.keyVersion;
    }

    UserDelegationKey userDelegationKey() {
        return new UserDelegationKey().signedExpiry(this.keyExpiry).signedOid(this.keyOid).signedService(this.keyService).signedStart(this.keyStart).signedTid(this.keyTid).signedVersion(this.keyVersion);
    }

    private void tryAppendQueryParameter(StringBuilder sb, String param, Object value) {
        if (value != null) {
            if (sb.length() == 0) {
                sb.append('?');
            } else {
                sb.append('&');
            }
            sb.append(Utility.safeURLEncode(param)).append('=').append(Utility.safeURLEncode(value.toString()));
        }
    }

    public String encode() {
        String[] params = new String[]{"sv", "ss", "srt", "spr", "st", "se", "sip", "si", "skoid", "sktid", "skt", "ske", "sks", "skv", "sr", "sp", "sig", "rscc", "rscd", "rsce", "rscl", "rsct"};
        StringBuilder sb = new StringBuilder();
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param;
            switch (param = stringArray[n2]) {
                case "sv": {
                    this.tryAppendQueryParameter(sb, param, this.version);
                    break;
                }
                case "ss": {
                    this.tryAppendQueryParameter(sb, param, this.services);
                    break;
                }
                case "srt": {
                    this.tryAppendQueryParameter(sb, param, this.resourceTypes);
                    break;
                }
                case "spr": {
                    this.tryAppendQueryParameter(sb, param, (Object)this.protocol);
                    break;
                }
                case "st": {
                    this.tryAppendQueryParameter(sb, param, this.startTime == null ? null : Utility.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime));
                    break;
                }
                case "se": {
                    this.tryAppendQueryParameter(sb, param, this.expiryTime == null ? null : Utility.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime));
                    break;
                }
                case "sip": {
                    this.tryAppendQueryParameter(sb, param, this.ipRange);
                    break;
                }
                case "si": {
                    this.tryAppendQueryParameter(sb, param, this.identifier);
                    break;
                }
                case "skoid": {
                    this.tryAppendQueryParameter(sb, param, this.keyOid);
                    break;
                }
                case "sktid": {
                    this.tryAppendQueryParameter(sb, param, this.keyTid);
                    break;
                }
                case "skt": {
                    this.tryAppendQueryParameter(sb, param, this.keyStart == null ? null : Utility.ISO_8601_UTC_DATE_FORMATTER.format(this.keyStart));
                    break;
                }
                case "ske": {
                    this.tryAppendQueryParameter(sb, param, this.keyExpiry == null ? null : Utility.ISO_8601_UTC_DATE_FORMATTER.format(this.keyExpiry));
                    break;
                }
                case "sks": {
                    this.tryAppendQueryParameter(sb, param, this.keyService);
                    break;
                }
                case "skv": {
                    this.tryAppendQueryParameter(sb, param, this.keyVersion);
                    break;
                }
                case "sr": {
                    this.tryAppendQueryParameter(sb, param, this.resource);
                    break;
                }
                case "sp": {
                    this.tryAppendQueryParameter(sb, param, this.permissions);
                    break;
                }
                case "sig": {
                    this.tryAppendQueryParameter(sb, param, this.signature);
                    break;
                }
                case "rscc": {
                    this.tryAppendQueryParameter(sb, param, this.cacheControl);
                    break;
                }
                case "rscd": {
                    this.tryAppendQueryParameter(sb, param, this.contentDisposition);
                    break;
                }
                case "rsce": {
                    this.tryAppendQueryParameter(sb, param, this.contentEncoding);
                    break;
                }
                case "rscl": {
                    this.tryAppendQueryParameter(sb, param, this.contentLanguage);
                    break;
                }
                case "rsct": {
                    this.tryAppendQueryParameter(sb, param, this.contentType);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid URL constant.");
                }
            }
            ++n2;
        }
        return sb.toString();
    }
}

