/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.http.rest.VoidResponse;
import com.azure.storage.blob.ContainerAsyncClient;
import com.azure.storage.blob.StorageAsyncRawClient;
import com.azure.storage.blob.StorageClientBuilder;
import com.azure.storage.blob.Utility;
import com.azure.storage.blob.implementation.AzureBlobStorageBuilder;
import com.azure.storage.blob.models.ContainerItem;
import com.azure.storage.blob.models.ListContainersOptions;
import com.azure.storage.blob.models.Metadata;
import com.azure.storage.blob.models.PublicAccessType;
import com.azure.storage.blob.models.ServiceGetAccountInfoHeaders;
import com.azure.storage.blob.models.ServicesListContainersSegmentResponse;
import com.azure.storage.blob.models.StorageAccountInfo;
import com.azure.storage.blob.models.StorageServiceProperties;
import com.azure.storage.blob.models.StorageServiceStats;
import com.azure.storage.blob.models.UserDelegationKey;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.OffsetDateTime;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class StorageAsyncClient {
    AzureBlobStorageBuilder azureBlobStorageBuilder;
    StorageAsyncRawClient storageAsyncRawClient;

    StorageAsyncClient(AzureBlobStorageBuilder azureBlobStorageBuilder) {
        this.storageAsyncRawClient = new StorageAsyncRawClient(azureBlobStorageBuilder.build());
    }

    public static StorageClientBuilder storageClientBuilder() {
        return new StorageClientBuilder();
    }

    public ContainerAsyncClient getContainerAsyncClient(String containerName) {
        return new ContainerAsyncClient(new AzureBlobStorageBuilder().url(Utility.appendToURLPath(this.getAccountUrl(), containerName).toString()).pipeline(this.storageAsyncRawClient.azureBlobStorage.httpPipeline()));
    }

    public Mono<Response<ContainerAsyncClient>> createContainer(String containerName) {
        return this.createContainer(containerName, null, null);
    }

    public Mono<Response<ContainerAsyncClient>> createContainer(String containerName, Metadata metadata, PublicAccessType accessType) {
        ContainerAsyncClient containerAsyncClient = this.getContainerAsyncClient(containerName);
        return containerAsyncClient.create(metadata, accessType).map(response -> new SimpleResponse((Response)response, (Object)containerAsyncClient));
    }

    public URL getAccountUrl() {
        try {
            return new URL(this.storageAsyncRawClient.azureBlobStorage.url());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(String.format("Invalid URL on %s: %s" + this.getClass().getSimpleName(), this.storageAsyncRawClient.azureBlobStorage.url()), e);
        }
    }

    public Flux<ContainerItem> listContainers() {
        return this.listContainers(new ListContainersOptions());
    }

    public Flux<ContainerItem> listContainers(ListContainersOptions options) {
        return this.storageAsyncRawClient.listContainersSegment(null, options).flatMapMany(response -> this.listContainersHelper(response.value().marker(), options, (ServicesListContainersSegmentResponse)((Object)response)));
    }

    private Flux<ContainerItem> listContainersHelper(String marker, ListContainersOptions options, ServicesListContainersSegmentResponse response) {
        Flux result = Flux.fromIterable(response.value().containerItems());
        if (response.value().nextMarker() != null) {
            result = result.concatWith((Publisher)this.storageAsyncRawClient.listContainersSegment(marker, options).flatMapMany(r -> this.listContainersHelper(response.value().nextMarker(), options, (ServicesListContainersSegmentResponse)((Object)r))));
        }
        return result;
    }

    public Mono<Response<StorageServiceProperties>> getProperties() {
        return this.storageAsyncRawClient.getProperties().map(rb -> new SimpleResponse((Response)rb, (Object)rb.value()));
    }

    public Mono<VoidResponse> setProperties(StorageServiceProperties properties) {
        return this.storageAsyncRawClient.setProperties(properties).map(VoidResponse::new);
    }

    public Mono<Response<UserDelegationKey>> getUserDelegationKey(OffsetDateTime start, OffsetDateTime expiry) {
        return this.storageAsyncRawClient.getUserDelegationKey(start, expiry).map(rb -> new SimpleResponse((Response)rb, (Object)rb.value()));
    }

    public Mono<Response<StorageServiceStats>> getStatistics() {
        return this.storageAsyncRawClient.getStatistics().map(rb -> new SimpleResponse((Response)rb, (Object)rb.value()));
    }

    public Mono<Response<StorageAccountInfo>> getAccountInfo() {
        return this.storageAsyncRawClient.getAccountInfo().map(rb -> new SimpleResponse((Response)rb, (Object)new StorageAccountInfo((ServiceGetAccountInfoHeaders)rb.deserializedHeaders())));
    }
}

