/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.util.Context;
import com.azure.storage.blob.Utility;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.models.KeyInfo;
import com.azure.storage.blob.models.ListContainersOptions;
import com.azure.storage.blob.models.ServicesGetAccountInfoResponse;
import com.azure.storage.blob.models.ServicesGetPropertiesResponse;
import com.azure.storage.blob.models.ServicesGetStatisticsResponse;
import com.azure.storage.blob.models.ServicesGetUserDelegationKeyResponse;
import com.azure.storage.blob.models.ServicesListContainersSegmentResponse;
import com.azure.storage.blob.models.ServicesSetPropertiesResponse;
import com.azure.storage.blob.models.StorageServiceProperties;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

final class StorageAsyncRawClient {
    final AzureBlobStorageImpl azureBlobStorage;

    public StorageAsyncRawClient(AzureBlobStorageImpl azureBlobStorage) {
        this.azureBlobStorage = azureBlobStorage;
    }

    public Mono<ServicesListContainersSegmentResponse> listContainersSegment(String marker, ListContainersOptions options) {
        options = options == null ? new ListContainersOptions() : options;
        return Utility.postProcessResponse(this.azureBlobStorage.services().listContainersSegmentWithRestResponseAsync(options.prefix(), marker, options.maxResults(), options.details().toIncludeType(), null, null, Context.NONE));
    }

    public Mono<ServicesGetPropertiesResponse> getProperties() {
        return Utility.postProcessResponse(this.azureBlobStorage.services().getPropertiesWithRestResponseAsync(null, null, Context.NONE));
    }

    public Mono<ServicesSetPropertiesResponse> setProperties(StorageServiceProperties properties) {
        return Utility.postProcessResponse(this.azureBlobStorage.services().setPropertiesWithRestResponseAsync(properties, null, null, Context.NONE));
    }

    public Mono<ServicesGetUserDelegationKeyResponse> getUserDelegationKey(OffsetDateTime start, OffsetDateTime expiry) {
        Utility.assertNotNull("expiry", expiry);
        if (start != null && !start.isBefore(expiry)) {
            throw new IllegalArgumentException("`start` must be null or a datetime before `expiry`.");
        }
        return Utility.postProcessResponse(this.azureBlobStorage.services().getUserDelegationKeyWithRestResponseAsync(new KeyInfo().start(start == null ? "" : Utility.ISO_8601_UTC_DATE_FORMATTER.format(start)).expiry(Utility.ISO_8601_UTC_DATE_FORMATTER.format(expiry)), null, null, Context.NONE));
    }

    public Mono<ServicesGetStatisticsResponse> getStatistics() {
        return Utility.postProcessResponse(this.azureBlobStorage.services().getStatisticsWithRestResponseAsync(null, null, Context.NONE));
    }

    public Mono<ServicesGetAccountInfoResponse> getAccountInfo() {
        return Utility.postProcessResponse(this.azureBlobStorage.services().getAccountInfoWithRestResponseAsync(Context.NONE));
    }
}

