/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.http.rest.VoidResponse;
import com.azure.storage.blob.ContainerClient;
import com.azure.storage.blob.StorageAsyncClient;
import com.azure.storage.blob.StorageClientBuilder;
import com.azure.storage.blob.Utility;
import com.azure.storage.blob.models.ContainerItem;
import com.azure.storage.blob.models.ListContainersOptions;
import com.azure.storage.blob.models.Metadata;
import com.azure.storage.blob.models.PublicAccessType;
import com.azure.storage.blob.models.StorageAccountInfo;
import com.azure.storage.blob.models.StorageServiceProperties;
import com.azure.storage.blob.models.StorageServiceStats;
import com.azure.storage.blob.models.UserDelegationKey;
import java.net.URL;
import java.time.Duration;
import java.time.OffsetDateTime;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class StorageClient {
    private StorageAsyncClient storageAsyncClient;

    StorageClient(StorageAsyncClient storageAsyncClient) {
        this.storageAsyncClient = storageAsyncClient;
    }

    public static StorageClientBuilder storageClientBuilder() {
        return new StorageClientBuilder();
    }

    public ContainerClient getContainerClient(String containerName) {
        return new ContainerClient(this.storageAsyncClient.getContainerAsyncClient(containerName));
    }

    public Response<ContainerClient> createContainer(String containerName) {
        return this.createContainer(containerName, null, null);
    }

    public Response<ContainerClient> createContainer(String containerName, Metadata metadata, PublicAccessType accessType) {
        ContainerClient client = this.getContainerClient(containerName);
        return new SimpleResponse((Response)client.create(metadata, accessType, null), (Object)client);
    }

    public URL getAccountUrl() {
        return this.storageAsyncClient.getAccountUrl();
    }

    public Iterable<ContainerItem> listContainers() {
        return this.listContainers(new ListContainersOptions(), null);
    }

    public Iterable<ContainerItem> listContainers(ListContainersOptions options, Duration timeout) {
        Flux<ContainerItem> response = this.storageAsyncClient.listContainers(options);
        return timeout == null ? response.toIterable() : response.timeout(timeout).toIterable();
    }

    public Response<StorageServiceProperties> getProperties() {
        return this.getProperties(null);
    }

    public Response<StorageServiceProperties> getProperties(Duration timeout) {
        Mono<Response<StorageServiceProperties>> response = this.storageAsyncClient.getProperties();
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public VoidResponse setProperties(StorageServiceProperties properties) {
        return this.setProperties(properties, null);
    }

    public VoidResponse setProperties(StorageServiceProperties properties, Duration timeout) {
        Mono<VoidResponse> response = this.storageAsyncClient.setProperties(properties);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<UserDelegationKey> getUserDelegationKey(OffsetDateTime start, OffsetDateTime expiry) {
        return this.getUserDelegationKey(start, expiry, null);
    }

    public Response<UserDelegationKey> getUserDelegationKey(OffsetDateTime start, OffsetDateTime expiry, Duration timeout) {
        Mono<Response<UserDelegationKey>> response = this.storageAsyncClient.getUserDelegationKey(start, expiry);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<StorageServiceStats> getStatistics() {
        return this.getStatistics(null);
    }

    public Response<StorageServiceStats> getStatistics(Duration timeout) {
        Mono<Response<StorageServiceStats>> response = this.storageAsyncClient.getStatistics();
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<StorageAccountInfo> getAccountInfo() {
        return this.getAccountInfo(null);
    }

    public Response<StorageAccountInfo> getAccountInfo(Duration timeout) {
        Mono<Response<StorageAccountInfo>> response = this.storageAsyncClient.getAccountInfo();
        return Utility.blockWithOptionalTimeout(response, timeout);
    }
}

