/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.storage.blob.StorageAsyncRawClient;
import com.azure.storage.blob.Utility;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.models.ListContainersOptions;
import com.azure.storage.blob.models.ServicesGetAccountInfoResponse;
import com.azure.storage.blob.models.ServicesGetPropertiesResponse;
import com.azure.storage.blob.models.ServicesGetStatisticsResponse;
import com.azure.storage.blob.models.ServicesGetUserDelegationKeyResponse;
import com.azure.storage.blob.models.ServicesListContainersSegmentResponse;
import com.azure.storage.blob.models.ServicesSetPropertiesResponse;
import com.azure.storage.blob.models.StorageServiceProperties;
import java.time.Duration;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

final class StorageRawClient {
    StorageAsyncRawClient storageAsyncRawClient;

    public StorageRawClient(AzureBlobStorageImpl azureBlobStorage) {
        this.storageAsyncRawClient = new StorageAsyncRawClient(azureBlobStorage);
    }

    public ServicesListContainersSegmentResponse listContainersSegment(String marker, ListContainersOptions options) {
        return this.listContainersSegment(marker, options, null);
    }

    public ServicesListContainersSegmentResponse listContainersSegment(String marker, ListContainersOptions options, Duration timeout) {
        Mono<ServicesListContainersSegmentResponse> response = this.storageAsyncRawClient.listContainersSegment(marker, options);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public ServicesGetPropertiesResponse getProperties() {
        return this.getProperties(null);
    }

    public ServicesGetPropertiesResponse getProperties(Duration timeout) {
        Mono<ServicesGetPropertiesResponse> response = this.storageAsyncRawClient.getProperties();
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public ServicesSetPropertiesResponse setProperties(StorageServiceProperties properties) {
        return this.setProperties(properties, null);
    }

    public ServicesSetPropertiesResponse setProperties(StorageServiceProperties properties, Duration timeout) {
        Mono<ServicesSetPropertiesResponse> response = this.storageAsyncRawClient.setProperties(properties);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public ServicesGetUserDelegationKeyResponse getUserDelegationKey(OffsetDateTime start, OffsetDateTime expiry) {
        return this.getUserDelegationKey(start, expiry, null);
    }

    public ServicesGetUserDelegationKeyResponse getUserDelegationKey(OffsetDateTime start, OffsetDateTime expiry, Duration timeout) {
        Mono<ServicesGetUserDelegationKeyResponse> response = this.storageAsyncRawClient.getUserDelegationKey(start, expiry);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public ServicesGetStatisticsResponse getStatistics() {
        return this.getStatistics(null);
    }

    public ServicesGetStatisticsResponse getStatistics(Duration timeout) {
        Mono<ServicesGetStatisticsResponse> response = this.storageAsyncRawClient.getStatistics();
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public ServicesGetAccountInfoResponse getAccountInfo() {
        return this.getAccountInfo(null);
    }

    public ServicesGetAccountInfoResponse getAccountInfo(Duration timeout) {
        Mono<ServicesGetAccountInfoResponse> response = this.storageAsyncRawClient.getAccountInfo();
        return Utility.blockWithOptionalTimeout(response, timeout);
    }
}

