/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.storage.blob.BlobURLParts;
import com.azure.storage.blob.SASQueryParameters;
import com.azure.storage.blob.Utility;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Comparator;
import java.util.Locale;
import java.util.TreeMap;

final class URLParser {
    URLParser() {
    }

    public static BlobURLParts parse(URL url) throws UnknownHostException {
        String scheme = url.getProtocol();
        String host = url.getHost();
        String containerName = null;
        String blobName = null;
        String path = url.getPath();
        if (!Utility.isNullOrEmpty(path)) {
            int containerEndIndex;
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if ((containerEndIndex = path.indexOf(47)) == -1) {
                containerName = path;
            } else {
                containerName = path.substring(0, containerEndIndex);
                blobName = path.substring(containerEndIndex + 1);
            }
        }
        TreeMap<String, String[]> queryParamsMap = URLParser.parseQueryString(url.getQuery());
        String snapshot = null;
        String[] snapshotArray = (String[])queryParamsMap.get("snapshot");
        if (snapshotArray != null) {
            snapshot = snapshotArray[0];
            queryParamsMap.remove("snapshot");
        }
        SASQueryParameters sasQueryParameters = new SASQueryParameters(queryParamsMap, true);
        return new BlobURLParts().scheme(scheme).host(host).containerName(containerName).blobName(blobName).snapshot(snapshot).sasQueryParameters(sasQueryParameters).unparsedParameters(queryParamsMap);
    }

    private static TreeMap<String, String[]> parseQueryString(String queryParams) {
        TreeMap<String, String[]> retVals = new TreeMap<String, String[]>(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareTo(s2);
            }
        });
        if (Utility.isNullOrEmpty(queryParams)) {
            return retVals;
        }
        String[] valuePairs = queryParams.split("&");
        int m = 0;
        while (m < valuePairs.length) {
            int equalDex = valuePairs[m].indexOf("=");
            String key = Utility.safeURLDecode(valuePairs[m].substring(0, equalDex)).toLowerCase(Locale.ROOT);
            String value = Utility.safeURLDecode(valuePairs[m].substring(equalDex + 1));
            String[] keyValues = retVals.get(key);
            if (keyValues == null) {
                keyValues = new String[]{value};
            } else {
                String[] newValues = new String[keyValues.length + 1];
                int j = 0;
                while (j < keyValues.length) {
                    newValues[j] = keyValues[j];
                    ++j;
                }
                newValues[newValues.length - 1] = value;
                keyValues = newValues;
            }
            retVals.put(key, keyValues);
            ++m;
        }
        return retVals;
    }
}

