/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.implementation.http.UrlBuilder;
import com.azure.storage.blob.StorageException;
import com.azure.storage.blob.models.StorageErrorException;
import com.azure.storage.blob.models.UserDelegationKey;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

final class Utility {
    static final DateTimeFormatter RFC_1123_GMT_DATE_FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z", Locale.ROOT).withZone(ZoneId.of("GMT"));
    static final DateTimeFormatter ISO_8601_UTC_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT).withZone(ZoneId.of("UTC"));
    static final ZoneId UTC_ZONE = ZoneId.of("UTC");
    private static final String MAX_PRECISION_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String ISO8601_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String ISO8601_PATTERN_NO_SECONDS = "yyyy-MM-dd'T'HH:mm'Z'";
    private static final int MAX_PRECISION_DATESTRING_LENGTH = "yyyy-MM-dd'T'HH:mm:ss.SSS".replaceAll("'", "").length();

    Utility() {
    }

    static void assertNotNull(String param, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The argument must not be null or an empty string. Argument name: %s.", param));
        }
    }

    static boolean isNullOrEmpty(String value) {
        return value == null || value.length() == 0;
    }

    static String safeURLDecode(String stringToDecode) {
        if (stringToDecode.length() == 0) {
            return "";
        }
        if (stringToDecode.contains("+")) {
            StringBuilder outBuilder = new StringBuilder();
            int startDex = 0;
            int m = 0;
            while (m < stringToDecode.length()) {
                if (stringToDecode.charAt(m) == '+') {
                    if (m > startDex) {
                        try {
                            outBuilder.append(URLDecoder.decode(stringToDecode.substring(startDex, m), "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new Error(e);
                        }
                    }
                    outBuilder.append("+");
                    startDex = m + 1;
                }
                ++m;
            }
            if (startDex != stringToDecode.length()) {
                try {
                    outBuilder.append(URLDecoder.decode(stringToDecode.substring(startDex, stringToDecode.length()), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error(e);
                }
            }
            return outBuilder.toString();
        }
        try {
            return URLDecoder.decode(stringToDecode, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public static OffsetDateTime parseDate(String dateString) {
        String pattern = MAX_PRECISION_PATTERN;
        switch (dateString.length()) {
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                dateString = dateString.substring(0, MAX_PRECISION_DATESTRING_LENGTH);
                break;
            }
            case 23: {
                dateString = dateString.replace("Z", "0");
                break;
            }
            case 22: {
                dateString = dateString.replace("Z", "00");
                break;
            }
            case 20: {
                pattern = ISO8601_PATTERN;
                break;
            }
            case 17: {
                pattern = ISO8601_PATTERN_NO_SECONDS;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid Date String: %s.", dateString));
            }
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, Locale.ROOT);
        return LocalDateTime.parse(dateString, formatter).atZone(UTC_ZONE).toOffsetDateTime();
    }

    public static void assertInBounds(String param, long value, long min, long max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The value of the parameter '%s' should be between %s and %s.", param, min, max));
        }
    }

    static String safeURLEncode(String stringToEncode) {
        if (stringToEncode == null) {
            return null;
        }
        if (stringToEncode.length() == 0) {
            return "";
        }
        try {
            String tString = URLEncoder.encode(stringToEncode, "UTF-8");
            if (stringToEncode.contains(" ")) {
                StringBuilder outBuilder = new StringBuilder();
                int startDex = 0;
                int m = 0;
                while (m < stringToEncode.length()) {
                    if (stringToEncode.charAt(m) == ' ') {
                        if (m > startDex) {
                            outBuilder.append(URLEncoder.encode(stringToEncode.substring(startDex, m), "UTF-8"));
                        }
                        outBuilder.append("%20");
                        startDex = m + 1;
                    }
                    ++m;
                }
                if (startDex != stringToEncode.length()) {
                    outBuilder.append(URLEncoder.encode(stringToEncode.substring(startDex, stringToEncode.length()), "UTF-8"));
                }
                return outBuilder.toString();
            }
            return tString;
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    static <T> Mono<T> postProcessResponse(Mono<T> s) {
        s = Utility.addErrorWrappingToSingle(s);
        s = Utility.scrubEtagHeaderInResponse(s);
        return s;
    }

    private static <T> Mono<T> addErrorWrappingToSingle(Mono<T> s) {
        return s.onErrorResume(StorageErrorException.class, e -> e.response().bodyAsString().switchIfEmpty(Mono.just((Object)"")).flatMap(body -> Mono.error((Throwable)((Object)new StorageException((StorageErrorException)((Object)e), (String)body)))));
    }

    private static <T> Mono<T> scrubEtagHeaderInResponse(Mono<T> s) {
        return s.map(response -> {
            String etag = null;
            try {
                Object headers = response.getClass().getMethod("deserializedHeaders", new Class[0]).invoke(response, new Object[0]);
                Method etagGetterMethod = headers.getClass().getMethod("eTag", new Class[0]);
                etag = (String)etagGetterMethod.invoke(headers, new Object[0]);
                if (etag == null) {
                    return response;
                }
                etag = etag.replace("\"", "");
                headers.getClass().getMethod("eTag", String.class).invoke(headers, etag);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {}
            try {
                HttpHeaders rawHeaders = (HttpHeaders)response.getClass().getMethod("headers", new Class[0]).invoke(response, new Object[0]);
                if (etag != null) {
                    rawHeaders.put("ETag", etag);
                } else {
                    HttpHeader eTagHeader = rawHeaders.get("etag");
                    if (eTagHeader != null && eTagHeader.value() != null) {
                        etag = eTagHeader.value().replace("\"", "");
                        rawHeaders.put("ETag", etag);
                    }
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {}
            return response;
        });
    }

    static String delegateComputeHmac256(UserDelegationKey delegate, String stringToSign) throws InvalidKeyException {
        try {
            byte[] key = Base64.getDecoder().decode(delegate.value());
            Mac hmacSha256 = Mac.getInstance("HmacSHA256");
            hmacSha256.init(new SecretKeySpec(key, "HmacSHA256"));
            byte[] utf8Bytes = stringToSign.getBytes(StandardCharsets.UTF_8);
            return Base64.getEncoder().encodeToString(hmacSha256.doFinal(utf8Bytes));
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
    }

    static URL appendToURLPath(URL baseURL, String name) {
        UrlBuilder url = UrlBuilder.parse((URL)baseURL);
        if (url.path() == null) {
            url.path("/");
        } else if (url.path().charAt(url.path().length() - 1) != '/') {
            url.path(String.valueOf(url.path()) + '/');
        }
        url.path(String.valueOf(url.path()) + name);
        try {
            return url.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    static URL stripLastPathSegment(URL baseURL) {
        UrlBuilder url = UrlBuilder.parse((URL)baseURL);
        if (url.path() != null || !url.path().contains("/")) {
            throw new IllegalArgumentException(String.format("URL %s does not contain path segments", baseURL));
        }
        String newPath = url.path().substring(0, url.path().lastIndexOf(47));
        url.path(newPath);
        try {
            return url.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    static <T> T blockWithOptionalTimeout(Mono<T> response, @Nullable Duration timeout) {
        if (timeout == null) {
            return (T)response.block();
        }
        return (T)response.block(timeout);
    }
}

