/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.implementation.RestProxy;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;

public final class AzureBlobStorageBuilder {
    private String url;
    private String version;
    private HttpPipeline pipeline;

    public AzureBlobStorageBuilder url(String url) {
        this.url = url;
        return this;
    }

    public AzureBlobStorageBuilder version(String version) {
        this.version = version;
        return this;
    }

    public AzureBlobStorageBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public AzureBlobStorageImpl build() {
        if (this.version == null) {
            this.version = "2018-11-09";
        }
        if (this.pipeline == null) {
            this.pipeline = RestProxy.createDefaultPipeline();
        }
        AzureBlobStorageImpl client = new AzureBlobStorageImpl(this.pipeline);
        if (this.url != null) {
            client.url(this.url);
        }
        if (this.version != null) {
            client.version(this.version);
        }
        return client;
    }
}

