/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.ServiceClient;
import com.azure.core.annotations.BodyParam;
import com.azure.core.annotations.DELETE;
import com.azure.core.annotations.ExpectedResponses;
import com.azure.core.annotations.GET;
import com.azure.core.annotations.HeaderParam;
import com.azure.core.annotations.Host;
import com.azure.core.annotations.HostParam;
import com.azure.core.annotations.PUT;
import com.azure.core.annotations.PathParam;
import com.azure.core.annotations.QueryParam;
import com.azure.core.annotations.Service;
import com.azure.core.annotations.UnexpectedResponseExceptionType;
import com.azure.core.implementation.CollectionFormat;
import com.azure.core.implementation.DateTimeRfc1123;
import com.azure.core.implementation.RestProxy;
import com.azure.core.implementation.serializer.jackson.JacksonAdapter;
import com.azure.core.util.Context;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.SignedIdentifiersWrapper;
import com.azure.storage.blob.models.ContainersAcquireLeaseResponse;
import com.azure.storage.blob.models.ContainersBreakLeaseResponse;
import com.azure.storage.blob.models.ContainersChangeLeaseResponse;
import com.azure.storage.blob.models.ContainersCreateResponse;
import com.azure.storage.blob.models.ContainersDeleteResponse;
import com.azure.storage.blob.models.ContainersGetAccessPolicyResponse;
import com.azure.storage.blob.models.ContainersGetAccountInfoResponse;
import com.azure.storage.blob.models.ContainersGetPropertiesResponse;
import com.azure.storage.blob.models.ContainersListBlobFlatSegmentResponse;
import com.azure.storage.blob.models.ContainersListBlobHierarchySegmentResponse;
import com.azure.storage.blob.models.ContainersReleaseLeaseResponse;
import com.azure.storage.blob.models.ContainersRenewLeaseResponse;
import com.azure.storage.blob.models.ContainersSetAccessPolicyResponse;
import com.azure.storage.blob.models.ContainersSetMetadataResponse;
import com.azure.storage.blob.models.LeaseAccessConditions;
import com.azure.storage.blob.models.ListBlobsIncludeItem;
import com.azure.storage.blob.models.ModifiedAccessConditions;
import com.azure.storage.blob.models.PublicAccessType;
import com.azure.storage.blob.models.SignedIdentifier;
import com.azure.storage.blob.models.StorageErrorException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class ContainersImpl {
    private ContainersService service;
    private AzureBlobStorageImpl client;

    public ContainersImpl(AzureBlobStorageImpl client) {
        this.service = (ContainersService)RestProxy.create(ContainersService.class, (ServiceClient)client);
        this.client = client;
    }

    public Mono<ContainersCreateResponse> createWithRestResponseAsync(String containerName, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        PublicAccessType access = null;
        String requestId = null;
        return this.service.create(containerName, this.client.url(), timeout, metadata, access, this.client.version(), requestId, "container", context);
    }

    public Mono<ContainersCreateResponse> createWithRestResponseAsync(String containerName, Integer timeout, Map<String, String> metadata, PublicAccessType access, String requestId, Context context) {
        return this.service.create(containerName, this.client.url(), timeout, metadata, access, this.client.version(), requestId, "container", context);
    }

    public Mono<ContainersGetPropertiesResponse> getPropertiesWithRestResponseAsync(String containerName, Context context) {
        Integer timeout = null;
        String requestId = null;
        String leaseId = null;
        return this.service.getProperties(containerName, this.client.url(), timeout, this.client.version(), requestId, "container", leaseId, context);
    }

    public Mono<ContainersGetPropertiesResponse> getPropertiesWithRestResponseAsync(String containerName, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, Context context) {
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        return this.service.getProperties(containerName, this.client.url(), timeout, this.client.version(), requestId, "container", leaseId, context);
    }

    public Mono<ContainersDeleteResponse> deleteWithRestResponseAsync(String containerName, Context context) {
        Integer timeout = null;
        String requestId = null;
        String leaseId = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.delete(containerName, this.client.url(), timeout, this.client.version(), requestId, "container", leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<ContainersDeleteResponse> deleteWithRestResponseAsync(String containerName, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.delete(containerName, this.client.url(), timeout, this.client.version(), requestId, "container", leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<ContainersSetMetadataResponse> setMetadataWithRestResponseAsync(String containerName, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        String requestId = null;
        String leaseId = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        return this.service.setMetadata(containerName, this.client.url(), timeout, metadata, this.client.version(), requestId, "container", "metadata", leaseId, ifModifiedSinceConverted, context);
    }

    public Mono<ContainersSetMetadataResponse> setMetadataWithRestResponseAsync(String containerName, Integer timeout, Map<String, String> metadata, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        return this.service.setMetadata(containerName, this.client.url(), timeout, metadata, this.client.version(), requestId, "container", "metadata", leaseId, ifModifiedSinceConverted, context);
    }

    public Mono<ContainersGetAccessPolicyResponse> getAccessPolicyWithRestResponseAsync(String containerName, Context context) {
        Integer timeout = null;
        String requestId = null;
        String leaseId = null;
        return this.service.getAccessPolicy(containerName, this.client.url(), timeout, this.client.version(), requestId, "container", "acl", leaseId, context);
    }

    public Mono<ContainersGetAccessPolicyResponse> getAccessPolicyWithRestResponseAsync(String containerName, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, Context context) {
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        return this.service.getAccessPolicy(containerName, this.client.url(), timeout, this.client.version(), requestId, "container", "acl", leaseId, context);
    }

    public Mono<ContainersSetAccessPolicyResponse> setAccessPolicyWithRestResponseAsync(String containerName, Context context) {
        Integer timeout = null;
        PublicAccessType access = null;
        String requestId = null;
        String leaseId = null;
        SignedIdentifiersWrapper containerAclConverted = new SignedIdentifiersWrapper(null);
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.setAccessPolicy(containerName, this.client.url(), containerAclConverted, timeout, access, this.client.version(), requestId, "container", "acl", leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<ContainersSetAccessPolicyResponse> setAccessPolicyWithRestResponseAsync(String containerName, List<SignedIdentifier> containerAcl, Integer timeout, PublicAccessType access, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        SignedIdentifiersWrapper containerAclConverted = new SignedIdentifiersWrapper(containerAcl);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.setAccessPolicy(containerName, this.client.url(), containerAclConverted, timeout, access, this.client.version(), requestId, "container", "acl", leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<ContainersAcquireLeaseResponse> acquireLeaseWithRestResponseAsync(String containerName, Context context) {
        Integer timeout = null;
        Integer duration = null;
        String proposedLeaseId = null;
        String requestId = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.acquireLease(containerName, this.client.url(), timeout, duration, proposedLeaseId, this.client.version(), requestId, "lease", "container", "acquire", ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<ContainersAcquireLeaseResponse> acquireLeaseWithRestResponseAsync(String containerName, Integer timeout, Integer duration, String proposedLeaseId, String requestId, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.acquireLease(containerName, this.client.url(), timeout, duration, proposedLeaseId, this.client.version(), requestId, "lease", "container", "acquire", ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<ContainersReleaseLeaseResponse> releaseLeaseWithRestResponseAsync(String containerName, String leaseId, Context context) {
        Integer timeout = null;
        String requestId = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.releaseLease(containerName, this.client.url(), timeout, leaseId, this.client.version(), requestId, "lease", "container", "release", ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<ContainersReleaseLeaseResponse> releaseLeaseWithRestResponseAsync(String containerName, String leaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.releaseLease(containerName, this.client.url(), timeout, leaseId, this.client.version(), requestId, "lease", "container", "release", ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<ContainersRenewLeaseResponse> renewLeaseWithRestResponseAsync(String containerName, String leaseId, Context context) {
        Integer timeout = null;
        String requestId = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.renewLease(containerName, this.client.url(), timeout, leaseId, this.client.version(), requestId, "lease", "container", "renew", ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<ContainersRenewLeaseResponse> renewLeaseWithRestResponseAsync(String containerName, String leaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.renewLease(containerName, this.client.url(), timeout, leaseId, this.client.version(), requestId, "lease", "container", "renew", ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<ContainersBreakLeaseResponse> breakLeaseWithRestResponseAsync(String containerName, Context context) {
        Integer timeout = null;
        Integer breakPeriod = null;
        String requestId = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.breakLease(containerName, this.client.url(), timeout, breakPeriod, this.client.version(), requestId, "lease", "container", "break", ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<ContainersBreakLeaseResponse> breakLeaseWithRestResponseAsync(String containerName, Integer timeout, Integer breakPeriod, String requestId, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.breakLease(containerName, this.client.url(), timeout, breakPeriod, this.client.version(), requestId, "lease", "container", "break", ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<ContainersChangeLeaseResponse> changeLeaseWithRestResponseAsync(String containerName, String leaseId, String proposedLeaseId, Context context) {
        Integer timeout = null;
        String requestId = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.changeLease(containerName, this.client.url(), timeout, leaseId, proposedLeaseId, this.client.version(), requestId, "lease", "container", "change", ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<ContainersChangeLeaseResponse> changeLeaseWithRestResponseAsync(String containerName, String leaseId, String proposedLeaseId, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.changeLease(containerName, this.client.url(), timeout, leaseId, proposedLeaseId, this.client.version(), requestId, "lease", "container", "change", ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<ContainersListBlobFlatSegmentResponse> listBlobFlatSegmentWithRestResponseAsync(String containerName, Context context) {
        String prefix = null;
        String marker = null;
        Integer maxresults = null;
        Integer timeout = null;
        String requestId = null;
        String includeConverted = null;
        return this.service.listBlobFlatSegment(containerName, this.client.url(), prefix, marker, maxresults, includeConverted, timeout, this.client.version(), requestId, "container", "list", context);
    }

    public Mono<ContainersListBlobFlatSegmentResponse> listBlobFlatSegmentWithRestResponseAsync(String containerName, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId, Context context) {
        String includeConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(include, CollectionFormat.CSV);
        return this.service.listBlobFlatSegment(containerName, this.client.url(), prefix, marker, maxresults, includeConverted, timeout, this.client.version(), requestId, "container", "list", context);
    }

    public Mono<ContainersListBlobHierarchySegmentResponse> listBlobHierarchySegmentWithRestResponseAsync(String containerName, String delimiter, Context context) {
        String prefix = null;
        String marker = null;
        Integer maxresults = null;
        Integer timeout = null;
        String requestId = null;
        String includeConverted = null;
        return this.service.listBlobHierarchySegment(containerName, this.client.url(), prefix, delimiter, marker, maxresults, includeConverted, timeout, this.client.version(), requestId, "container", "list", context);
    }

    public Mono<ContainersListBlobHierarchySegmentResponse> listBlobHierarchySegmentWithRestResponseAsync(String containerName, String delimiter, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId, Context context) {
        String includeConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(include, CollectionFormat.CSV);
        return this.service.listBlobHierarchySegment(containerName, this.client.url(), prefix, delimiter, marker, maxresults, includeConverted, timeout, this.client.version(), requestId, "container", "list", context);
    }

    public Mono<ContainersGetAccountInfoResponse> getAccountInfoWithRestResponseAsync(String containerName, Context context) {
        return this.service.getAccountInfo(containerName, this.client.url(), this.client.version(), "account", "properties", context);
    }

    @Host(value="{url}")
    @Service(value="Storage Blobs Containers")
    private static interface ContainersService {
        @PUT(value="{containerName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<ContainersCreateResponse> create(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-blob-public-access") PublicAccessType var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="restype") String var8, Context var9);

        @GET(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<ContainersGetPropertiesResponse> getProperties(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="restype") String var6, @HeaderParam(value="x-ms-lease-id") String var7, Context var8);

        @DELETE(value="{containerName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<ContainersDeleteResponse> delete(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="restype") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, Context var10);

        @PUT(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<ContainersSetMetadataResponse> setMetadata(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="restype") String var7, @QueryParam(value="comp") String var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var10, Context var11);

        @GET(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<ContainersGetAccessPolicyResponse> getAccessPolicy(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="restype") String var6, @QueryParam(value="comp") String var7, @HeaderParam(value="x-ms-lease-id") String var8, Context var9);

        @PUT(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<ContainersSetAccessPolicyResponse> setAccessPolicy(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @BodyParam(value="application/xml; charset=utf-8") SignedIdentifiersWrapper var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-blob-public-access") PublicAccessType var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="restype") String var8, @QueryParam(value="comp") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var12, Context var13);

        @PUT(value="{containerName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<ContainersAcquireLeaseResponse> acquireLease(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-duration") Integer var4, @HeaderParam(value="x-ms-proposed-lease-id") String var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="comp") String var8, @QueryParam(value="restype") String var9, @HeaderParam(value="x-ms-lease-action") String var10, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var12, Context var13);

        @PUT(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<ContainersReleaseLeaseResponse> releaseLease(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="comp") String var7, @QueryParam(value="restype") String var8, @HeaderParam(value="x-ms-lease-action") String var9, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var11, Context var12);

        @PUT(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<ContainersRenewLeaseResponse> renewLease(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="comp") String var7, @QueryParam(value="restype") String var8, @HeaderParam(value="x-ms-lease-action") String var9, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var11, Context var12);

        @PUT(value="{containerName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<ContainersBreakLeaseResponse> breakLease(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-break-period") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="comp") String var7, @QueryParam(value="restype") String var8, @HeaderParam(value="x-ms-lease-action") String var9, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var11, Context var12);

        @PUT(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<ContainersChangeLeaseResponse> changeLease(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="x-ms-proposed-lease-id") String var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="comp") String var8, @QueryParam(value="restype") String var9, @HeaderParam(value="x-ms-lease-action") String var10, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var12, Context var13);

        @GET(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<ContainersListBlobFlatSegmentResponse> listBlobFlatSegment(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="include") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @QueryParam(value="restype") String var10, @QueryParam(value="comp") String var11, Context var12);

        @GET(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<ContainersListBlobHierarchySegmentResponse> listBlobHierarchySegment(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="delimiter") String var4, @QueryParam(value="marker") String var5, @QueryParam(value="maxresults") Integer var6, @QueryParam(value="include") String var7, @QueryParam(value="timeout") Integer var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @QueryParam(value="restype") String var11, @QueryParam(value="comp") String var12, Context var13);

        @GET(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<ContainersGetAccountInfoResponse> getAccountInfo(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-version") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, Context var6);
    }
}

