/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.ServiceClient;
import com.azure.core.annotations.BodyParam;
import com.azure.core.annotations.ExpectedResponses;
import com.azure.core.annotations.GET;
import com.azure.core.annotations.HeaderParam;
import com.azure.core.annotations.Host;
import com.azure.core.annotations.HostParam;
import com.azure.core.annotations.PUT;
import com.azure.core.annotations.PathParam;
import com.azure.core.annotations.QueryParam;
import com.azure.core.annotations.Service;
import com.azure.core.annotations.UnexpectedResponseExceptionType;
import com.azure.core.implementation.DateTimeRfc1123;
import com.azure.core.implementation.RestProxy;
import com.azure.core.implementation.util.Base64Util;
import com.azure.core.util.Context;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.models.BlobHTTPHeaders;
import com.azure.storage.blob.models.EncryptionAlgorithmType;
import com.azure.storage.blob.models.LeaseAccessConditions;
import com.azure.storage.blob.models.ModifiedAccessConditions;
import com.azure.storage.blob.models.PageBlobsClearPagesResponse;
import com.azure.storage.blob.models.PageBlobsCopyIncrementalResponse;
import com.azure.storage.blob.models.PageBlobsCreateResponse;
import com.azure.storage.blob.models.PageBlobsGetPageRangesDiffResponse;
import com.azure.storage.blob.models.PageBlobsGetPageRangesResponse;
import com.azure.storage.blob.models.PageBlobsResizeResponse;
import com.azure.storage.blob.models.PageBlobsUpdateSequenceNumberResponse;
import com.azure.storage.blob.models.PageBlobsUploadPagesFromURLResponse;
import com.azure.storage.blob.models.PageBlobsUploadPagesResponse;
import com.azure.storage.blob.models.SequenceNumberAccessConditions;
import com.azure.storage.blob.models.SequenceNumberActionType;
import com.azure.storage.blob.models.SourceModifiedAccessConditions;
import com.azure.storage.blob.models.StorageErrorException;
import io.netty.buffer.ByteBuf;
import java.net.URL;
import java.time.OffsetDateTime;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PageBlobsImpl {
    private PageBlobsService service;
    private AzureBlobStorageImpl client;

    public PageBlobsImpl(AzureBlobStorageImpl client) {
        this.service = (PageBlobsService)RestProxy.create(PageBlobsService.class, (ServiceClient)client);
        this.client = client;
    }

    public Mono<PageBlobsCreateResponse> createWithRestResponseAsync(String containerName, String blob, long contentLength, long blobContentLength, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        String encryptionKey = null;
        String encryptionKeySha256 = null;
        EncryptionAlgorithmType encryptionAlgorithm = null;
        Long blobSequenceNumber = 0L;
        String requestId = null;
        String blobContentType = null;
        String blobContentEncoding = null;
        String blobContentLanguage = null;
        String blobCacheControl = null;
        String blobContentDisposition = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String blobContentMD5Converted = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.create(containerName, blob, this.client.url(), timeout, contentLength, metadata, encryptionKey, encryptionKeySha256, encryptionAlgorithm, blobContentLength, blobSequenceNumber, this.client.version(), requestId, "PageBlob", blobContentType, blobContentEncoding, blobContentLanguage, blobContentMD5Converted, blobCacheControl, blobContentDisposition, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, context);
    }

    public Mono<PageBlobsCreateResponse> createWithRestResponseAsync(String containerName, String blob, long contentLength, long blobContentLength, Integer timeout, Map<String, String> metadata, String encryptionKey, String encryptionKeySha256, EncryptionAlgorithmType encryptionAlgorithm, Long blobSequenceNumber, String requestId, BlobHTTPHeaders blobHTTPHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String blobContentType = null;
        if (blobHTTPHeaders != null) {
            blobContentType = blobHTTPHeaders.blobContentType();
        }
        String blobContentEncoding = null;
        if (blobHTTPHeaders != null) {
            blobContentEncoding = blobHTTPHeaders.blobContentEncoding();
        }
        String blobContentLanguage = null;
        if (blobHTTPHeaders != null) {
            blobContentLanguage = blobHTTPHeaders.blobContentLanguage();
        }
        byte[] blobContentMD5 = null;
        if (blobHTTPHeaders != null) {
            blobContentMD5 = blobHTTPHeaders.blobContentMD5();
        }
        String blobCacheControl = null;
        if (blobHTTPHeaders != null) {
            blobCacheControl = blobHTTPHeaders.blobCacheControl();
        }
        String blobContentDisposition = null;
        if (blobHTTPHeaders != null) {
            blobContentDisposition = blobHTTPHeaders.blobContentDisposition();
        }
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        String blobContentMD5Converted = Base64Util.encodeToString((byte[])blobContentMD5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.create(containerName, blob, this.client.url(), timeout, contentLength, metadata, encryptionKey, encryptionKeySha256, encryptionAlgorithm, blobContentLength, blobSequenceNumber, this.client.version(), requestId, "PageBlob", blobContentType, blobContentEncoding, blobContentLanguage, blobContentMD5Converted, blobCacheControl, blobContentDisposition, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, context);
    }

    public Mono<PageBlobsUploadPagesResponse> uploadPagesWithRestResponseAsync(String containerName, String blob, Flux<ByteBuf> body, long contentLength, Context context) {
        Integer timeout = null;
        String range = null;
        String encryptionKey = null;
        String encryptionKeySha256 = null;
        EncryptionAlgorithmType encryptionAlgorithm = null;
        String requestId = null;
        String leaseId = null;
        Long ifSequenceNumberLessThanOrEqualTo = null;
        Long ifSequenceNumberLessThan = null;
        Long ifSequenceNumberEqualTo = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String transactionalContentMD5Converted = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.uploadPages(containerName, blob, this.client.url(), body, contentLength, transactionalContentMD5Converted, timeout, range, encryptionKey, encryptionKeySha256, encryptionAlgorithm, this.client.version(), requestId, "page", "update", leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, context);
    }

    public Mono<PageBlobsUploadPagesResponse> uploadPagesWithRestResponseAsync(String containerName, String blob, Flux<ByteBuf> body, long contentLength, byte[] transactionalContentMD5, Integer timeout, String range, String encryptionKey, String encryptionKeySha256, EncryptionAlgorithmType encryptionAlgorithm, String requestId, LeaseAccessConditions leaseAccessConditions, SequenceNumberAccessConditions sequenceNumberAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        Long ifSequenceNumberLessThanOrEqualTo = null;
        if (sequenceNumberAccessConditions != null) {
            ifSequenceNumberLessThanOrEqualTo = sequenceNumberAccessConditions.ifSequenceNumberLessThanOrEqualTo();
        }
        Long ifSequenceNumberLessThan = null;
        if (sequenceNumberAccessConditions != null) {
            ifSequenceNumberLessThan = sequenceNumberAccessConditions.ifSequenceNumberLessThan();
        }
        Long ifSequenceNumberEqualTo = null;
        if (sequenceNumberAccessConditions != null) {
            ifSequenceNumberEqualTo = sequenceNumberAccessConditions.ifSequenceNumberEqualTo();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        String transactionalContentMD5Converted = Base64Util.encodeToString((byte[])transactionalContentMD5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.uploadPages(containerName, blob, this.client.url(), body, contentLength, transactionalContentMD5Converted, timeout, range, encryptionKey, encryptionKeySha256, encryptionAlgorithm, this.client.version(), requestId, "page", "update", leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, context);
    }

    public Mono<PageBlobsClearPagesResponse> clearPagesWithRestResponseAsync(String containerName, String blob, long contentLength, Context context) {
        Integer timeout = null;
        String range = null;
        String requestId = null;
        String leaseId = null;
        Long ifSequenceNumberLessThanOrEqualTo = null;
        Long ifSequenceNumberLessThan = null;
        Long ifSequenceNumberEqualTo = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.clearPages(containerName, blob, this.client.url(), contentLength, timeout, range, this.client.version(), requestId, "page", "clear", leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, context);
    }

    public Mono<PageBlobsClearPagesResponse> clearPagesWithRestResponseAsync(String containerName, String blob, long contentLength, Integer timeout, String range, String requestId, LeaseAccessConditions leaseAccessConditions, SequenceNumberAccessConditions sequenceNumberAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        Long ifSequenceNumberLessThanOrEqualTo = null;
        if (sequenceNumberAccessConditions != null) {
            ifSequenceNumberLessThanOrEqualTo = sequenceNumberAccessConditions.ifSequenceNumberLessThanOrEqualTo();
        }
        Long ifSequenceNumberLessThan = null;
        if (sequenceNumberAccessConditions != null) {
            ifSequenceNumberLessThan = sequenceNumberAccessConditions.ifSequenceNumberLessThan();
        }
        Long ifSequenceNumberEqualTo = null;
        if (sequenceNumberAccessConditions != null) {
            ifSequenceNumberEqualTo = sequenceNumberAccessConditions.ifSequenceNumberEqualTo();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.clearPages(containerName, blob, this.client.url(), contentLength, timeout, range, this.client.version(), requestId, "page", "clear", leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, context);
    }

    public Mono<PageBlobsUploadPagesFromURLResponse> uploadPagesFromURLWithRestResponseAsync(String containerName, String blob, URL sourceUrl, String sourceRange, long contentLength, String range, Context context) {
        Integer timeout = null;
        String requestId = null;
        String leaseId = null;
        Long ifSequenceNumberLessThanOrEqualTo = null;
        Long ifSequenceNumberLessThan = null;
        Long ifSequenceNumberEqualTo = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String sourceIfMatch = null;
        String sourceIfNoneMatch = null;
        String sourceContentMD5Converted = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        DateTimeRfc1123 sourceIfModifiedSinceConverted = null;
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = null;
        return this.service.uploadPagesFromURL(containerName, blob, this.client.url(), sourceUrl, sourceRange, sourceContentMD5Converted, contentLength, timeout, range, this.client.version(), requestId, "page", "update", leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, context);
    }

    public Mono<PageBlobsUploadPagesFromURLResponse> uploadPagesFromURLWithRestResponseAsync(String containerName, String blob, URL sourceUrl, String sourceRange, long contentLength, String range, byte[] sourceContentMD5, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, SequenceNumberAccessConditions sequenceNumberAccessConditions, ModifiedAccessConditions modifiedAccessConditions, SourceModifiedAccessConditions sourceModifiedAccessConditions, Context context) {
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        Long ifSequenceNumberLessThanOrEqualTo = null;
        if (sequenceNumberAccessConditions != null) {
            ifSequenceNumberLessThanOrEqualTo = sequenceNumberAccessConditions.ifSequenceNumberLessThanOrEqualTo();
        }
        Long ifSequenceNumberLessThan = null;
        if (sequenceNumberAccessConditions != null) {
            ifSequenceNumberLessThan = sequenceNumberAccessConditions.ifSequenceNumberLessThan();
        }
        Long ifSequenceNumberEqualTo = null;
        if (sequenceNumberAccessConditions != null) {
            ifSequenceNumberEqualTo = sequenceNumberAccessConditions.ifSequenceNumberEqualTo();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        OffsetDateTime sourceIfModifiedSince = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfModifiedSince = sourceModifiedAccessConditions.sourceIfModifiedSince();
        }
        OffsetDateTime sourceIfUnmodifiedSince = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfUnmodifiedSince = sourceModifiedAccessConditions.sourceIfUnmodifiedSince();
        }
        String sourceIfMatch = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfMatch = sourceModifiedAccessConditions.sourceIfMatch();
        }
        String sourceIfNoneMatch = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfNoneMatch = sourceModifiedAccessConditions.sourceIfNoneMatch();
        }
        String sourceContentMD5Converted = Base64Util.encodeToString((byte[])sourceContentMD5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return this.service.uploadPagesFromURL(containerName, blob, this.client.url(), sourceUrl, sourceRange, sourceContentMD5Converted, contentLength, timeout, range, this.client.version(), requestId, "page", "update", leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, context);
    }

    public Mono<PageBlobsGetPageRangesResponse> getPageRangesWithRestResponseAsync(String containerName, String blob, Context context) {
        String snapshot = null;
        String versionId = null;
        Integer timeout = null;
        String range = null;
        String requestId = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.getPageRanges(containerName, blob, this.client.url(), snapshot, versionId, timeout, range, this.client.version(), requestId, "pagelist", leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, context);
    }

    public Mono<PageBlobsGetPageRangesResponse> getPageRangesWithRestResponseAsync(String containerName, String blob, String snapshot, String versionId, Integer timeout, String range, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.getPageRanges(containerName, blob, this.client.url(), snapshot, versionId, timeout, range, this.client.version(), requestId, "pagelist", leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, context);
    }

    public Mono<PageBlobsGetPageRangesDiffResponse> getPageRangesDiffWithRestResponseAsync(String containerName, String blob, Context context) {
        String snapshot = null;
        String versionId = null;
        Integer timeout = null;
        String prevsnapshot = null;
        String range = null;
        String requestId = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.getPageRangesDiff(containerName, blob, this.client.url(), snapshot, versionId, timeout, prevsnapshot, range, this.client.version(), requestId, "pagelist", leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, context);
    }

    public Mono<PageBlobsGetPageRangesDiffResponse> getPageRangesDiffWithRestResponseAsync(String containerName, String blob, String snapshot, String versionId, Integer timeout, String prevsnapshot, String range, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.getPageRangesDiff(containerName, blob, this.client.url(), snapshot, versionId, timeout, prevsnapshot, range, this.client.version(), requestId, "pagelist", leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, context);
    }

    public Mono<PageBlobsResizeResponse> resizeWithRestResponseAsync(String containerName, String blob, long blobContentLength, Context context) {
        Integer timeout = null;
        String requestId = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.resize(containerName, blob, this.client.url(), timeout, blobContentLength, this.client.version(), requestId, "properties", leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, context);
    }

    public Mono<PageBlobsResizeResponse> resizeWithRestResponseAsync(String containerName, String blob, long blobContentLength, Integer timeout, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.resize(containerName, blob, this.client.url(), timeout, blobContentLength, this.client.version(), requestId, "properties", leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, context);
    }

    public Mono<PageBlobsUpdateSequenceNumberResponse> updateSequenceNumberWithRestResponseAsync(String containerName, String blob, SequenceNumberActionType sequenceNumberAction, Context context) {
        Integer timeout = null;
        Long blobSequenceNumber = 0L;
        String requestId = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.updateSequenceNumber(containerName, blob, this.client.url(), timeout, sequenceNumberAction, blobSequenceNumber, this.client.version(), requestId, "properties", leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, context);
    }

    public Mono<PageBlobsUpdateSequenceNumberResponse> updateSequenceNumberWithRestResponseAsync(String containerName, String blob, SequenceNumberActionType sequenceNumberAction, Integer timeout, Long blobSequenceNumber, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.leaseId();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.updateSequenceNumber(containerName, blob, this.client.url(), timeout, sequenceNumberAction, blobSequenceNumber, this.client.version(), requestId, "properties", leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, context);
    }

    public Mono<PageBlobsCopyIncrementalResponse> copyIncrementalWithRestResponseAsync(String containerName, String blob, URL copySource, Context context) {
        Integer timeout = null;
        String requestId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.copyIncremental(containerName, blob, this.client.url(), timeout, copySource, this.client.version(), requestId, "incrementalcopy", ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, context);
    }

    public Mono<PageBlobsCopyIncrementalResponse> copyIncrementalWithRestResponseAsync(String containerName, String blob, URL copySource, Integer timeout, String requestId, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.ifModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.ifUnmodifiedSince();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.ifMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.ifNoneMatch();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.copyIncremental(containerName, blob, this.client.url(), timeout, copySource, this.client.version(), requestId, "incrementalcopy", ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, context);
    }

    @Host(value="{url}")
    @Service(value="Storage Blobs PageBlobs")
    private static interface PageBlobsService {
        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<PageBlobsCreateResponse> create(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="Content-Length") long var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var7, @QueryParam(value="x-ms-encryption-key") String var8, @QueryParam(value="x-ms-encryption-key-sha256") String var9, @QueryParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var10, @HeaderParam(value="x-ms-blob-content-length") long var11, @HeaderParam(value="x-ms-blob-sequence-number") Long var13, @HeaderParam(value="x-ms-version") String var14, @HeaderParam(value="x-ms-client-request-id") String var15, @HeaderParam(value="x-ms-blob-type") String var16, @HeaderParam(value="x-ms-blob-content-type") String var17, @HeaderParam(value="x-ms-blob-content-encoding") String var18, @HeaderParam(value="x-ms-blob-content-language") String var19, @HeaderParam(value="x-ms-blob-content-md5") String var20, @HeaderParam(value="x-ms-blob-cache-control") String var21, @HeaderParam(value="x-ms-blob-content-disposition") String var22, @HeaderParam(value="x-ms-lease-id") String var23, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var24, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var25, @HeaderParam(value="If-Match") String var26, @HeaderParam(value="If-None-Match") String var27, Context var28);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<PageBlobsUploadPagesResponse> uploadPages(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @BodyParam(value="application/octet-stream") Flux<ByteBuf> var4, @HeaderParam(value="Content-Length") long var5, @HeaderParam(value="Content-MD5") String var7, @QueryParam(value="timeout") Integer var8, @HeaderParam(value="x-ms-range") String var9, @QueryParam(value="x-ms-encryption-key") String var10, @QueryParam(value="x-ms-encryption-key-sha256") String var11, @QueryParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var12, @HeaderParam(value="x-ms-version") String var13, @HeaderParam(value="x-ms-client-request-id") String var14, @QueryParam(value="comp") String var15, @HeaderParam(value="x-ms-page-write") String var16, @HeaderParam(value="x-ms-lease-id") String var17, @HeaderParam(value="x-ms-if-sequence-number-le") Long var18, @HeaderParam(value="x-ms-if-sequence-number-lt") Long var19, @HeaderParam(value="x-ms-if-sequence-number-eq") Long var20, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var21, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var22, @HeaderParam(value="If-Match") String var23, @HeaderParam(value="If-None-Match") String var24, Context var25);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<PageBlobsClearPagesResponse> clearPages(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @HeaderParam(value="Content-Length") long var4, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-range") String var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @QueryParam(value="comp") String var10, @HeaderParam(value="x-ms-page-write") String var11, @HeaderParam(value="x-ms-lease-id") String var12, @HeaderParam(value="x-ms-if-sequence-number-le") Long var13, @HeaderParam(value="x-ms-if-sequence-number-lt") Long var14, @HeaderParam(value="x-ms-if-sequence-number-eq") Long var15, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var16, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var17, @HeaderParam(value="If-Match") String var18, @HeaderParam(value="If-None-Match") String var19, Context var20);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<PageBlobsUploadPagesFromURLResponse> uploadPagesFromURL(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @HeaderParam(value="x-ms-copy-source") URL var4, @HeaderParam(value="x-ms-source-range") String var5, @HeaderParam(value="x-ms-source-content-md5") String var6, @HeaderParam(value="Content-Length") long var7, @QueryParam(value="timeout") Integer var9, @HeaderParam(value="x-ms-range") String var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-client-request-id") String var12, @QueryParam(value="comp") String var13, @HeaderParam(value="x-ms-page-write") String var14, @HeaderParam(value="x-ms-lease-id") String var15, @HeaderParam(value="x-ms-if-sequence-number-le") Long var16, @HeaderParam(value="x-ms-if-sequence-number-lt") Long var17, @HeaderParam(value="x-ms-if-sequence-number-eq") Long var18, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var19, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var20, @HeaderParam(value="If-Match") String var21, @HeaderParam(value="If-None-Match") String var22, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var23, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var24, @HeaderParam(value="x-ms-source-if-match") String var25, @HeaderParam(value="x-ms-source-if-none-match") String var26, Context var27);

        @GET(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<PageBlobsGetPageRangesResponse> getPageRanges(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="snapshot") String var4, @QueryParam(value="versionid") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-range") String var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @QueryParam(value="comp") String var10, @HeaderParam(value="x-ms-lease-id") String var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, @HeaderParam(value="If-Match") String var14, @HeaderParam(value="If-None-Match") String var15, Context var16);

        @GET(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<PageBlobsGetPageRangesDiffResponse> getPageRangesDiff(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="snapshot") String var4, @QueryParam(value="versionid") String var5, @QueryParam(value="timeout") Integer var6, @QueryParam(value="prevsnapshot") String var7, @HeaderParam(value="x-ms-range") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @QueryParam(value="comp") String var11, @HeaderParam(value="x-ms-lease-id") String var12, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var13, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var14, @HeaderParam(value="If-Match") String var15, @HeaderParam(value="If-None-Match") String var16, Context var17);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<PageBlobsResizeResponse> resize(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-blob-content-length") long var5, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @QueryParam(value="comp") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Match") String var13, @HeaderParam(value="If-None-Match") String var14, Context var15);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<PageBlobsUpdateSequenceNumberResponse> updateSequenceNumber(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-sequence-number-action") SequenceNumberActionType var5, @HeaderParam(value="x-ms-blob-sequence-number") Long var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @QueryParam(value="comp") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Match") String var13, @HeaderParam(value="If-None-Match") String var14, Context var15);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<PageBlobsCopyIncrementalResponse> copyIncremental(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-copy-source") URL var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="comp") String var8, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Match") String var11, @HeaderParam(value="If-None-Match") String var12, Context var13);
    }
}

