/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.ServiceClient;
import com.azure.core.annotations.BodyParam;
import com.azure.core.annotations.ExpectedResponses;
import com.azure.core.annotations.GET;
import com.azure.core.annotations.HeaderParam;
import com.azure.core.annotations.Host;
import com.azure.core.annotations.HostParam;
import com.azure.core.annotations.POST;
import com.azure.core.annotations.PUT;
import com.azure.core.annotations.QueryParam;
import com.azure.core.annotations.Service;
import com.azure.core.annotations.UnexpectedResponseExceptionType;
import com.azure.core.implementation.RestProxy;
import com.azure.core.util.Context;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.models.KeyInfo;
import com.azure.storage.blob.models.ListContainersIncludeType;
import com.azure.storage.blob.models.ServicesGetAccountInfoResponse;
import com.azure.storage.blob.models.ServicesGetPropertiesResponse;
import com.azure.storage.blob.models.ServicesGetStatisticsResponse;
import com.azure.storage.blob.models.ServicesGetUserDelegationKeyResponse;
import com.azure.storage.blob.models.ServicesListContainersSegmentResponse;
import com.azure.storage.blob.models.ServicesSetPropertiesResponse;
import com.azure.storage.blob.models.StorageErrorException;
import com.azure.storage.blob.models.StorageServiceProperties;
import reactor.core.publisher.Mono;

public final class ServicesImpl {
    private ServicesService service;
    private AzureBlobStorageImpl client;

    public ServicesImpl(AzureBlobStorageImpl client) {
        this.service = (ServicesService)RestProxy.create(ServicesService.class, (ServiceClient)client);
        this.client = client;
    }

    public Mono<ServicesSetPropertiesResponse> setPropertiesWithRestResponseAsync(StorageServiceProperties storageServiceProperties, Context context) {
        Integer timeout = null;
        String requestId = null;
        return this.service.setProperties(this.client.url(), storageServiceProperties, timeout, this.client.version(), requestId, "service", "properties", context);
    }

    public Mono<ServicesSetPropertiesResponse> setPropertiesWithRestResponseAsync(StorageServiceProperties storageServiceProperties, Integer timeout, String requestId, Context context) {
        return this.service.setProperties(this.client.url(), storageServiceProperties, timeout, this.client.version(), requestId, "service", "properties", context);
    }

    public Mono<ServicesGetPropertiesResponse> getPropertiesWithRestResponseAsync(Context context) {
        Integer timeout = null;
        String requestId = null;
        return this.service.getProperties(this.client.url(), timeout, this.client.version(), requestId, "service", "properties", context);
    }

    public Mono<ServicesGetPropertiesResponse> getPropertiesWithRestResponseAsync(Integer timeout, String requestId, Context context) {
        return this.service.getProperties(this.client.url(), timeout, this.client.version(), requestId, "service", "properties", context);
    }

    public Mono<ServicesGetStatisticsResponse> getStatisticsWithRestResponseAsync(Context context) {
        Integer timeout = null;
        String requestId = null;
        return this.service.getStatistics(this.client.url(), timeout, this.client.version(), requestId, "service", "stats", context);
    }

    public Mono<ServicesGetStatisticsResponse> getStatisticsWithRestResponseAsync(Integer timeout, String requestId, Context context) {
        return this.service.getStatistics(this.client.url(), timeout, this.client.version(), requestId, "service", "stats", context);
    }

    public Mono<ServicesListContainersSegmentResponse> listContainersSegmentWithRestResponseAsync(Context context) {
        String prefix = null;
        String marker = null;
        Integer maxresults = null;
        ListContainersIncludeType include = null;
        Integer timeout = null;
        String requestId = null;
        return this.service.listContainersSegment(this.client.url(), prefix, marker, maxresults, include, timeout, this.client.version(), requestId, "list", context);
    }

    public Mono<ServicesListContainersSegmentResponse> listContainersSegmentWithRestResponseAsync(String prefix, String marker, Integer maxresults, ListContainersIncludeType include, Integer timeout, String requestId, Context context) {
        return this.service.listContainersSegment(this.client.url(), prefix, marker, maxresults, include, timeout, this.client.version(), requestId, "list", context);
    }

    public Mono<ServicesGetUserDelegationKeyResponse> getUserDelegationKeyWithRestResponseAsync(KeyInfo keyInfo, Context context) {
        Integer timeout = null;
        String requestId = null;
        return this.service.getUserDelegationKey(this.client.url(), keyInfo, timeout, this.client.version(), requestId, "service", "userdelegationkey", context);
    }

    public Mono<ServicesGetUserDelegationKeyResponse> getUserDelegationKeyWithRestResponseAsync(KeyInfo keyInfo, Integer timeout, String requestId, Context context) {
        return this.service.getUserDelegationKey(this.client.url(), keyInfo, timeout, this.client.version(), requestId, "service", "userdelegationkey", context);
    }

    public Mono<ServicesGetAccountInfoResponse> getAccountInfoWithRestResponseAsync(Context context) {
        return this.service.getAccountInfo(this.client.url(), this.client.version(), "account", "properties", context);
    }

    @Host(value="{url}")
    @Service(value="Storage Blobs Service")
    private static interface ServicesService {
        @PUT(value="")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<ServicesSetPropertiesResponse> setProperties(@HostParam(value="url") String var1, @BodyParam(value="application/xml; charset=utf-8") StorageServiceProperties var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="restype") String var6, @QueryParam(value="comp") String var7, Context var8);

        @GET(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<ServicesGetPropertiesResponse> getProperties(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="comp") String var6, Context var7);

        @GET(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<ServicesGetStatisticsResponse> getStatistics(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="comp") String var6, Context var7);

        @GET(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<ServicesListContainersSegmentResponse> listContainersSegment(@HostParam(value="url") String var1, @QueryParam(value="prefix") String var2, @QueryParam(value="marker") String var3, @QueryParam(value="maxresults") Integer var4, @QueryParam(value="include") ListContainersIncludeType var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @QueryParam(value="comp") String var9, Context var10);

        @POST(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<ServicesGetUserDelegationKeyResponse> getUserDelegationKey(@HostParam(value="url") String var1, @BodyParam(value="application/xml; charset=utf-8") KeyInfo var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="restype") String var6, @QueryParam(value="comp") String var7, Context var8);

        @GET(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<ServicesGetAccountInfoResponse> getAccountInfo(@HostParam(value="url") String var1, @HeaderParam(value="x-ms-version") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, Context var5);
    }
}

