/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.annotations.HeaderCollection;
import com.azure.core.implementation.DateTimeRfc1123;
import com.azure.core.implementation.util.ImplUtils;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.Map;

@JacksonXmlRootElement(localName="Blob-Download-Headers")
public final class BlobDownloadHeaders {
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @HeaderCollection(value="x-ms-meta-")
    private Map<String, String> metadata;
    @JsonProperty(value="Content-Length")
    private Long contentLength;
    @JsonProperty(value="Content-Type")
    private String contentType;
    @JsonProperty(value="Content-Range")
    private String contentRange;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Content-MD5")
    private byte[] contentMD5;
    @JsonProperty(value="Content-Encoding")
    private String contentEncoding;
    @JsonProperty(value="Cache-Control")
    private String cacheControl;
    @JsonProperty(value="Content-Disposition")
    private String contentDisposition;
    @JsonProperty(value="Content-Language")
    private String contentLanguage;
    @JsonProperty(value="x-ms-blob-sequence-number")
    private Long blobSequenceNumber;
    @JsonProperty(value="x-ms-blob-type")
    private BlobType blobType;
    @JsonProperty(value="x-ms-copy-completion-time")
    private DateTimeRfc1123 copyCompletionTime;
    @JsonProperty(value="x-ms-copy-status-description")
    private String copyStatusDescription;
    @JsonProperty(value="x-ms-copy-id")
    private String copyId;
    @JsonProperty(value="x-ms-copy-progress")
    private String copyProgress;
    @JsonProperty(value="x-ms-copy-source")
    private String copySource;
    @JsonProperty(value="x-ms-copy-status")
    private CopyStatusType copyStatus;
    @JsonProperty(value="x-ms-lease-duration")
    private LeaseDurationType leaseDuration;
    @JsonProperty(value="x-ms-lease-state")
    private LeaseStateType leaseState;
    @JsonProperty(value="x-ms-lease-status")
    private LeaseStatusType leaseStatus;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Accept-Ranges")
    private String acceptRanges;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="x-ms-blob-committed-block-count")
    private Integer blobCommittedBlockCount;
    @JsonProperty(value="x-ms-server-encrypted")
    private Boolean isServerEncrypted;
    @JsonProperty(value="x-ms-encryption-key-sha256")
    private String encryptionKeySha256;
    @JsonProperty(value="x-ms-blob-content-md5")
    private byte[] blobContentMD5;
    @JsonProperty(value="x-ms-error-code")
    private String errorCode;

    public OffsetDateTime lastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.dateTime();
    }

    public BlobDownloadHeaders lastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public BlobDownloadHeaders metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Long contentLength() {
        return this.contentLength;
    }

    public BlobDownloadHeaders contentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String contentType() {
        return this.contentType;
    }

    public BlobDownloadHeaders contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String contentRange() {
        return this.contentRange;
    }

    public BlobDownloadHeaders contentRange(String contentRange) {
        this.contentRange = contentRange;
        return this;
    }

    public String eTag() {
        return this.eTag;
    }

    public BlobDownloadHeaders eTag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public byte[] contentMD5() {
        return ImplUtils.clone((byte[])this.contentMD5);
    }

    public BlobDownloadHeaders contentMD5(byte[] contentMD5) {
        this.contentMD5 = ImplUtils.clone((byte[])contentMD5);
        return this;
    }

    public String contentEncoding() {
        return this.contentEncoding;
    }

    public BlobDownloadHeaders contentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String cacheControl() {
        return this.cacheControl;
    }

    public BlobDownloadHeaders cacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String contentDisposition() {
        return this.contentDisposition;
    }

    public BlobDownloadHeaders contentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public BlobDownloadHeaders contentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public Long blobSequenceNumber() {
        return this.blobSequenceNumber;
    }

    public BlobDownloadHeaders blobSequenceNumber(Long blobSequenceNumber) {
        this.blobSequenceNumber = blobSequenceNumber;
        return this;
    }

    public BlobType blobType() {
        return this.blobType;
    }

    public BlobDownloadHeaders blobType(BlobType blobType) {
        this.blobType = blobType;
        return this;
    }

    public OffsetDateTime copyCompletionTime() {
        if (this.copyCompletionTime == null) {
            return null;
        }
        return this.copyCompletionTime.dateTime();
    }

    public BlobDownloadHeaders copyCompletionTime(OffsetDateTime copyCompletionTime) {
        this.copyCompletionTime = copyCompletionTime == null ? null : new DateTimeRfc1123(copyCompletionTime);
        return this;
    }

    public String copyStatusDescription() {
        return this.copyStatusDescription;
    }

    public BlobDownloadHeaders copyStatusDescription(String copyStatusDescription) {
        this.copyStatusDescription = copyStatusDescription;
        return this;
    }

    public String copyId() {
        return this.copyId;
    }

    public BlobDownloadHeaders copyId(String copyId) {
        this.copyId = copyId;
        return this;
    }

    public String copyProgress() {
        return this.copyProgress;
    }

    public BlobDownloadHeaders copyProgress(String copyProgress) {
        this.copyProgress = copyProgress;
        return this;
    }

    public String copySource() {
        return this.copySource;
    }

    public BlobDownloadHeaders copySource(String copySource) {
        this.copySource = copySource;
        return this;
    }

    public CopyStatusType copyStatus() {
        return this.copyStatus;
    }

    public BlobDownloadHeaders copyStatus(CopyStatusType copyStatus) {
        this.copyStatus = copyStatus;
        return this;
    }

    public LeaseDurationType leaseDuration() {
        return this.leaseDuration;
    }

    public BlobDownloadHeaders leaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public LeaseStateType leaseState() {
        return this.leaseState;
    }

    public BlobDownloadHeaders leaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    public LeaseStatusType leaseStatus() {
        return this.leaseStatus;
    }

    public BlobDownloadHeaders leaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    public String requestId() {
        return this.requestId;
    }

    public BlobDownloadHeaders requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String version() {
        return this.version;
    }

    public BlobDownloadHeaders version(String version) {
        this.version = version;
        return this;
    }

    public String acceptRanges() {
        return this.acceptRanges;
    }

    public BlobDownloadHeaders acceptRanges(String acceptRanges) {
        this.acceptRanges = acceptRanges;
        return this;
    }

    public OffsetDateTime dateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.dateTime();
    }

    public BlobDownloadHeaders dateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public Integer blobCommittedBlockCount() {
        return this.blobCommittedBlockCount;
    }

    public BlobDownloadHeaders blobCommittedBlockCount(Integer blobCommittedBlockCount) {
        this.blobCommittedBlockCount = blobCommittedBlockCount;
        return this;
    }

    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public BlobDownloadHeaders isServerEncrypted(Boolean isServerEncrypted) {
        this.isServerEncrypted = isServerEncrypted;
        return this;
    }

    public String encryptionKeySha256() {
        return this.encryptionKeySha256;
    }

    public BlobDownloadHeaders encryptionKeySha256(String encryptionKeySha256) {
        this.encryptionKeySha256 = encryptionKeySha256;
        return this;
    }

    public byte[] blobContentMD5() {
        return ImplUtils.clone((byte[])this.blobContentMD5);
    }

    public BlobDownloadHeaders blobContentMD5(byte[] blobContentMD5) {
        this.blobContentMD5 = ImplUtils.clone((byte[])blobContentMD5);
        return this;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public BlobDownloadHeaders errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }
}

