/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.implementation.DateTimeRfc1123;
import com.azure.storage.blob.models.AccountKind;
import com.azure.storage.blob.models.SkuName;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="Blob-GetAccountInfo-Headers")
public final class BlobGetAccountInfoHeaders {
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="x-ms-sku-name")
    private SkuName skuName;
    @JsonProperty(value="x-ms-account-kind")
    private AccountKind accountKind;
    @JsonProperty(value="x-ms-error-code")
    private String errorCode;

    public String requestId() {
        return this.requestId;
    }

    public BlobGetAccountInfoHeaders requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String version() {
        return this.version;
    }

    public BlobGetAccountInfoHeaders version(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime dateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.dateTime();
    }

    public BlobGetAccountInfoHeaders dateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public SkuName skuName() {
        return this.skuName;
    }

    public BlobGetAccountInfoHeaders skuName(SkuName skuName) {
        this.skuName = skuName;
        return this;
    }

    public AccountKind accountKind() {
        return this.accountKind;
    }

    public BlobGetAccountInfoHeaders accountKind(AccountKind accountKind) {
        this.accountKind = accountKind;
        return this;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public BlobGetAccountInfoHeaders errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }
}

