/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.annotations.HeaderCollection;
import com.azure.core.implementation.DateTimeRfc1123;
import com.azure.core.implementation.util.ImplUtils;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.Map;

@JacksonXmlRootElement(localName="Blob-GetProperties-Headers")
public final class BlobGetPropertiesHeaders {
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-creation-time")
    private DateTimeRfc1123 creationTime;
    @HeaderCollection(value="x-ms-meta-")
    private Map<String, String> metadata;
    @JsonProperty(value="x-ms-blob-type")
    private BlobType blobType;
    @JsonProperty(value="x-ms-copy-completion-time")
    private DateTimeRfc1123 copyCompletionTime;
    @JsonProperty(value="x-ms-copy-status-description")
    private String copyStatusDescription;
    @JsonProperty(value="x-ms-copy-id")
    private String copyId;
    @JsonProperty(value="x-ms-copy-progress")
    private String copyProgress;
    @JsonProperty(value="x-ms-copy-source")
    private String copySource;
    @JsonProperty(value="x-ms-copy-status")
    private CopyStatusType copyStatus;
    @JsonProperty(value="x-ms-incremental-copy")
    private Boolean isIncrementalCopy;
    @JsonProperty(value="x-ms-copy-destination-snapshot")
    private String destinationSnapshot;
    @JsonProperty(value="x-ms-lease-duration")
    private LeaseDurationType leaseDuration;
    @JsonProperty(value="x-ms-lease-state")
    private LeaseStateType leaseState;
    @JsonProperty(value="x-ms-lease-status")
    private LeaseStatusType leaseStatus;
    @JsonProperty(value="Content-Length")
    private Long contentLength;
    @JsonProperty(value="Content-Type")
    private String contentType;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Content-MD5")
    private byte[] contentMD5;
    @JsonProperty(value="Content-Encoding")
    private String contentEncoding;
    @JsonProperty(value="Content-Disposition")
    private String contentDisposition;
    @JsonProperty(value="Content-Language")
    private String contentLanguage;
    @JsonProperty(value="Cache-Control")
    private String cacheControl;
    @JsonProperty(value="x-ms-blob-sequence-number")
    private Long blobSequenceNumber;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="Accept-Ranges")
    private String acceptRanges;
    @JsonProperty(value="x-ms-blob-committed-block-count")
    private Integer blobCommittedBlockCount;
    @JsonProperty(value="x-ms-server-encrypted")
    private Boolean isServerEncrypted;
    @JsonProperty(value="x-ms-encryption-key-sha256")
    private String encryptionKeySha256;
    @JsonProperty(value="x-ms-access-tier")
    private String accessTier;
    @JsonProperty(value="x-ms-access-tier-inferred")
    private Boolean accessTierInferred;
    @JsonProperty(value="x-ms-archive-status")
    private String archiveStatus;
    @JsonProperty(value="x-ms-access-tier-change-time")
    private DateTimeRfc1123 accessTierChangeTime;
    @JsonProperty(value="x-ms-error-code")
    private String errorCode;

    public OffsetDateTime lastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.dateTime();
    }

    public BlobGetPropertiesHeaders lastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public OffsetDateTime creationTime() {
        if (this.creationTime == null) {
            return null;
        }
        return this.creationTime.dateTime();
    }

    public BlobGetPropertiesHeaders creationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime == null ? null : new DateTimeRfc1123(creationTime);
        return this;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public BlobGetPropertiesHeaders metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public BlobType blobType() {
        return this.blobType;
    }

    public BlobGetPropertiesHeaders blobType(BlobType blobType) {
        this.blobType = blobType;
        return this;
    }

    public OffsetDateTime copyCompletionTime() {
        if (this.copyCompletionTime == null) {
            return null;
        }
        return this.copyCompletionTime.dateTime();
    }

    public BlobGetPropertiesHeaders copyCompletionTime(OffsetDateTime copyCompletionTime) {
        this.copyCompletionTime = copyCompletionTime == null ? null : new DateTimeRfc1123(copyCompletionTime);
        return this;
    }

    public String copyStatusDescription() {
        return this.copyStatusDescription;
    }

    public BlobGetPropertiesHeaders copyStatusDescription(String copyStatusDescription) {
        this.copyStatusDescription = copyStatusDescription;
        return this;
    }

    public String copyId() {
        return this.copyId;
    }

    public BlobGetPropertiesHeaders copyId(String copyId) {
        this.copyId = copyId;
        return this;
    }

    public String copyProgress() {
        return this.copyProgress;
    }

    public BlobGetPropertiesHeaders copyProgress(String copyProgress) {
        this.copyProgress = copyProgress;
        return this;
    }

    public String copySource() {
        return this.copySource;
    }

    public BlobGetPropertiesHeaders copySource(String copySource) {
        this.copySource = copySource;
        return this;
    }

    public CopyStatusType copyStatus() {
        return this.copyStatus;
    }

    public BlobGetPropertiesHeaders copyStatus(CopyStatusType copyStatus) {
        this.copyStatus = copyStatus;
        return this;
    }

    public Boolean isIncrementalCopy() {
        return this.isIncrementalCopy;
    }

    public BlobGetPropertiesHeaders isIncrementalCopy(Boolean isIncrementalCopy) {
        this.isIncrementalCopy = isIncrementalCopy;
        return this;
    }

    public String destinationSnapshot() {
        return this.destinationSnapshot;
    }

    public BlobGetPropertiesHeaders destinationSnapshot(String destinationSnapshot) {
        this.destinationSnapshot = destinationSnapshot;
        return this;
    }

    public LeaseDurationType leaseDuration() {
        return this.leaseDuration;
    }

    public BlobGetPropertiesHeaders leaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public LeaseStateType leaseState() {
        return this.leaseState;
    }

    public BlobGetPropertiesHeaders leaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    public LeaseStatusType leaseStatus() {
        return this.leaseStatus;
    }

    public BlobGetPropertiesHeaders leaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    public Long contentLength() {
        return this.contentLength;
    }

    public BlobGetPropertiesHeaders contentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String contentType() {
        return this.contentType;
    }

    public BlobGetPropertiesHeaders contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String eTag() {
        return this.eTag;
    }

    public BlobGetPropertiesHeaders eTag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public byte[] contentMD5() {
        return ImplUtils.clone((byte[])this.contentMD5);
    }

    public BlobGetPropertiesHeaders contentMD5(byte[] contentMD5) {
        this.contentMD5 = ImplUtils.clone((byte[])contentMD5);
        return this;
    }

    public String contentEncoding() {
        return this.contentEncoding;
    }

    public BlobGetPropertiesHeaders contentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String contentDisposition() {
        return this.contentDisposition;
    }

    public BlobGetPropertiesHeaders contentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public BlobGetPropertiesHeaders contentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public String cacheControl() {
        return this.cacheControl;
    }

    public BlobGetPropertiesHeaders cacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public Long blobSequenceNumber() {
        return this.blobSequenceNumber;
    }

    public BlobGetPropertiesHeaders blobSequenceNumber(Long blobSequenceNumber) {
        this.blobSequenceNumber = blobSequenceNumber;
        return this;
    }

    public String requestId() {
        return this.requestId;
    }

    public BlobGetPropertiesHeaders requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String version() {
        return this.version;
    }

    public BlobGetPropertiesHeaders version(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime dateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.dateTime();
    }

    public BlobGetPropertiesHeaders dateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public String acceptRanges() {
        return this.acceptRanges;
    }

    public BlobGetPropertiesHeaders acceptRanges(String acceptRanges) {
        this.acceptRanges = acceptRanges;
        return this;
    }

    public Integer blobCommittedBlockCount() {
        return this.blobCommittedBlockCount;
    }

    public BlobGetPropertiesHeaders blobCommittedBlockCount(Integer blobCommittedBlockCount) {
        this.blobCommittedBlockCount = blobCommittedBlockCount;
        return this;
    }

    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public BlobGetPropertiesHeaders isServerEncrypted(Boolean isServerEncrypted) {
        this.isServerEncrypted = isServerEncrypted;
        return this;
    }

    public String encryptionKeySha256() {
        return this.encryptionKeySha256;
    }

    public BlobGetPropertiesHeaders encryptionKeySha256(String encryptionKeySha256) {
        this.encryptionKeySha256 = encryptionKeySha256;
        return this;
    }

    public String accessTier() {
        return this.accessTier;
    }

    public BlobGetPropertiesHeaders accessTier(String accessTier) {
        this.accessTier = accessTier;
        return this;
    }

    public Boolean accessTierInferred() {
        return this.accessTierInferred;
    }

    public BlobGetPropertiesHeaders accessTierInferred(Boolean accessTierInferred) {
        this.accessTierInferred = accessTierInferred;
        return this;
    }

    public String archiveStatus() {
        return this.archiveStatus;
    }

    public BlobGetPropertiesHeaders archiveStatus(String archiveStatus) {
        this.archiveStatus = archiveStatus;
        return this;
    }

    public OffsetDateTime accessTierChangeTime() {
        if (this.accessTierChangeTime == null) {
            return null;
        }
        return this.accessTierChangeTime.dateTime();
    }

    public BlobGetPropertiesHeaders accessTierChangeTime(OffsetDateTime accessTierChangeTime) {
        this.accessTierChangeTime = accessTierChangeTime == null ? null : new DateTimeRfc1123(accessTierChangeTime);
        return this;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public BlobGetPropertiesHeaders errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }
}

