/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.implementation.DateTimeRfc1123;
import com.azure.core.implementation.util.ImplUtils;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.ArchiveStatus;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="Properties")
public final class BlobProperties {
    @JsonProperty(value="Creation-Time")
    private DateTimeRfc1123 creationTime;
    @JsonProperty(value="Last-Modified", required=true)
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="Etag", required=true)
    private String etag;
    @JsonProperty(value="Content-Length")
    private Long contentLength;
    @JsonProperty(value="Content-Type")
    private String contentType;
    @JsonProperty(value="Content-Encoding")
    private String contentEncoding;
    @JsonProperty(value="Content-Language")
    private String contentLanguage;
    @JsonProperty(value="Content-MD5")
    private byte[] contentMD5;
    @JsonProperty(value="Content-Disposition")
    private String contentDisposition;
    @JsonProperty(value="Cache-Control")
    private String cacheControl;
    @JsonProperty(value="x-ms-blob-sequence-number")
    private Long blobSequenceNumber;
    @JsonProperty(value="BlobType")
    private BlobType blobType;
    @JsonProperty(value="LeaseStatus")
    private LeaseStatusType leaseStatus;
    @JsonProperty(value="LeaseState")
    private LeaseStateType leaseState;
    @JsonProperty(value="LeaseDuration")
    private LeaseDurationType leaseDuration;
    @JsonProperty(value="CopyId")
    private String copyId;
    @JsonProperty(value="CopyStatus")
    private CopyStatusType copyStatus;
    @JsonProperty(value="CopySource")
    private String copySource;
    @JsonProperty(value="CopyProgress")
    private String copyProgress;
    @JsonProperty(value="CopyCompletionTime")
    private DateTimeRfc1123 copyCompletionTime;
    @JsonProperty(value="CopyStatusDescription")
    private String copyStatusDescription;
    @JsonProperty(value="ServerEncrypted")
    private Boolean serverEncrypted;
    @JsonProperty(value="IncrementalCopy")
    private Boolean incrementalCopy;
    @JsonProperty(value="DestinationSnapshot")
    private String destinationSnapshot;
    @JsonProperty(value="DeletedTime")
    private DateTimeRfc1123 deletedTime;
    @JsonProperty(value="RemainingRetentionDays")
    private Integer remainingRetentionDays;
    @JsonProperty(value="AccessTier")
    private AccessTier accessTier;
    @JsonProperty(value="AccessTierInferred")
    private Boolean accessTierInferred;
    @JsonProperty(value="ArchiveStatus")
    private ArchiveStatus archiveStatus;
    @JsonProperty(value="CustomerProvidedKeySha256")
    private String customerProvidedKeySha256;
    @JsonProperty(value="AccessTierChangeTime")
    private DateTimeRfc1123 accessTierChangeTime;

    public OffsetDateTime creationTime() {
        if (this.creationTime == null) {
            return null;
        }
        return this.creationTime.dateTime();
    }

    public BlobProperties creationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime == null ? null : new DateTimeRfc1123(creationTime);
        return this;
    }

    public OffsetDateTime lastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.dateTime();
    }

    public BlobProperties lastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public BlobProperties etag(String etag) {
        this.etag = etag;
        return this;
    }

    public Long contentLength() {
        return this.contentLength;
    }

    public BlobProperties contentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String contentType() {
        return this.contentType;
    }

    public BlobProperties contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String contentEncoding() {
        return this.contentEncoding;
    }

    public BlobProperties contentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public BlobProperties contentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public byte[] contentMD5() {
        return ImplUtils.clone((byte[])this.contentMD5);
    }

    public BlobProperties contentMD5(byte[] contentMD5) {
        this.contentMD5 = ImplUtils.clone((byte[])contentMD5);
        return this;
    }

    public String contentDisposition() {
        return this.contentDisposition;
    }

    public BlobProperties contentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String cacheControl() {
        return this.cacheControl;
    }

    public BlobProperties cacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public Long blobSequenceNumber() {
        return this.blobSequenceNumber;
    }

    public BlobProperties blobSequenceNumber(Long blobSequenceNumber) {
        this.blobSequenceNumber = blobSequenceNumber;
        return this;
    }

    public BlobType blobType() {
        return this.blobType;
    }

    public BlobProperties blobType(BlobType blobType) {
        this.blobType = blobType;
        return this;
    }

    public LeaseStatusType leaseStatus() {
        return this.leaseStatus;
    }

    public BlobProperties leaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    public LeaseStateType leaseState() {
        return this.leaseState;
    }

    public BlobProperties leaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    public LeaseDurationType leaseDuration() {
        return this.leaseDuration;
    }

    public BlobProperties leaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public String copyId() {
        return this.copyId;
    }

    public BlobProperties copyId(String copyId) {
        this.copyId = copyId;
        return this;
    }

    public CopyStatusType copyStatus() {
        return this.copyStatus;
    }

    public BlobProperties copyStatus(CopyStatusType copyStatus) {
        this.copyStatus = copyStatus;
        return this;
    }

    public String copySource() {
        return this.copySource;
    }

    public BlobProperties copySource(String copySource) {
        this.copySource = copySource;
        return this;
    }

    public String copyProgress() {
        return this.copyProgress;
    }

    public BlobProperties copyProgress(String copyProgress) {
        this.copyProgress = copyProgress;
        return this;
    }

    public OffsetDateTime copyCompletionTime() {
        if (this.copyCompletionTime == null) {
            return null;
        }
        return this.copyCompletionTime.dateTime();
    }

    public BlobProperties copyCompletionTime(OffsetDateTime copyCompletionTime) {
        this.copyCompletionTime = copyCompletionTime == null ? null : new DateTimeRfc1123(copyCompletionTime);
        return this;
    }

    public String copyStatusDescription() {
        return this.copyStatusDescription;
    }

    public BlobProperties copyStatusDescription(String copyStatusDescription) {
        this.copyStatusDescription = copyStatusDescription;
        return this;
    }

    public Boolean serverEncrypted() {
        return this.serverEncrypted;
    }

    public BlobProperties serverEncrypted(Boolean serverEncrypted) {
        this.serverEncrypted = serverEncrypted;
        return this;
    }

    public Boolean incrementalCopy() {
        return this.incrementalCopy;
    }

    public BlobProperties incrementalCopy(Boolean incrementalCopy) {
        this.incrementalCopy = incrementalCopy;
        return this;
    }

    public String destinationSnapshot() {
        return this.destinationSnapshot;
    }

    public BlobProperties destinationSnapshot(String destinationSnapshot) {
        this.destinationSnapshot = destinationSnapshot;
        return this;
    }

    public OffsetDateTime deletedTime() {
        if (this.deletedTime == null) {
            return null;
        }
        return this.deletedTime.dateTime();
    }

    public BlobProperties deletedTime(OffsetDateTime deletedTime) {
        this.deletedTime = deletedTime == null ? null : new DateTimeRfc1123(deletedTime);
        return this;
    }

    public Integer remainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    public BlobProperties remainingRetentionDays(Integer remainingRetentionDays) {
        this.remainingRetentionDays = remainingRetentionDays;
        return this;
    }

    public AccessTier accessTier() {
        return this.accessTier;
    }

    public BlobProperties accessTier(AccessTier accessTier) {
        this.accessTier = accessTier;
        return this;
    }

    public Boolean accessTierInferred() {
        return this.accessTierInferred;
    }

    public BlobProperties accessTierInferred(Boolean accessTierInferred) {
        this.accessTierInferred = accessTierInferred;
        return this;
    }

    public ArchiveStatus archiveStatus() {
        return this.archiveStatus;
    }

    public BlobProperties archiveStatus(ArchiveStatus archiveStatus) {
        this.archiveStatus = archiveStatus;
        return this;
    }

    public String customerProvidedKeySha256() {
        return this.customerProvidedKeySha256;
    }

    public BlobProperties customerProvidedKeySha256(String customerProvidedKeySha256) {
        this.customerProvidedKeySha256 = customerProvidedKeySha256;
        return this;
    }

    public OffsetDateTime accessTierChangeTime() {
        if (this.accessTierChangeTime == null) {
            return null;
        }
        return this.accessTierChangeTime.dateTime();
    }

    public BlobProperties accessTierChangeTime(OffsetDateTime accessTierChangeTime) {
        this.accessTierChangeTime = accessTierChangeTime == null ? null : new DateTimeRfc1123(accessTierChangeTime);
        return this;
    }
}

