/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.implementation.DateTimeRfc1123;
import com.azure.core.implementation.util.ImplUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="BlockBlob-StageBlock-Headers")
public final class BlockBlobStageBlockHeaders {
    @JsonProperty(value="Content-MD5")
    private byte[] contentMD5;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="x-ms-request-server-encrypted")
    private Boolean isServerEncrypted;
    @JsonProperty(value="x-ms-encryption-key-sha256")
    private String encryptionKeySha256;
    @JsonProperty(value="x-ms-error-code")
    private String errorCode;

    public byte[] contentMD5() {
        return ImplUtils.clone((byte[])this.contentMD5);
    }

    public BlockBlobStageBlockHeaders contentMD5(byte[] contentMD5) {
        this.contentMD5 = ImplUtils.clone((byte[])contentMD5);
        return this;
    }

    public String requestId() {
        return this.requestId;
    }

    public BlockBlobStageBlockHeaders requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String version() {
        return this.version;
    }

    public BlockBlobStageBlockHeaders version(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime dateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.dateTime();
    }

    public BlockBlobStageBlockHeaders dateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public BlockBlobStageBlockHeaders isServerEncrypted(Boolean isServerEncrypted) {
        this.isServerEncrypted = isServerEncrypted;
        return this;
    }

    public String encryptionKeySha256() {
        return this.encryptionKeySha256;
    }

    public BlockBlobStageBlockHeaders encryptionKeySha256(String encryptionKeySha256) {
        this.encryptionKeySha256 = encryptionKeySha256;
        return this;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public BlockBlobStageBlockHeaders errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }
}

