/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.implementation.http.UrlBuilder;
import com.azure.storage.common.policy.RequestRetryOptions;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeoutException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class RequestRetryPolicy
implements HttpPipelinePolicy {
    private final RequestRetryOptions requestRetryOptions;

    public RequestRetryPolicy(RequestRetryOptions requestRetryOptions) {
        this.requestRetryOptions = requestRetryOptions;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        HttpRequest httpRequest = context.httpRequest();
        boolean considerSecondary = (httpRequest.httpMethod().equals((Object)HttpMethod.GET) || httpRequest.httpMethod().equals((Object)HttpMethod.HEAD)) && this.requestRetryOptions.secondaryHost() != null;
        return this.attemptAsync(httpRequest, next, 1, considerSecondary, 1);
    }

    private Mono<HttpResponse> attemptAsync(HttpRequest httpRequest, HttpPipelineNextPolicy next, int primaryTry, boolean considerSecondary, int attempt) {
        boolean tryingPrimary = !considerSecondary || attempt % 2 != 0;
        long delayMs = tryingPrimary ? this.requestRetryOptions.calculateDelayInMs(primaryTry) : (long)(((double)(ThreadLocalRandom.current().nextFloat() / 2.0f) + 0.8) * 1000.0);
        Flux bufferedBody = httpRequest.body() == null ? null : httpRequest.body().map(ByteBuf::duplicate);
        httpRequest.body(bufferedBody);
        if (!tryingPrimary) {
            UrlBuilder builder = UrlBuilder.parse((URL)httpRequest.url());
            builder.host(this.requestRetryOptions.secondaryHost());
            try {
                httpRequest.url(builder.toURL());
            }
            catch (MalformedURLException e) {
                return Mono.error((Throwable)e);
            }
        }
        return next.clone().process().timeout(Duration.ofSeconds(this.requestRetryOptions.tryTimeout())).delaySubscription(Duration.ofMillis(delayMs)).flatMap(response -> {
            String action;
            boolean newConsiderSecondary = considerSecondary;
            int statusCode = response.statusCode();
            if (!tryingPrimary && statusCode == 404) {
                newConsiderSecondary = false;
                action = "Retry: Secondary URL returned 404";
            } else {
                action = statusCode == 503 || statusCode == 500 ? "Retry: Temporary error or server timeout" : "NoRetry: Successful HTTP request";
            }
            if (action.charAt(0) == 'R' && attempt < this.requestRetryOptions.maxTries()) {
                int newPrimaryTry = !tryingPrimary || !considerSecondary ? primaryTry + 1 : primaryTry;
                return this.attemptAsync(httpRequest, next, newPrimaryTry, newConsiderSecondary, attempt + 1);
            }
            return Mono.just((Object)response);
        }).onErrorResume(throwable -> {
            if (throwable instanceof IllegalStateException && attempt > 1) {
                return Mono.error((Throwable)new IllegalStateException("The request failed because the size of the contents of the provided Flux did not match the provided data size upon attempting to retry. This is likely caused by the Flux not being replayable. To support retries, all Fluxes must produce the same data for each subscriber. Please ensure this behavior.", (Throwable)throwable));
            }
            String action = throwable instanceof IOException ? "Retry: Network error" : (throwable instanceof TimeoutException ? "Retry: Client timeout" : "NoRetry: Unknown error");
            if (action.charAt(0) == 'R' && attempt < this.requestRetryOptions.maxTries()) {
                int newPrimaryTry = !tryingPrimary || !considerSecondary ? primaryTry + 1 : primaryTry;
                return this.attemptAsync(httpRequest, next, newPrimaryTry, considerSecondary, attempt + 1);
            }
            return Mono.error((Throwable)throwable);
        });
    }
}

