/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.storage.common.credentials.SharedKeyCredential;
import reactor.core.publisher.Mono;

public final class SharedKeyCredentialPolicy
implements HttpPipelinePolicy {
    private final SharedKeyCredential credential;

    public SharedKeyCredentialPolicy(SharedKeyCredential credential) {
        this.credential = credential;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        String authorizationValue = this.credential.generateAuthorizationHeader(context.httpRequest().url(), context.httpRequest().httpMethod().toString(), context.httpRequest().headers().toMap());
        context.httpRequest().header("Authorization", authorizationValue);
        return next.process();
    }
}

