/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation;

import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class StorageImplUtils {
    private static final ClientLogger LOGGER = new ClientLogger(StorageImplUtils.class);
    private static final String ARGUMENT_NULL_OR_EMPTY = "The argument must not be null or an empty string. Argument name: %s.";
    private static final String PARAMETER_NOT_IN_RANGE = "The value of the parameter '%s' should be between %s and %s.";
    private static final String NO_PATH_SEGMENTS = "URL %s does not contain path segments.";
    private static final String STRING_TO_SIGN_LOG_INFO_MESSAGE = "The string to sign computed by the SDK is: {}{}";
    private static final String STRING_TO_SIGN_LOG_WARNING_MESSAGE = "Please remember to disable '{}' before going to production as this string can potentially contain PII.";
    private static final String STORAGE_EXCEPTION_LOG_STRING_TO_SIGN_MESSAGE = String.format("If you are using a StorageSharedKeyCredential, and the server returned an error message that says 'Signature did not match', you can compare the string to sign with the one generated by the SDK. To log the string to sign, pass in the context key value pair '%s': true to the appropriate method call.%nIf you are using a SAS token, and the server returned an error message that says 'Signature did not match', you can compare the string to sign with the one generated by the SDK. To log the string to sign, pass in the context key value pair '%s': true to the appropriate generateSas method call.%nPlease remember to disable '%s' before going to production as this string can potentially contain PII.%n", "Azure-Storage-Log-String-To-Sign", "Azure-Storage-Log-String-To-Sign", "Azure-Storage-Log-String-To-Sign");

    public static Map<String, String> parseQueryString(String queryString) {
        return StorageImplUtils.parseQueryStringHelper(queryString, Utility::urlDecode);
    }

    public static Map<String, String[]> parseQueryStringSplitValues(String queryString) {
        return StorageImplUtils.parseQueryStringHelper(queryString, value -> {
            String[] v = value.split(",");
            String[] ret = new String[v.length];
            for (int i = 0; i < v.length; ++i) {
                ret[i] = Utility.urlDecode(v[i]);
            }
            return ret;
        });
    }

    private static <T> Map<String, T> parseQueryStringHelper(String queryString, Function<String, T> valueParser) {
        TreeMap<String, T> pieces = new TreeMap<String, T>();
        if (CoreUtils.isNullOrEmpty((CharSequence)queryString)) {
            return pieces;
        }
        for (String kvp : queryString.split("&")) {
            int equalIndex = kvp.indexOf("=");
            String key = Utility.urlDecode(kvp.substring(0, equalIndex).toLowerCase(Locale.ROOT));
            T value = valueParser.apply(kvp.substring(equalIndex + 1));
            pieces.putIfAbsent(key, value);
        }
        return pieces;
    }

    public static <T> T blockWithOptionalTimeout(Mono<T> response, Duration timeout) {
        if (timeout == null) {
            return (T)response.block();
        }
        return (T)response.block(timeout);
    }

    public static <T> Mono<T> applyOptionalTimeout(Mono<T> publisher, Duration timeout) {
        return timeout == null ? publisher : publisher.timeout(timeout);
    }

    public static <T> Flux<T> applyOptionalTimeout(Flux<T> publisher, Duration timeout) {
        return timeout == null ? publisher : publisher.timeout(timeout);
    }

    public static void assertNotNull(String param, Object value) {
        if (value == null) {
            throw new NullPointerException(String.format(Locale.ROOT, ARGUMENT_NULL_OR_EMPTY, param));
        }
    }

    public static void assertInBounds(String param, long value, long min, long max) {
        if (value < min || value > max) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(Locale.ROOT, PARAMETER_NOT_IN_RANGE, param, min, max)));
        }
    }

    public static String computeHMac256(String base64Key, String stringToSign) {
        try {
            byte[] key = Base64.getDecoder().decode(base64Key);
            Mac hmacSHA256 = Mac.getInstance("HmacSHA256");
            hmacSHA256.init(new SecretKeySpec(key, "HmacSHA256"));
            byte[] utf8Bytes = stringToSign.getBytes(StandardCharsets.UTF_8);
            return Base64.getEncoder().encodeToString(hmacSHA256.doFinal(utf8Bytes));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static URL appendToUrlPath(String baseURL, String name) {
        UrlBuilder builder = UrlBuilder.parse((String)baseURL);
        if (builder.getPath() == null) {
            builder.setPath("/");
        } else if (!builder.getPath().endsWith("/")) {
            builder.setPath(builder.getPath() + "/");
        }
        builder.setPath(builder.getPath() + name);
        try {
            return builder.toUrl();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static URL stripLastPathSegment(URL baseUrl) {
        UrlBuilder builder = UrlBuilder.parse((URL)baseUrl);
        if (builder.getPath() == null || !builder.getPath().contains("/")) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, NO_PATH_SEGMENTS, baseUrl));
        }
        builder.setPath(builder.getPath().substring(0, builder.getPath().lastIndexOf("/")));
        try {
            return builder.toUrl();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static String getAccountName(URL url) {
        UrlBuilder builder = UrlBuilder.parse((URL)url);
        String accountName = null;
        String host = builder.getHost();
        if (!CoreUtils.isNullOrEmpty((CharSequence)host)) {
            int accountNameIndex = host.indexOf(46);
            accountName = accountNameIndex == -1 ? host : host.substring(0, accountNameIndex);
        }
        return accountName;
    }

    public static String emptyIfNull(String value) {
        return value == null ? "" : value;
    }

    public static void copyToOutputStream(InputStream source, long writeLength, OutputStream destination) throws IOException {
        StorageImplUtils.assertNotNull("source", source);
        StorageImplUtils.assertNotNull("destination", destination);
        byte[] retrievedBuff = new byte[8192];
        int nextCopy = (int)Math.min((long)retrievedBuff.length, writeLength);
        int count = source.read(retrievedBuff, 0, nextCopy);
        while (nextCopy > 0 && count != -1) {
            destination.write(retrievedBuff, 0, count);
            nextCopy = (int)Math.min((long)retrievedBuff.length, writeLength);
            count = source.read(retrievedBuff, 0, nextCopy);
        }
    }

    public static void logStringToSign(ClientLogger logger, String stringToSign, Context context) {
        if (context != null && Boolean.TRUE.equals(context.getData((Object)"Azure-Storage-Log-String-To-Sign").orElse(false))) {
            logger.info(STRING_TO_SIGN_LOG_INFO_MESSAGE, new Object[]{stringToSign, System.lineSeparator()});
            logger.warning(STRING_TO_SIGN_LOG_WARNING_MESSAGE, new Object[]{"Azure-Storage-Log-String-To-Sign"});
        }
    }

    public static String convertStorageExceptionMessage(String message, HttpResponse response) {
        if (response != null) {
            if (response.getStatusCode() == 403) {
                return STORAGE_EXCEPTION_LOG_STRING_TO_SIGN_MESSAGE + message;
            }
            if (response.getRequest() != null && response.getRequest().getHttpMethod() != null && response.getRequest().getHttpMethod().equals((Object)HttpMethod.HEAD) && response.getHeaders().getValue("x-ms-error-code") != null) {
                return message.replaceFirst("(empty body)", response.getHeaders().getValue("x-ms-error-code"));
            }
        }
        return message;
    }
}

