/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.share.FileSmbProperties;
import com.azure.storage.file.share.ShareAsyncClient;
import com.azure.storage.file.share.ShareDirectoryClient;
import com.azure.storage.file.share.ShareFileClient;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.models.ShareFileHttpHeaders;
import com.azure.storage.file.share.models.ShareInfo;
import com.azure.storage.file.share.models.ShareProperties;
import com.azure.storage.file.share.models.ShareRequestConditions;
import com.azure.storage.file.share.models.ShareSignedIdentifier;
import com.azure.storage.file.share.models.ShareSnapshotInfo;
import com.azure.storage.file.share.models.ShareStatistics;
import com.azure.storage.file.share.options.ShareCreateOptions;
import com.azure.storage.file.share.options.ShareDeleteOptions;
import com.azure.storage.file.share.options.ShareGetAccessPolicyOptions;
import com.azure.storage.file.share.options.ShareGetPropertiesOptions;
import com.azure.storage.file.share.options.ShareGetStatisticsOptions;
import com.azure.storage.file.share.options.ShareSetAccessPolicyOptions;
import com.azure.storage.file.share.options.ShareSetMetadataOptions;
import com.azure.storage.file.share.options.ShareSetPropertiesOptions;
import com.azure.storage.file.share.sas.ShareServiceSasSignatureValues;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public class ShareClient {
    private final ShareAsyncClient client;

    ShareClient(ShareAsyncClient client) {
        this.client = client;
    }

    public String getShareUrl() {
        return this.client.getShareUrl();
    }

    public ShareServiceVersion getServiceVersion() {
        return this.client.getServiceVersion();
    }

    public ShareDirectoryClient getRootDirectoryClient() {
        return this.getDirectoryClient("");
    }

    public ShareDirectoryClient getDirectoryClient(String directoryName) {
        return new ShareDirectoryClient(this.client.getDirectoryClient(directoryName));
    }

    public ShareFileClient getFileClient(String filePath) {
        return new ShareFileClient(this.client.getFileClient(filePath));
    }

    public ShareClient getSnapshotClient(String snapshot) {
        return new ShareClient(this.client.getSnapshotClient(snapshot));
    }

    public Boolean exists() {
        return (Boolean)this.existsWithResponse(null, Context.NONE).getValue();
    }

    public Response<Boolean> existsWithResponse(Duration timeout, Context context) {
        Mono<Response<Boolean>> response = this.client.existsWithResponse(context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public ShareInfo create() {
        return (ShareInfo)this.createWithResponse(null, null, null, Context.NONE).getValue();
    }

    public Response<ShareInfo> createWithResponse(Map<String, String> metadata, Integer quotaInGB, Duration timeout, Context context) {
        Mono<Response<ShareInfo>> response = this.client.createWithResponse(new ShareCreateOptions().setQuotaInGb(quotaInGB).setMetadata(metadata), context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public Response<ShareInfo> createWithResponse(ShareCreateOptions options, Duration timeout, Context context) {
        Mono<Response<ShareInfo>> response = this.client.createWithResponse(options, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public ShareSnapshotInfo createSnapshot() {
        return (ShareSnapshotInfo)this.createSnapshotWithResponse(null, null, Context.NONE).getValue();
    }

    public Response<ShareSnapshotInfo> createSnapshotWithResponse(Map<String, String> metadata, Duration timeout, Context context) {
        Mono<Response<ShareSnapshotInfo>> response = this.client.createSnapshotWithResponse(metadata, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public void delete() {
        this.deleteWithResponse(null, Context.NONE);
    }

    public Response<Void> deleteWithResponse(Duration timeout, Context context) {
        return this.deleteWithResponse(new ShareDeleteOptions(), timeout, context);
    }

    public Response<Void> deleteWithResponse(ShareDeleteOptions options, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.deleteWithResponse(options, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public ShareProperties getProperties() {
        return (ShareProperties)this.getPropertiesWithResponse(null, Context.NONE).getValue();
    }

    public Response<ShareProperties> getPropertiesWithResponse(Duration timeout, Context context) {
        return this.getPropertiesWithResponse(new ShareGetPropertiesOptions(), timeout, context);
    }

    public Response<ShareProperties> getPropertiesWithResponse(ShareGetPropertiesOptions options, Duration timeout, Context context) {
        Mono<Response<ShareProperties>> response = this.client.getPropertiesWithResponse(options, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @Deprecated
    public ShareInfo setQuota(int quotaInGB) {
        return (ShareInfo)this.setQuotaWithResponse(quotaInGB, null, Context.NONE).getValue();
    }

    @Deprecated
    public Response<ShareInfo> setQuotaWithResponse(int quotaInGB, Duration timeout, Context context) {
        return this.setPropertiesWithResponse(new ShareSetPropertiesOptions().setQuotaInGb(quotaInGB), timeout, context);
    }

    public ShareInfo setProperties(ShareSetPropertiesOptions options) {
        return (ShareInfo)this.setPropertiesWithResponse(options, null, Context.NONE).getValue();
    }

    public Response<ShareInfo> setPropertiesWithResponse(ShareSetPropertiesOptions options, Duration timeout, Context context) {
        Mono<Response<ShareInfo>> response = this.client.setPropertiesWithResponse(options, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public ShareInfo setMetadata(Map<String, String> metadata) {
        return (ShareInfo)this.setMetadataWithResponse(metadata, null, Context.NONE).getValue();
    }

    public Response<ShareInfo> setMetadataWithResponse(Map<String, String> metadata, Duration timeout, Context context) {
        return this.setMetadataWithResponse(new ShareSetMetadataOptions().setMetadata(metadata), timeout, context);
    }

    public Response<ShareInfo> setMetadataWithResponse(ShareSetMetadataOptions options, Duration timeout, Context context) {
        Mono<Response<ShareInfo>> response = this.client.setMetadataWithResponse(options, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public PagedIterable<ShareSignedIdentifier> getAccessPolicy() {
        return this.getAccessPolicy(new ShareGetAccessPolicyOptions());
    }

    public PagedIterable<ShareSignedIdentifier> getAccessPolicy(ShareGetAccessPolicyOptions options) {
        return new PagedIterable(this.client.getAccessPolicy(options));
    }

    public ShareInfo setAccessPolicy(List<ShareSignedIdentifier> permissions) {
        return (ShareInfo)this.setAccessPolicyWithResponse(permissions, null, Context.NONE).getValue();
    }

    public Response<ShareInfo> setAccessPolicyWithResponse(List<ShareSignedIdentifier> permissions, Duration timeout, Context context) {
        return this.setAccessPolicyWithResponse(new ShareSetAccessPolicyOptions().setPermissions(permissions), timeout, context);
    }

    public Response<ShareInfo> setAccessPolicyWithResponse(ShareSetAccessPolicyOptions options, Duration timeout, Context context) {
        Mono<Response<ShareInfo>> response = this.client.setAccessPolicyWithResponse(options, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public ShareStatistics getStatistics() {
        return (ShareStatistics)this.getStatisticsWithResponse(null, Context.NONE).getValue();
    }

    public Response<ShareStatistics> getStatisticsWithResponse(Duration timeout, Context context) {
        return this.getStatisticsWithResponse(new ShareGetStatisticsOptions(), timeout, context);
    }

    public Response<ShareStatistics> getStatisticsWithResponse(ShareGetStatisticsOptions options, Duration timeout, Context context) {
        Mono<Response<ShareStatistics>> response = this.client.getStatisticsWithResponse(options, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public ShareDirectoryClient createDirectory(String directoryName) {
        return (ShareDirectoryClient)this.createDirectoryWithResponse(directoryName, null, null, null, null, Context.NONE).getValue();
    }

    public Response<ShareDirectoryClient> createDirectoryWithResponse(String directoryName, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Duration timeout, Context context) {
        ShareDirectoryClient shareDirectoryClient = this.getDirectoryClient(directoryName);
        return new SimpleResponse(shareDirectoryClient.createWithResponse(smbProperties, filePermission, metadata, timeout, context), (Object)shareDirectoryClient);
    }

    public ShareFileClient createFile(String fileName, long maxSize) {
        return (ShareFileClient)this.createFileWithResponse(fileName, maxSize, null, null, null, null, null, Context.NONE).getValue();
    }

    public Response<ShareFileClient> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Duration timeout, Context context) {
        return this.createFileWithResponse(fileName, maxSize, httpHeaders, smbProperties, filePermission, metadata, null, timeout, context);
    }

    public Response<ShareFileClient> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        ShareFileClient shareFileClient = this.getFileClient(fileName);
        return new SimpleResponse(shareFileClient.createWithResponse(maxSize, httpHeaders, smbProperties, filePermission, metadata, requestConditions, timeout, context), (Object)shareFileClient);
    }

    public void deleteDirectory(String directoryName) {
        this.deleteDirectoryWithResponse(directoryName, null, Context.NONE);
    }

    public Response<Void> deleteDirectoryWithResponse(String directoryName, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.deleteDirectoryWithResponse(directoryName, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public void deleteFile(String fileName) {
        this.deleteFileWithResponse(fileName, null, Context.NONE);
    }

    public Response<Void> deleteFileWithResponse(String fileName, Duration timeout, Context context) {
        return this.deleteFileWithResponse(fileName, null, timeout, context);
    }

    public Response<Void> deleteFileWithResponse(String fileName, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.deleteFileWithResponse(fileName, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public String createPermission(String filePermission) {
        return (String)this.createPermissionWithResponse(filePermission, Context.NONE).getValue();
    }

    public Response<String> createPermissionWithResponse(String filePermission, Context context) {
        return (Response)this.client.createPermissionWithResponse(filePermission, context).block();
    }

    public String getPermission(String filePermissionKey) {
        return (String)this.getPermissionWithResponse(filePermissionKey, Context.NONE).getValue();
    }

    public Response<String> getPermissionWithResponse(String filePermissionKey, Context context) {
        return (Response)this.client.getPermissionWithResponse(filePermissionKey, context).block();
    }

    public String getSnapshotId() {
        return this.client.getSnapshotId();
    }

    public String getShareName() {
        return this.client.getShareName();
    }

    public String getAccountName() {
        return this.client.getAccountName();
    }

    public HttpPipeline getHttpPipeline() {
        return this.client.getHttpPipeline();
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues) {
        return this.client.generateSas(shareServiceSasSignatureValues);
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues, Context context) {
        return this.client.generateSas(shareServiceSasSignatureValues, context);
    }
}

