/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.SignedIdentifiersWrapper;
import com.azure.storage.file.share.implementation.models.DeleteSnapshotsOptionType;
import com.azure.storage.file.share.implementation.models.SharePermission;
import com.azure.storage.file.share.implementation.models.SharesAcquireLeaseResponse;
import com.azure.storage.file.share.implementation.models.SharesBreakLeaseResponse;
import com.azure.storage.file.share.implementation.models.SharesChangeLeaseResponse;
import com.azure.storage.file.share.implementation.models.SharesCreatePermissionResponse;
import com.azure.storage.file.share.implementation.models.SharesCreateResponse;
import com.azure.storage.file.share.implementation.models.SharesCreateSnapshotResponse;
import com.azure.storage.file.share.implementation.models.SharesDeleteResponse;
import com.azure.storage.file.share.implementation.models.SharesGetAccessPolicyResponse;
import com.azure.storage.file.share.implementation.models.SharesGetPermissionResponse;
import com.azure.storage.file.share.implementation.models.SharesGetPropertiesResponse;
import com.azure.storage.file.share.implementation.models.SharesGetStatisticsResponse;
import com.azure.storage.file.share.implementation.models.SharesReleaseLeaseResponse;
import com.azure.storage.file.share.implementation.models.SharesRenewLeaseResponse;
import com.azure.storage.file.share.implementation.models.SharesRestoreResponse;
import com.azure.storage.file.share.implementation.models.SharesSetAccessPolicyResponse;
import com.azure.storage.file.share.implementation.models.SharesSetMetadataResponse;
import com.azure.storage.file.share.implementation.models.SharesSetPropertiesResponse;
import com.azure.storage.file.share.models.ShareAccessTier;
import com.azure.storage.file.share.models.ShareRootSquash;
import com.azure.storage.file.share.models.ShareSignedIdentifier;
import com.azure.storage.file.share.models.ShareStorageException;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class SharesImpl {
    private SharesService service;
    private AzureFileStorageImpl client;

    public SharesImpl(AzureFileStorageImpl client) {
        this.service = (SharesService)RestProxy.create(SharesService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    public Mono<SharesCreateResponse> createWithRestResponseAsync(String shareName, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        Integer quota = null;
        ShareAccessTier accessTier = null;
        String enabledProtocols = null;
        ShareRootSquash rootSquash = null;
        String restype = "share";
        return this.service.create(shareName, this.client.getUrl(), timeout, metadata, quota, accessTier, this.client.getVersion(), enabledProtocols, rootSquash, "share", context);
    }

    public Mono<SharesCreateResponse> createWithRestResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, Integer quota, ShareAccessTier accessTier, String enabledProtocols, ShareRootSquash rootSquash, Context context) {
        String restype = "share";
        return this.service.create(shareName, this.client.getUrl(), timeout, metadata, quota, accessTier, this.client.getVersion(), enabledProtocols, rootSquash, "share", context);
    }

    public Mono<SharesGetPropertiesResponse> getPropertiesWithRestResponseAsync(String shareName, Context context) {
        String sharesnapshot = null;
        Integer timeout = null;
        String leaseId = null;
        String restype = "share";
        return this.service.getProperties(shareName, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), leaseId, "share", context);
    }

    public Mono<SharesGetPropertiesResponse> getPropertiesWithRestResponseAsync(String shareName, String sharesnapshot, Integer timeout, String leaseId, Context context) {
        String restype = "share";
        return this.service.getProperties(shareName, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), leaseId, "share", context);
    }

    public Mono<SharesDeleteResponse> deleteWithRestResponseAsync(String shareName, Context context) {
        String sharesnapshot = null;
        Integer timeout = null;
        DeleteSnapshotsOptionType deleteSnapshots = null;
        String leaseId = null;
        String restype = "share";
        return this.service.delete(shareName, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), deleteSnapshots, leaseId, "share", context);
    }

    public Mono<SharesDeleteResponse> deleteWithRestResponseAsync(String shareName, String sharesnapshot, Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String leaseId, Context context) {
        String restype = "share";
        return this.service.delete(shareName, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), deleteSnapshots, leaseId, "share", context);
    }

    public Mono<SharesAcquireLeaseResponse> acquireLeaseWithRestResponseAsync(String shareName, Context context) {
        Integer timeout = null;
        Integer duration = null;
        String proposedLeaseId = null;
        String sharesnapshot = null;
        String requestId = null;
        String comp = "lease";
        String action = "acquire";
        String restype = "share";
        return this.service.acquireLease(shareName, this.client.getUrl(), timeout, duration, proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, "lease", "acquire", "share", context);
    }

    public Mono<SharesAcquireLeaseResponse> acquireLeaseWithRestResponseAsync(String shareName, Integer timeout, Integer duration, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        String comp = "lease";
        String action = "acquire";
        String restype = "share";
        return this.service.acquireLease(shareName, this.client.getUrl(), timeout, duration, proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, "lease", "acquire", "share", context);
    }

    public Mono<SharesReleaseLeaseResponse> releaseLeaseWithRestResponseAsync(String shareName, String leaseId, Context context) {
        Integer timeout = null;
        String sharesnapshot = null;
        String requestId = null;
        String comp = "lease";
        String action = "release";
        String restype = "share";
        return this.service.releaseLease(shareName, this.client.getUrl(), timeout, leaseId, this.client.getVersion(), sharesnapshot, requestId, "lease", "release", "share", context);
    }

    public Mono<SharesReleaseLeaseResponse> releaseLeaseWithRestResponseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId, Context context) {
        String comp = "lease";
        String action = "release";
        String restype = "share";
        return this.service.releaseLease(shareName, this.client.getUrl(), timeout, leaseId, this.client.getVersion(), sharesnapshot, requestId, "lease", "release", "share", context);
    }

    public Mono<SharesChangeLeaseResponse> changeLeaseWithRestResponseAsync(String shareName, String leaseId, Context context) {
        Integer timeout = null;
        String proposedLeaseId = null;
        String sharesnapshot = null;
        String requestId = null;
        String comp = "lease";
        String action = "change";
        String restype = "share";
        return this.service.changeLease(shareName, this.client.getUrl(), timeout, leaseId, proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, "lease", "change", "share", context);
    }

    public Mono<SharesChangeLeaseResponse> changeLeaseWithRestResponseAsync(String shareName, String leaseId, Integer timeout, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        String comp = "lease";
        String action = "change";
        String restype = "share";
        return this.service.changeLease(shareName, this.client.getUrl(), timeout, leaseId, proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, "lease", "change", "share", context);
    }

    public Mono<SharesRenewLeaseResponse> renewLeaseWithRestResponseAsync(String shareName, String leaseId, Context context) {
        Integer timeout = null;
        String sharesnapshot = null;
        String requestId = null;
        String comp = "lease";
        String action = "renew";
        String restype = "share";
        return this.service.renewLease(shareName, this.client.getUrl(), timeout, leaseId, this.client.getVersion(), sharesnapshot, requestId, "lease", "renew", "share", context);
    }

    public Mono<SharesRenewLeaseResponse> renewLeaseWithRestResponseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId, Context context) {
        String comp = "lease";
        String action = "renew";
        String restype = "share";
        return this.service.renewLease(shareName, this.client.getUrl(), timeout, leaseId, this.client.getVersion(), sharesnapshot, requestId, "lease", "renew", "share", context);
    }

    public Mono<SharesBreakLeaseResponse> breakLeaseWithRestResponseAsync(String shareName, Context context) {
        Integer timeout = null;
        Integer breakPeriod = null;
        String leaseId = null;
        String requestId = null;
        String sharesnapshot = null;
        String comp = "lease";
        String action = "break";
        String restype = "share";
        return this.service.breakLease(shareName, this.client.getUrl(), timeout, breakPeriod, leaseId, this.client.getVersion(), requestId, sharesnapshot, "lease", "break", "share", context);
    }

    public Mono<SharesBreakLeaseResponse> breakLeaseWithRestResponseAsync(String shareName, Integer timeout, Integer breakPeriod, String leaseId, String requestId, String sharesnapshot, Context context) {
        String comp = "lease";
        String action = "break";
        String restype = "share";
        return this.service.breakLease(shareName, this.client.getUrl(), timeout, breakPeriod, leaseId, this.client.getVersion(), requestId, sharesnapshot, "lease", "break", "share", context);
    }

    public Mono<SharesCreateSnapshotResponse> createSnapshotWithRestResponseAsync(String shareName, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        String restype = "share";
        String comp = "snapshot";
        return this.service.createSnapshot(shareName, this.client.getUrl(), timeout, metadata, this.client.getVersion(), "share", "snapshot", context);
    }

    public Mono<SharesCreateSnapshotResponse> createSnapshotWithRestResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, Context context) {
        String restype = "share";
        String comp = "snapshot";
        return this.service.createSnapshot(shareName, this.client.getUrl(), timeout, metadata, this.client.getVersion(), "share", "snapshot", context);
    }

    public Mono<SharesCreatePermissionResponse> createPermissionWithRestResponseAsync(String shareName, SharePermission sharePermission, Context context) {
        Integer timeout = null;
        String restype = "share";
        String comp = "filepermission";
        return this.service.createPermission(shareName, this.client.getUrl(), timeout, this.client.getVersion(), sharePermission, "share", "filepermission", context);
    }

    public Mono<SharesCreatePermissionResponse> createPermissionWithRestResponseAsync(String shareName, SharePermission sharePermission, Integer timeout, Context context) {
        String restype = "share";
        String comp = "filepermission";
        return this.service.createPermission(shareName, this.client.getUrl(), timeout, this.client.getVersion(), sharePermission, "share", "filepermission", context);
    }

    public Mono<SharesGetPermissionResponse> getPermissionWithRestResponseAsync(String shareName, String filePermissionKey, Context context) {
        Integer timeout = null;
        String restype = "share";
        String comp = "filepermission";
        return this.service.getPermission(shareName, this.client.getUrl(), filePermissionKey, timeout, this.client.getVersion(), "share", "filepermission", context);
    }

    public Mono<SharesGetPermissionResponse> getPermissionWithRestResponseAsync(String shareName, String filePermissionKey, Integer timeout, Context context) {
        String restype = "share";
        String comp = "filepermission";
        return this.service.getPermission(shareName, this.client.getUrl(), filePermissionKey, timeout, this.client.getVersion(), "share", "filepermission", context);
    }

    public Mono<SharesSetPropertiesResponse> setPropertiesWithRestResponseAsync(String shareName, Context context) {
        Integer timeout = null;
        Integer quota = null;
        ShareAccessTier accessTier = null;
        String leaseId = null;
        ShareRootSquash rootSquash = null;
        String restype = "share";
        String comp = "properties";
        return this.service.setProperties(shareName, this.client.getUrl(), timeout, this.client.getVersion(), quota, accessTier, leaseId, rootSquash, "share", "properties", context);
    }

    public Mono<SharesSetPropertiesResponse> setPropertiesWithRestResponseAsync(String shareName, Integer timeout, Integer quota, ShareAccessTier accessTier, String leaseId, ShareRootSquash rootSquash, Context context) {
        String restype = "share";
        String comp = "properties";
        return this.service.setProperties(shareName, this.client.getUrl(), timeout, this.client.getVersion(), quota, accessTier, leaseId, rootSquash, "share", "properties", context);
    }

    public Mono<SharesSetMetadataResponse> setMetadataWithRestResponseAsync(String shareName, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        String leaseId = null;
        String restype = "share";
        String comp = "metadata";
        return this.service.setMetadata(shareName, this.client.getUrl(), timeout, metadata, this.client.getVersion(), leaseId, "share", "metadata", context);
    }

    public Mono<SharesSetMetadataResponse> setMetadataWithRestResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, String leaseId, Context context) {
        String restype = "share";
        String comp = "metadata";
        return this.service.setMetadata(shareName, this.client.getUrl(), timeout, metadata, this.client.getVersion(), leaseId, "share", "metadata", context);
    }

    public Mono<SharesGetAccessPolicyResponse> getAccessPolicyWithRestResponseAsync(String shareName, Context context) {
        Integer timeout = null;
        String leaseId = null;
        String restype = "share";
        String comp = "acl";
        return this.service.getAccessPolicy(shareName, this.client.getUrl(), timeout, this.client.getVersion(), leaseId, "share", "acl", context);
    }

    public Mono<SharesGetAccessPolicyResponse> getAccessPolicyWithRestResponseAsync(String shareName, Integer timeout, String leaseId, Context context) {
        String restype = "share";
        String comp = "acl";
        return this.service.getAccessPolicy(shareName, this.client.getUrl(), timeout, this.client.getVersion(), leaseId, "share", "acl", context);
    }

    public Mono<SharesSetAccessPolicyResponse> setAccessPolicyWithRestResponseAsync(String shareName, Context context) {
        Integer timeout = null;
        String leaseId = null;
        String restype = "share";
        String comp = "acl";
        SignedIdentifiersWrapper shareAclConverted = new SignedIdentifiersWrapper(null);
        return this.service.setAccessPolicy(shareName, this.client.getUrl(), shareAclConverted, timeout, this.client.getVersion(), leaseId, "share", "acl", context);
    }

    public Mono<SharesSetAccessPolicyResponse> setAccessPolicyWithRestResponseAsync(String shareName, List<ShareSignedIdentifier> shareAcl, Integer timeout, String leaseId, Context context) {
        String restype = "share";
        String comp = "acl";
        SignedIdentifiersWrapper shareAclConverted = new SignedIdentifiersWrapper(shareAcl);
        return this.service.setAccessPolicy(shareName, this.client.getUrl(), shareAclConverted, timeout, this.client.getVersion(), leaseId, "share", "acl", context);
    }

    public Mono<SharesGetStatisticsResponse> getStatisticsWithRestResponseAsync(String shareName, Context context) {
        Integer timeout = null;
        String leaseId = null;
        String restype = "share";
        String comp = "stats";
        return this.service.getStatistics(shareName, this.client.getUrl(), timeout, this.client.getVersion(), leaseId, "share", "stats", context);
    }

    public Mono<SharesGetStatisticsResponse> getStatisticsWithRestResponseAsync(String shareName, Integer timeout, String leaseId, Context context) {
        String restype = "share";
        String comp = "stats";
        return this.service.getStatistics(shareName, this.client.getUrl(), timeout, this.client.getVersion(), leaseId, "share", "stats", context);
    }

    public Mono<SharesRestoreResponse> restoreWithRestResponseAsync(String shareName, Context context) {
        Integer timeout = null;
        String requestId = null;
        String deletedShareName = null;
        String deletedShareVersion = null;
        String restype = "share";
        String comp = "undelete";
        return this.service.restore(shareName, this.client.getUrl(), timeout, this.client.getVersion(), requestId, deletedShareName, deletedShareVersion, "share", "undelete", context);
    }

    public Mono<SharesRestoreResponse> restoreWithRestResponseAsync(String shareName, Integer timeout, String requestId, String deletedShareName, String deletedShareVersion, Context context) {
        String restype = "share";
        String comp = "undelete";
        return this.service.restore(shareName, this.client.getUrl(), timeout, this.client.getVersion(), requestId, deletedShareName, deletedShareVersion, "share", "undelete", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureFileStorageShares")
    private static interface SharesService {
        @Put(value="{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesCreateResponse> create(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-share-quota") Integer var5, @HeaderParam(value="x-ms-access-tier") ShareAccessTier var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-enabled-protocols") String var8, @HeaderParam(value="x-ms-root-squash") ShareRootSquash var9, @QueryParam(value="restype") String var10, Context var11);

        @Get(value="{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesGetPropertiesResponse> getProperties(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="sharesnapshot") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-lease-id") String var6, @QueryParam(value="restype") String var7, Context var8);

        @Delete(value="{shareName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesDeleteResponse> delete(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="sharesnapshot") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-delete-snapshots") DeleteSnapshotsOptionType var6, @HeaderParam(value="x-ms-lease-id") String var7, @QueryParam(value="restype") String var8, Context var9);

        @Put(value="{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesAcquireLeaseResponse> acquireLease(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-duration") Integer var4, @HeaderParam(value="x-ms-proposed-lease-id") String var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="sharesnapshot") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @QueryParam(value="comp") String var9, @HeaderParam(value="x-ms-lease-action") String var10, @QueryParam(value="restype") String var11, Context var12);

        @Put(value="{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesReleaseLeaseResponse> releaseLease(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="x-ms-version") String var5, @QueryParam(value="sharesnapshot") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="comp") String var8, @HeaderParam(value="x-ms-lease-action") String var9, @QueryParam(value="restype") String var10, Context var11);

        @Put(value="{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesChangeLeaseResponse> changeLease(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="x-ms-proposed-lease-id") String var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="sharesnapshot") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @QueryParam(value="comp") String var9, @HeaderParam(value="x-ms-lease-action") String var10, @QueryParam(value="restype") String var11, Context var12);

        @Put(value="{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesRenewLeaseResponse> renewLease(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="x-ms-version") String var5, @QueryParam(value="sharesnapshot") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="comp") String var8, @HeaderParam(value="x-ms-lease-action") String var9, @QueryParam(value="restype") String var10, Context var11);

        @Put(value="{shareName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesBreakLeaseResponse> breakLease(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-break-period") Integer var4, @HeaderParam(value="x-ms-lease-id") String var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="sharesnapshot") String var8, @QueryParam(value="comp") String var9, @HeaderParam(value="x-ms-lease-action") String var10, @QueryParam(value="restype") String var11, Context var12);

        @Put(value="{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesCreateSnapshotResponse> createSnapshot(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-version") String var5, @QueryParam(value="restype") String var6, @QueryParam(value="comp") String var7, Context var8);

        @Put(value="{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesCreatePermissionResponse> createPermission(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @BodyParam(value="application/json; charset=utf-8") SharePermission var5, @QueryParam(value="restype") String var6, @QueryParam(value="comp") String var7, Context var8);

        @Get(value="{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesGetPermissionResponse> getPermission(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-file-permission-key") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @QueryParam(value="restype") String var6, @QueryParam(value="comp") String var7, Context var8);

        @Put(value="{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesSetPropertiesResponse> setProperties(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-share-quota") Integer var5, @HeaderParam(value="x-ms-access-tier") ShareAccessTier var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-root-squash") ShareRootSquash var8, @QueryParam(value="restype") String var9, @QueryParam(value="comp") String var10, Context var11);

        @Put(value="{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesSetMetadataResponse> setMetadata(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-lease-id") String var6, @QueryParam(value="restype") String var7, @QueryParam(value="comp") String var8, Context var9);

        @Get(value="{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesGetAccessPolicyResponse> getAccessPolicy(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-lease-id") String var5, @QueryParam(value="restype") String var6, @QueryParam(value="comp") String var7, Context var8);

        @Put(value="{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesSetAccessPolicyResponse> setAccessPolicy(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @BodyParam(value="application/xml; charset=utf-8") SignedIdentifiersWrapper var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-lease-id") String var6, @QueryParam(value="restype") String var7, @QueryParam(value="comp") String var8, Context var9);

        @Get(value="{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesGetStatisticsResponse> getStatistics(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-lease-id") String var5, @QueryParam(value="restype") String var6, @QueryParam(value="comp") String var7, Context var8);

        @Put(value="{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<SharesRestoreResponse> restore(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @HeaderParam(value="x-ms-deleted-share-name") String var6, @HeaderParam(value="x-ms-deleted-share-version") String var7, @QueryParam(value="restype") String var8, @QueryParam(value="comp") String var9, Context var10);
    }
}

