/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.models;

import com.azure.storage.file.share.models.ClearRange;
import com.azure.storage.file.share.models.FileRange;
import com.azure.storage.file.share.models.ShareFileRangeList;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.ArrayList;

final class ShareFileRangeListDeserializer
extends JsonDeserializer<ShareFileRangeList> {
    ShareFileRangeListDeserializer() {
    }

    public ShareFileRangeList deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayList<FileRange> pageRanges = new ArrayList<FileRange>();
        ArrayList<ClearRange> clearRanges = new ArrayList<ClearRange>();
        JsonDeserializer pageRangeDeserializer = ctxt.findRootValueDeserializer(ctxt.constructType(FileRange.class));
        JsonDeserializer clearRangeDeserializer = ctxt.findRootValueDeserializer(ctxt.constructType(ClearRange.class));
        JsonToken currentToken = p.nextToken();
        while (currentToken.id() != 2) {
            p.nextToken();
            if (p.getCurrentName().equals("Range")) {
                pageRanges.add((FileRange)pageRangeDeserializer.deserialize(p, ctxt));
            } else if (p.getCurrentName().equals("ClearRange")) {
                clearRanges.add((ClearRange)clearRangeDeserializer.deserialize(p, ctxt));
            }
            currentToken = p.nextToken();
        }
        return new ShareFileRangeList().setRanges(pageRanges).setClearRanges(clearRanges);
    }
}

