/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.specialized;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.file.share.implementation.AzureFileStorageBuilder;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.FileAcquireLeaseHeaders;
import com.azure.storage.file.share.implementation.models.FileChangeLeaseHeaders;
import com.azure.storage.file.share.implementation.models.ShareAcquireLeaseHeaders;
import com.azure.storage.file.share.implementation.models.ShareChangeLeaseHeaders;
import com.azure.storage.file.share.implementation.models.ShareRenewLeaseHeaders;
import com.azure.storage.file.share.options.ShareAcquireLeaseOptions;
import com.azure.storage.file.share.options.ShareBreakLeaseOptions;
import reactor.core.publisher.Mono;

public final class ShareLeaseAsyncClient {
    private final ClientLogger logger = new ClientLogger(ShareLeaseAsyncClient.class);
    private final boolean isShareFile;
    private final String leaseId;
    private final AzureFileStorageImpl client;
    private final String accountName;

    ShareLeaseAsyncClient(HttpPipeline pipeline, String url, String leaseId, boolean isShareFile, String accountName, String serviceVersion) {
        this.isShareFile = isShareFile;
        this.leaseId = leaseId;
        this.client = new AzureFileStorageBuilder().pipeline(pipeline).url(url).version(serviceVersion).build();
        this.accountName = accountName;
    }

    @Deprecated
    public String getFileUrl() {
        return this.client.getUrl();
    }

    public String getResourceUrl() {
        return this.client.getUrl();
    }

    public String getLeaseId() {
        return this.leaseId;
    }

    public Mono<String> acquireLease() {
        try {
            return this.acquireLeaseWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<String>> acquireLeaseWithResponse() {
        try {
            return this.acquireLeaseWithResponse(new ShareAcquireLeaseOptions());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<String>> acquireLeaseWithResponse(ShareAcquireLeaseOptions options) {
        try {
            return FluxUtil.withContext(context -> this.acquireLeaseWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> acquireLeaseWithResponse(ShareAcquireLeaseOptions options, Context context) {
        options = options == null ? new ShareAcquireLeaseOptions() : options;
        Context context2 = context = context == null ? Context.NONE : context;
        if (this.isShareFile) {
            return this.client.files().acquireLeaseWithRestResponseAsync(null, null, null, options.getDuration(), this.leaseId, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((FileAcquireLeaseHeaders)rb.getDeserializedHeaders()).getLeaseId()));
        }
        return this.client.shares().acquireLeaseWithRestResponseAsync(null, null, options.getDuration(), this.leaseId, null, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((ShareAcquireLeaseHeaders)rb.getDeserializedHeaders()).getLeaseId()));
    }

    public Mono<Void> releaseLease() {
        try {
            return this.releaseLeaseWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> releaseLeaseWithResponse() {
        try {
            return FluxUtil.withContext(this::releaseLeaseWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> releaseLeaseWithResponse(Context context) {
        Context context2 = context = context == null ? Context.NONE : context;
        if (this.isShareFile) {
            return this.client.files().releaseLeaseWithRestResponseAsync(null, null, this.leaseId, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
        }
        return this.client.shares().releaseLeaseWithRestResponseAsync(null, this.leaseId, null, null, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<Void> breakLease() {
        try {
            return this.breakLeaseWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> breakLeaseWithResponse() {
        try {
            return this.breakLeaseWithResponse(new ShareBreakLeaseOptions());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> breakLeaseWithResponse(ShareBreakLeaseOptions options) {
        try {
            return FluxUtil.withContext(context -> this.breakLeaseWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> breakLeaseWithResponse(ShareBreakLeaseOptions options, Context context) {
        Integer breakPeriod;
        options = options == null ? new ShareBreakLeaseOptions() : options;
        context = context == null ? Context.NONE : context;
        Integer n = breakPeriod = options.getBreakPeriod() == null ? null : Integer.valueOf(Math.toIntExact(options.getBreakPeriod().getSeconds()));
        if (this.isShareFile) {
            return this.client.files().breakLeaseWithRestResponseAsync(null, null, null, null, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, null));
        }
        return this.client.shares().breakLeaseWithRestResponseAsync(null, null, breakPeriod, null, null, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, null));
    }

    public Mono<String> changeLease(String proposedId) {
        try {
            return this.changeLeaseWithResponse(proposedId).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<String>> changeLeaseWithResponse(String proposedId) {
        try {
            return FluxUtil.withContext(context -> this.changeLeaseWithResponse(proposedId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> changeLeaseWithResponse(String proposedId, Context context) {
        Context context2 = context = context == null ? Context.NONE : context;
        if (this.isShareFile) {
            return this.client.files().changeLeaseWithRestResponseAsync(null, null, this.leaseId, null, proposedId, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((FileChangeLeaseHeaders)rb.getDeserializedHeaders()).getLeaseId()));
        }
        return this.client.shares().changeLeaseWithRestResponseAsync(null, this.leaseId, null, proposedId, null, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((ShareChangeLeaseHeaders)rb.getDeserializedHeaders()).getLeaseId()));
    }

    public Mono<String> renewLease() {
        try {
            return this.renewLeaseWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<String>> renewLeaseWithResponse() {
        try {
            return FluxUtil.withContext(this::renewLeaseWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> renewLeaseWithResponse(Context context) {
        Context context2 = context = context == null ? Context.NONE : context;
        if (this.isShareFile) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot renew a lease on a share file."));
        }
        return this.client.shares().renewLeaseWithRestResponseAsync(null, this.leaseId, null, null, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((ShareRenewLeaseHeaders)rb.getDeserializedHeaders()).getLeaseId()));
    }

    public String getAccountName() {
        return this.accountName;
    }
}

