/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.specialized;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.storage.file.share.ShareAsyncClient;
import com.azure.storage.file.share.ShareClient;
import com.azure.storage.file.share.ShareFileAsyncClient;
import com.azure.storage.file.share.ShareFileClient;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.specialized.ShareLeaseAsyncClient;
import com.azure.storage.file.share.specialized.ShareLeaseClient;
import java.util.Objects;
import java.util.UUID;

@ServiceClientBuilder(serviceClients={ShareLeaseClient.class, ShareLeaseAsyncClient.class})
public final class ShareLeaseClientBuilder {
    private HttpPipeline pipeline;
    private String url;
    private String leaseId;
    private boolean isShareFile;
    private String accountName;
    private ShareServiceVersion serviceVersion;

    public ShareLeaseClient buildClient() {
        return new ShareLeaseClient(this.buildAsyncClient());
    }

    public ShareLeaseAsyncClient buildAsyncClient() {
        ShareServiceVersion version = this.serviceVersion == null ? ShareServiceVersion.getLatest() : this.serviceVersion;
        return new ShareLeaseAsyncClient(this.pipeline, this.url, this.getLeaseId(), this.isShareFile, this.accountName, version.getVersion());
    }

    public ShareLeaseClientBuilder fileClient(ShareFileClient fileClient) {
        Objects.requireNonNull(fileClient);
        this.pipeline = fileClient.getHttpPipeline();
        this.url = fileClient.getFileUrl();
        this.isShareFile = true;
        this.accountName = fileClient.getAccountName();
        this.serviceVersion = fileClient.getServiceVersion();
        return this;
    }

    public ShareLeaseClientBuilder fileAsyncClient(ShareFileAsyncClient fileAsyncClient) {
        Objects.requireNonNull(fileAsyncClient);
        this.pipeline = fileAsyncClient.getHttpPipeline();
        this.url = fileAsyncClient.getFileUrl();
        this.isShareFile = true;
        this.accountName = fileAsyncClient.getAccountName();
        this.serviceVersion = fileAsyncClient.getServiceVersion();
        return this;
    }

    ShareLeaseClientBuilder shareClient(ShareClient shareClient) {
        Objects.requireNonNull(shareClient);
        this.pipeline = shareClient.getHttpPipeline();
        this.url = shareClient.getShareUrl();
        this.isShareFile = false;
        this.accountName = shareClient.getAccountName();
        this.serviceVersion = shareClient.getServiceVersion();
        return this;
    }

    ShareLeaseClientBuilder shareAsyncClient(ShareAsyncClient shareAsyncClient) {
        Objects.requireNonNull(shareAsyncClient);
        this.pipeline = shareAsyncClient.getHttpPipeline();
        this.url = shareAsyncClient.getShareUrl();
        this.isShareFile = false;
        this.accountName = shareAsyncClient.getAccountName();
        this.serviceVersion = shareAsyncClient.getServiceVersion();
        return this;
    }

    public ShareLeaseClientBuilder leaseId(String leaseId) {
        this.leaseId = leaseId;
        return this;
    }

    private String getLeaseId() {
        return this.leaseId == null ? UUID.randomUUID().toString() : this.leaseId;
    }
}

