/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.ContainerServiceAgentPoolProfile;
import com.azure.resourcemanager.compute.models.ContainerServiceCustomProfile;
import com.azure.resourcemanager.compute.models.ContainerServiceDiagnosticsProfile;
import com.azure.resourcemanager.compute.models.ContainerServiceLinuxProfile;
import com.azure.resourcemanager.compute.models.ContainerServiceMasterProfile;
import com.azure.resourcemanager.compute.models.ContainerServiceOrchestratorProfile;
import com.azure.resourcemanager.compute.models.ContainerServicePrincipalProfile;
import com.azure.resourcemanager.compute.models.ContainerServiceWindowsProfile;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class ContainerServiceInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ContainerServiceInner.class);
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.orchestratorProfile")
    private ContainerServiceOrchestratorProfile orchestratorProfile;
    @JsonProperty(value="properties.customProfile")
    private ContainerServiceCustomProfile customProfile;
    @JsonProperty(value="properties.servicePrincipalProfile")
    private ContainerServicePrincipalProfile servicePrincipalProfile;
    @JsonProperty(value="properties.masterProfile")
    private ContainerServiceMasterProfile masterProfile;
    @JsonProperty(value="properties.agentPoolProfiles")
    private List<ContainerServiceAgentPoolProfile> agentPoolProfiles;
    @JsonProperty(value="properties.windowsProfile")
    private ContainerServiceWindowsProfile windowsProfile;
    @JsonProperty(value="properties.linuxProfile")
    private ContainerServiceLinuxProfile linuxProfile;
    @JsonProperty(value="properties.diagnosticsProfile")
    private ContainerServiceDiagnosticsProfile diagnosticsProfile;

    public String provisioningState() {
        return this.provisioningState;
    }

    public ContainerServiceOrchestratorProfile orchestratorProfile() {
        return this.orchestratorProfile;
    }

    public ContainerServiceInner withOrchestratorProfile(ContainerServiceOrchestratorProfile orchestratorProfile) {
        this.orchestratorProfile = orchestratorProfile;
        return this;
    }

    public ContainerServiceCustomProfile customProfile() {
        return this.customProfile;
    }

    public ContainerServiceInner withCustomProfile(ContainerServiceCustomProfile customProfile) {
        this.customProfile = customProfile;
        return this;
    }

    public ContainerServicePrincipalProfile servicePrincipalProfile() {
        return this.servicePrincipalProfile;
    }

    public ContainerServiceInner withServicePrincipalProfile(ContainerServicePrincipalProfile servicePrincipalProfile) {
        this.servicePrincipalProfile = servicePrincipalProfile;
        return this;
    }

    public ContainerServiceMasterProfile masterProfile() {
        return this.masterProfile;
    }

    public ContainerServiceInner withMasterProfile(ContainerServiceMasterProfile masterProfile) {
        this.masterProfile = masterProfile;
        return this;
    }

    public List<ContainerServiceAgentPoolProfile> agentPoolProfiles() {
        return this.agentPoolProfiles;
    }

    public ContainerServiceInner withAgentPoolProfiles(List<ContainerServiceAgentPoolProfile> agentPoolProfiles) {
        this.agentPoolProfiles = agentPoolProfiles;
        return this;
    }

    public ContainerServiceWindowsProfile windowsProfile() {
        return this.windowsProfile;
    }

    public ContainerServiceInner withWindowsProfile(ContainerServiceWindowsProfile windowsProfile) {
        this.windowsProfile = windowsProfile;
        return this;
    }

    public ContainerServiceLinuxProfile linuxProfile() {
        return this.linuxProfile;
    }

    public ContainerServiceInner withLinuxProfile(ContainerServiceLinuxProfile linuxProfile) {
        this.linuxProfile = linuxProfile;
        return this;
    }

    public ContainerServiceDiagnosticsProfile diagnosticsProfile() {
        return this.diagnosticsProfile;
    }

    public ContainerServiceInner withDiagnosticsProfile(ContainerServiceDiagnosticsProfile diagnosticsProfile) {
        this.diagnosticsProfile = diagnosticsProfile;
        return this;
    }

    public void validate() {
        if (this.orchestratorProfile() != null) {
            this.orchestratorProfile().validate();
        }
        if (this.customProfile() != null) {
            this.customProfile().validate();
        }
        if (this.servicePrincipalProfile() != null) {
            this.servicePrincipalProfile().validate();
        }
        if (this.masterProfile() != null) {
            this.masterProfile().validate();
        }
        if (this.agentPoolProfiles() != null) {
            this.agentPoolProfiles().forEach(e -> e.validate());
        }
        if (this.windowsProfile() != null) {
            this.windowsProfile().validate();
        }
        if (this.linuxProfile() != null) {
            this.linuxProfile().validate();
        }
        if (this.diagnosticsProfile() != null) {
            this.diagnosticsProfile().validate();
        }
    }
}

