/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.DedicatedHostInstanceView;
import com.azure.resourcemanager.compute.models.DedicatedHostLicenseTypes;
import com.azure.resourcemanager.compute.models.Sku;
import com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

@JsonFlatten
public class DedicatedHostInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DedicatedHostInner.class);
    @JsonProperty(value="sku", required=true)
    private Sku sku;
    @JsonProperty(value="properties.platformFaultDomain")
    private Integer platformFaultDomain;
    @JsonProperty(value="properties.autoReplaceOnFailure")
    private Boolean autoReplaceOnFailure;
    @JsonProperty(value="properties.hostId", access=JsonProperty.Access.WRITE_ONLY)
    private String hostId;
    @JsonProperty(value="properties.virtualMachines", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResourceReadOnly> virtualMachines;
    @JsonProperty(value="properties.licenseType")
    private DedicatedHostLicenseTypes licenseType;
    @JsonProperty(value="properties.provisioningTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime provisioningTime;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.instanceView", access=JsonProperty.Access.WRITE_ONLY)
    private DedicatedHostInstanceView instanceView;

    public Sku sku() {
        return this.sku;
    }

    public DedicatedHostInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Integer platformFaultDomain() {
        return this.platformFaultDomain;
    }

    public DedicatedHostInner withPlatformFaultDomain(Integer platformFaultDomain) {
        this.platformFaultDomain = platformFaultDomain;
        return this;
    }

    public Boolean autoReplaceOnFailure() {
        return this.autoReplaceOnFailure;
    }

    public DedicatedHostInner withAutoReplaceOnFailure(Boolean autoReplaceOnFailure) {
        this.autoReplaceOnFailure = autoReplaceOnFailure;
        return this;
    }

    public String hostId() {
        return this.hostId;
    }

    public List<SubResourceReadOnly> virtualMachines() {
        return this.virtualMachines;
    }

    public DedicatedHostLicenseTypes licenseType() {
        return this.licenseType;
    }

    public DedicatedHostInner withLicenseType(DedicatedHostLicenseTypes licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public OffsetDateTime provisioningTime() {
        return this.provisioningTime;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public DedicatedHostInstanceView instanceView() {
        return this.instanceView;
    }

    public void validate() {
        if (this.sku() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sku in model DedicatedHostInner"));
        }
        this.sku().validate();
        if (this.virtualMachines() != null) {
            this.virtualMachines().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
    }
}

