/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineImageResourceInner;
import com.azure.resourcemanager.compute.models.AutomaticOSUpgradeProperties;
import com.azure.resourcemanager.compute.models.DataDiskImage;
import com.azure.resourcemanager.compute.models.HyperVGenerationTypes;
import com.azure.resourcemanager.compute.models.OSDiskImage;
import com.azure.resourcemanager.compute.models.PurchasePlan;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class VirtualMachineImageInner
extends VirtualMachineImageResourceInner {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualMachineImageInner.class);
    @JsonProperty(value="properties.plan")
    private PurchasePlan plan;
    @JsonProperty(value="properties.osDiskImage")
    private OSDiskImage osDiskImage;
    @JsonProperty(value="properties.dataDiskImages")
    private List<DataDiskImage> dataDiskImages;
    @JsonProperty(value="properties.automaticOSUpgradeProperties")
    private AutomaticOSUpgradeProperties automaticOSUpgradeProperties;
    @JsonProperty(value="properties.hyperVGeneration")
    private HyperVGenerationTypes hyperVGeneration;

    public PurchasePlan plan() {
        return this.plan;
    }

    public VirtualMachineImageInner withPlan(PurchasePlan plan) {
        this.plan = plan;
        return this;
    }

    public OSDiskImage osDiskImage() {
        return this.osDiskImage;
    }

    public VirtualMachineImageInner withOsDiskImage(OSDiskImage osDiskImage) {
        this.osDiskImage = osDiskImage;
        return this;
    }

    public List<DataDiskImage> dataDiskImages() {
        return this.dataDiskImages;
    }

    public VirtualMachineImageInner withDataDiskImages(List<DataDiskImage> dataDiskImages) {
        this.dataDiskImages = dataDiskImages;
        return this;
    }

    public AutomaticOSUpgradeProperties automaticOSUpgradeProperties() {
        return this.automaticOSUpgradeProperties;
    }

    public VirtualMachineImageInner withAutomaticOSUpgradeProperties(AutomaticOSUpgradeProperties automaticOSUpgradeProperties) {
        this.automaticOSUpgradeProperties = automaticOSUpgradeProperties;
        return this;
    }

    public HyperVGenerationTypes hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public VirtualMachineImageInner withHyperVGeneration(HyperVGenerationTypes hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.plan() != null) {
            this.plan().validate();
        }
        if (this.osDiskImage() != null) {
            this.osDiskImage().validate();
        }
        if (this.dataDiskImages() != null) {
            this.dataDiskImages().forEach(e -> e.validate());
        }
        if (this.automaticOSUpgradeProperties() != null) {
            this.automaticOSUpgradeProperties().validate();
        }
    }
}

