/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.DedicatedHostInstanceView;
import com.azure.resourcemanager.compute.models.DedicatedHostLicenseTypes;
import com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import com.azure.resourcemanager.compute.models.UpdateResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

@JsonFlatten
public class DedicatedHostUpdate
extends UpdateResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DedicatedHostUpdate.class);
    @JsonProperty(value="properties.platformFaultDomain")
    private Integer platformFaultDomain;
    @JsonProperty(value="properties.autoReplaceOnFailure")
    private Boolean autoReplaceOnFailure;
    @JsonProperty(value="properties.hostId", access=JsonProperty.Access.WRITE_ONLY)
    private String hostId;
    @JsonProperty(value="properties.virtualMachines", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResourceReadOnly> virtualMachines;
    @JsonProperty(value="properties.licenseType")
    private DedicatedHostLicenseTypes licenseType;
    @JsonProperty(value="properties.provisioningTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime provisioningTime;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.instanceView", access=JsonProperty.Access.WRITE_ONLY)
    private DedicatedHostInstanceView instanceView;

    public Integer platformFaultDomain() {
        return this.platformFaultDomain;
    }

    public DedicatedHostUpdate withPlatformFaultDomain(Integer platformFaultDomain) {
        this.platformFaultDomain = platformFaultDomain;
        return this;
    }

    public Boolean autoReplaceOnFailure() {
        return this.autoReplaceOnFailure;
    }

    public DedicatedHostUpdate withAutoReplaceOnFailure(Boolean autoReplaceOnFailure) {
        this.autoReplaceOnFailure = autoReplaceOnFailure;
        return this;
    }

    public String hostId() {
        return this.hostId;
    }

    public List<SubResourceReadOnly> virtualMachines() {
        return this.virtualMachines;
    }

    public DedicatedHostLicenseTypes licenseType() {
        return this.licenseType;
    }

    public DedicatedHostUpdate withLicenseType(DedicatedHostLicenseTypes licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public OffsetDateTime provisioningTime() {
        return this.provisioningTime;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public DedicatedHostInstanceView instanceView() {
        return this.instanceView;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.virtualMachines() != null) {
            this.virtualMachines().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
    }
}

