// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The cached image and OS type. */
@Fluent
public final class CachedImages {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(CachedImages.class);

    /*
     * The OS type of the cached image.
     */
    @JsonProperty(value = "osType", required = true)
    private String osType;

    /*
     * The cached image name.
     */
    @JsonProperty(value = "image", required = true)
    private String image;

    /**
     * Get the osType property: The OS type of the cached image.
     *
     * @return the osType value.
     */
    public String osType() {
        return this.osType;
    }

    /**
     * Set the osType property: The OS type of the cached image.
     *
     * @param osType the osType value to set.
     * @return the CachedImages object itself.
     */
    public CachedImages withOsType(String osType) {
        this.osType = osType;
        return this;
    }

    /**
     * Get the image property: The cached image name.
     *
     * @return the image value.
     */
    public String image() {
        return this.image;
    }

    /**
     * Set the image property: The cached image name.
     *
     * @param image the image value to set.
     * @return the CachedImages object itself.
     */
    public CachedImages withImage(String image) {
        this.image = image;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (osType() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property osType in model CachedImages"));
        }
        if (image() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property image in model CachedImages"));
        }
    }
}
