// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for ContainerInstanceOperationsOrigin. */
public final class ContainerInstanceOperationsOrigin extends ExpandableStringEnum<ContainerInstanceOperationsOrigin> {
    /** Static value User for ContainerInstanceOperationsOrigin. */
    public static final ContainerInstanceOperationsOrigin USER = fromString("User");

    /** Static value System for ContainerInstanceOperationsOrigin. */
    public static final ContainerInstanceOperationsOrigin SYSTEM = fromString("System");

    /**
     * Creates or finds a ContainerInstanceOperationsOrigin from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ContainerInstanceOperationsOrigin.
     */
    @JsonCreator
    public static ContainerInstanceOperationsOrigin fromString(String name) {
        return fromString(name, ContainerInstanceOperationsOrigin.class);
    }

    /** @return known ContainerInstanceOperationsOrigin values. */
    public static Collection<ContainerInstanceOperationsOrigin> values() {
        return values(ContainerInstanceOperationsOrigin.class);
    }
}
