/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.resourcemanager.authorization.models.BuiltInRole;
import com.azure.resourcemanager.containerinstance.ContainerInstanceManager;
import com.azure.resourcemanager.containerinstance.fluent.models.ContainerGroupInner;
import com.azure.resourcemanager.containerinstance.models.Container;
import com.azure.resourcemanager.containerinstance.models.ContainerExecResponse;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupRestartPolicy;
import com.azure.resourcemanager.containerinstance.models.DnsConfiguration;
import com.azure.resourcemanager.containerinstance.models.Event;
import com.azure.resourcemanager.containerinstance.models.GpuSku;
import com.azure.resourcemanager.containerinstance.models.LogAnalytics;
import com.azure.resourcemanager.containerinstance.models.LogAnalyticsLogType;
import com.azure.resourcemanager.containerinstance.models.OperatingSystemTypes;
import com.azure.resourcemanager.containerinstance.models.Port;
import com.azure.resourcemanager.containerinstance.models.ResourceIdentityType;
import com.azure.resourcemanager.containerinstance.models.Volume;
import com.azure.resourcemanager.msi.models.Identity;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Attachable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import reactor.core.publisher.Mono;

public interface ContainerGroup
extends GroupableResource<ContainerInstanceManager, ContainerGroupInner>,
Refreshable<ContainerGroup>,
Updatable<Update> {
    public Map<String, Container> containers();

    public Set<Port> externalPorts();

    public int[] externalTcpPorts();

    public int[] externalUdpPorts();

    public Map<String, Volume> volumes();

    public Collection<String> imageRegistryServers();

    public ContainerGroupRestartPolicy restartPolicy();

    public String dnsPrefix();

    public String fqdn();

    public String ipAddress();

    public boolean isIPAddressPublic();

    public boolean isIPAddressPrivate();

    public OperatingSystemTypes osType();

    public String state();

    public String provisioningState();

    public Set<Event> events();

    public DnsConfiguration dnsConfig();

    public String networkProfileId();

    public boolean isManagedServiceIdentityEnabled();

    public String systemAssignedManagedServiceIdentityTenantId();

    public String systemAssignedManagedServiceIdentityPrincipalId();

    public ResourceIdentityType managedServiceIdentityType();

    public Set<String> userAssignedManagedServiceIdentityIds();

    public LogAnalytics logAnalytics();

    public void restart();

    public Mono<Void> restartAsync();

    public void stop();

    public Mono<Void> stopAsync();

    public String getLogContent(String var1);

    public String getLogContent(String var1, int var2);

    public Mono<String> getLogContentAsync(String var1);

    public Mono<String> getLogContentAsync(String var1, int var2);

    public ContainerExecResponse executeCommand(String var1, String var2, int var3, int var4);

    public Mono<ContainerExecResponse> executeCommandAsync(String var1, String var2, int var3, int var4);

    public static interface Update
    extends Resource.UpdateWithTags<Update>,
    Appliable<ContainerGroup> {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends WithRestartPolicy,
        WithSystemAssignedManagedServiceIdentity,
        WithUserAssignedManagedServiceIdentity,
        WithDnsPrefix,
        WithNetworkProfile,
        WithLogAnalytics,
        Creatable<ContainerGroup>,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface WithLogAnalytics {
            public WithCreate withLogAnalytics(String var1, String var2);

            public WithCreate withLogAnalytics(String var1, String var2, LogAnalyticsLogType var3, Map<String, String> var4);
        }

        public static interface WithDnsConfig {
            public WithCreate withDnsServerNames(List<String> var1);

            public WithCreate withDnsConfiguration(List<String> var1, String var2, String var3);
        }

        public static interface DnsConfigFork
        extends WithDnsConfig,
        WithCreate {
        }

        public static interface WithNetworkProfile {
            public DnsConfigFork withExistingNetworkProfile(String var1, String var2, String var3);

            public DnsConfigFork withExistingNetworkProfile(String var1);

            public DnsConfigFork withNewNetworkProfileOnExistingVirtualNetwork(String var1, String var2);

            public DnsConfigFork withNewNetworkProfileOnExistingVirtualNetwork(String var1, String var2, String var3);

            public DnsConfigFork withNewVirtualNetwork(String var1);
        }

        public static interface WithDnsPrefix {
            public WithCreate withDnsPrefix(String var1);
        }

        public static interface WithRestartPolicy {
            public WithCreate withRestartPolicy(ContainerGroupRestartPolicy var1);
        }

        public static interface WithUserAssignedManagedServiceIdentity {
            public WithCreate withNewUserAssignedManagedServiceIdentity(Creatable<Identity> var1);

            public WithCreate withExistingUserAssignedManagedServiceIdentity(Identity var1);
        }

        public static interface WithSystemAssignedIdentityBasedAccessOrCreate
        extends WithCreate {
            public WithSystemAssignedIdentityBasedAccessOrCreate withSystemAssignedIdentityBasedAccessTo(String var1, BuiltInRole var2);

            public WithSystemAssignedIdentityBasedAccessOrCreate withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(BuiltInRole var1);

            public WithSystemAssignedIdentityBasedAccessOrCreate withSystemAssignedIdentityBasedAccessTo(String var1, String var2);

            public WithSystemAssignedIdentityBasedAccessOrCreate withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(String var1);
        }

        public static interface WithSystemAssignedManagedServiceIdentity {
            public WithSystemAssignedIdentityBasedAccessOrCreate withSystemAssignedManagedServiceIdentity();
        }

        public static interface ContainerInstanceDefinitionStages {

            public static interface ContainerInstanceDefinition<ParentT>
            extends ContainerInstanceDefinitionBlank<ParentT>,
            WithImage<ParentT>,
            WithOrWithoutPorts<ParentT>,
            WithPortsOrContainerInstanceAttach<ParentT>,
            WithContainerInstanceAttach<ParentT> {
            }

            public static interface WithContainerInstanceAttach<ParentT>
            extends WithCpuCoreCount<ParentT>,
            WithGpuResource<ParentT>,
            WithMemorySize<ParentT>,
            WithStartingCommandLine<ParentT>,
            WithEnvironmentVariables<ParentT>,
            WithVolumeMountSetting<ParentT>,
            Attachable.InDefinition<ParentT> {
            }

            public static interface WithVolumeMountSetting<ParentT> {
                public WithContainerInstanceAttach<ParentT> withVolumeMountSetting(String var1, String var2);

                public WithContainerInstanceAttach<ParentT> withVolumeMountSetting(Map<String, String> var1);

                public WithContainerInstanceAttach<ParentT> withReadOnlyVolumeMountSetting(String var1, String var2);

                public WithContainerInstanceAttach<ParentT> withReadOnlyVolumeMountSetting(Map<String, String> var1);
            }

            public static interface WithEnvironmentVariables<ParentT> {
                public WithContainerInstanceAttach<ParentT> withEnvironmentVariables(Map<String, String> var1);

                public WithContainerInstanceAttach<ParentT> withEnvironmentVariable(String var1, String var2);

                public WithContainerInstanceAttach<ParentT> withEnvironmentVariableWithSecuredValue(Map<String, String> var1);

                public WithContainerInstanceAttach<ParentT> withEnvironmentVariableWithSecuredValue(String var1, String var2);
            }

            public static interface WithStartingCommandLine<ParentT> {
                public WithContainerInstanceAttach<ParentT> withStartingCommandLine(String var1, String ... var2);

                public WithContainerInstanceAttach<ParentT> withStartingCommandLine(String var1);
            }

            public static interface WithMemorySize<ParentT> {
                public WithContainerInstanceAttach<ParentT> withMemorySizeInGB(double var1);
            }

            public static interface WithGpuResource<ParentT> {
                public WithContainerInstanceAttach<ParentT> withGpuResource(int var1, GpuSku var2);
            }

            public static interface WithCpuCoreCount<ParentT> {
                public WithContainerInstanceAttach<ParentT> withCpuCoreCount(double var1);
            }

            public static interface WithPorts<ParentT> {
                public WithPortsOrContainerInstanceAttach<ParentT> withExternalTcpPorts(int ... var1);

                public WithPortsOrContainerInstanceAttach<ParentT> withExternalTcpPort(int var1);

                public WithPortsOrContainerInstanceAttach<ParentT> withExternalUdpPorts(int ... var1);

                public WithPortsOrContainerInstanceAttach<ParentT> withExternalUdpPort(int var1);

                public WithPortsOrContainerInstanceAttach<ParentT> withInternalTcpPorts(int ... var1);

                public WithPortsOrContainerInstanceAttach<ParentT> withInternalUdpPorts(int ... var1);

                public WithPortsOrContainerInstanceAttach<ParentT> withInternalTcpPort(int var1);

                public WithPortsOrContainerInstanceAttach<ParentT> withInternalUdpPort(int var1);
            }

            public static interface WithPortsOrContainerInstanceAttach<ParentT>
            extends WithPorts<ParentT>,
            WithContainerInstanceAttach<ParentT> {
            }

            public static interface WithoutPorts<ParentT> {
                public WithContainerInstanceAttach<ParentT> withoutPorts();
            }

            public static interface WithOrWithoutPorts<ParentT>
            extends WithPorts<ParentT>,
            WithoutPorts<ParentT> {
            }

            public static interface WithImage<ParentT> {
                public WithOrWithoutPorts<ParentT> withImage(String var1);
            }

            public static interface ContainerInstanceDefinitionBlank<ParentT>
            extends WithImage<ParentT> {
            }
        }

        public static interface WithNextContainerInstance
        extends WithCreate {
            public ContainerInstanceDefinitionStages.ContainerInstanceDefinitionBlank<WithNextContainerInstance> defineContainerInstance(String var1);
        }

        public static interface WithFirstContainerInstance {
            public ContainerInstanceDefinitionStages.ContainerInstanceDefinitionBlank<WithNextContainerInstance> defineContainerInstance(String var1);

            public WithCreate withContainerInstance(String var1);

            public WithCreate withContainerInstance(String var1, int var2);
        }

        public static interface VolumeDefinitionStages {

            public static interface VolumeDefinition<ParentT>
            extends VolumeDefinitionBlank<ParentT>,
            WithAzureFileShare<ParentT>,
            WithStorageAccountName<ParentT>,
            WithStorageAccountKey<ParentT>,
            WithSecretsMap<ParentT>,
            WithGitUrl<ParentT>,
            WithGitDirectoryName<ParentT>,
            WithGitRevision<ParentT>,
            WithVolumeAttach<ParentT> {
            }

            public static interface WithVolumeAttach<ParentT>
            extends Attachable.InDefinition<ParentT> {
            }

            public static interface WithGitRevision<ParentT>
            extends WithVolumeAttach<ParentT> {
                public WithVolumeAttach<ParentT> withGitRevision(String var1);
            }

            public static interface WithGitDirectoryName<ParentT>
            extends WithGitRevision<ParentT> {
                public WithGitRevision<ParentT> withGitDirectoryName(String var1);
            }

            public static interface WithGitUrl<ParentT> {
                public WithGitDirectoryName<ParentT> withGitUrl(String var1);
            }

            public static interface WithSecretsMap<ParentT> {
                public WithVolumeAttach<ParentT> withSecrets(Map<String, String> var1);
            }

            public static interface WithStorageAccountKey<ParentT> {
                public WithVolumeAttach<ParentT> withStorageAccountKey(String var1);
            }

            public static interface WithStorageAccountName<ParentT> {
                public WithStorageAccountKey<ParentT> withStorageAccountName(String var1);
            }

            public static interface WithAzureFileShare<ParentT> {
                public WithStorageAccountName<ParentT> withExistingReadWriteAzureFileShare(String var1);

                public WithStorageAccountName<ParentT> withExistingReadOnlyAzureFileShare(String var1);
            }

            public static interface VolumeDefinitionBlank<ParentT>
            extends WithAzureFileShare<ParentT> {
            }
        }

        public static interface WithVolume
        extends WithFirstContainerInstance {
            public VolumeDefinitionStages.VolumeDefinitionBlank<WithVolume> defineVolume(String var1);
        }

        public static interface WithPrivateImageRegistryOrVolume
        extends WithPrivateImageRegistry {
            public WithFirstContainerInstance withoutVolume();

            public WithFirstContainerInstance withNewAzureFileShareVolume(String var1, String var2);

            public WithFirstContainerInstance withEmptyDirectoryVolume(String var1);

            public VolumeDefinitionStages.VolumeDefinitionBlank<WithVolume> defineVolume(String var1);
        }

        public static interface WithPrivateImageRegistry {
            public WithPrivateImageRegistryOrVolume withPrivateImageRegistry(String var1, String var2, String var3);
        }

        public static interface WithPublicImageRegistryOnly {
            public WithPrivateImageRegistryOrVolume withPublicImageRegistryOnly();
        }

        public static interface WithPublicOrPrivateImageRegistry
        extends WithPublicImageRegistryOnly,
        WithPrivateImageRegistry {
        }

        public static interface WithOsType {
            public WithPublicOrPrivateImageRegistry withLinux();

            public WithPublicOrPrivateImageRegistry withWindows();
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithOsType> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithOsType,
    DefinitionStages.WithPublicOrPrivateImageRegistry,
    DefinitionStages.WithPrivateImageRegistryOrVolume,
    DefinitionStages.WithVolume,
    DefinitionStages.WithFirstContainerInstance,
    DefinitionStages.WithSystemAssignedManagedServiceIdentity,
    DefinitionStages.WithSystemAssignedIdentityBasedAccessOrCreate,
    DefinitionStages.WithNextContainerInstance,
    DefinitionStages.DnsConfigFork,
    DefinitionStages.WithCreate {
    }
}

