/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.containerregistry.fluent.ReplicationsClient;
import com.azure.resourcemanager.containerregistry.fluent.models.ReplicationInner;
import com.azure.resourcemanager.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.azure.resourcemanager.containerregistry.models.ReplicationListResult;
import com.azure.resourcemanager.containerregistry.models.ReplicationUpdateParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ReplicationsClientImpl
implements ReplicationsClient {
    private final ClientLogger logger = new ClientLogger(ReplicationsClientImpl.class);
    private final ReplicationsService service;
    private final ContainerRegistryManagementClientImpl client;

    ReplicationsClientImpl(ContainerRegistryManagementClientImpl client) {
        this.service = (ReplicationsService)RestProxy.create(ReplicationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<ReplicationInner>> getWithResponseAsync(String resourceGroupName, String registryName, String replicationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (replicationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter replicationName is required and cannot be null."));
        }
        String apiVersion = "2019-05-01";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, replicationName, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ReplicationInner>> getWithResponseAsync(String resourceGroupName, String registryName, String replicationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (replicationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter replicationName is required and cannot be null."));
        }
        String apiVersion = "2019-05-01";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, replicationName, context);
    }

    @Override
    public Mono<ReplicationInner> getAsync(String resourceGroupName, String registryName, String replicationName) {
        return this.getWithResponseAsync(resourceGroupName, registryName, replicationName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ReplicationInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public ReplicationInner get(String resourceGroupName, String registryName, String replicationName) {
        return (ReplicationInner)((Object)this.getAsync(resourceGroupName, registryName, replicationName).block());
    }

    @Override
    public Response<ReplicationInner> getWithResponse(String resourceGroupName, String registryName, String replicationName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, registryName, replicationName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (replicationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter replicationName is required and cannot be null."));
        }
        if (replication == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter replication is required and cannot be null."));
        }
        replication.validate();
        String apiVersion = "2019-05-01";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, replicationName, replication, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (replicationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter replicationName is required and cannot be null."));
        }
        if (replication == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter replication is required and cannot be null."));
        }
        replication.validate();
        String apiVersion = "2019-05-01";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, replicationName, replication, context);
    }

    @Override
    public PollerFlux<PollResult<ReplicationInner>, ReplicationInner> beginCreateAsync(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, registryName, replicationName, replication);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ReplicationInner.class), (Type)((Object)ReplicationInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<ReplicationInner>, ReplicationInner> beginCreateAsync(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, registryName, replicationName, replication, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ReplicationInner.class), (Type)((Object)ReplicationInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<ReplicationInner>, ReplicationInner> beginCreate(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication) {
        return this.beginCreateAsync(resourceGroupName, registryName, replicationName, replication).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<ReplicationInner>, ReplicationInner> beginCreate(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication, Context context) {
        return this.beginCreateAsync(resourceGroupName, registryName, replicationName, replication, context).getSyncPoller();
    }

    @Override
    public Mono<ReplicationInner> createAsync(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication) {
        return this.beginCreateAsync(resourceGroupName, registryName, replicationName, replication).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<ReplicationInner> createAsync(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication, Context context) {
        return this.beginCreateAsync(resourceGroupName, registryName, replicationName, replication, context).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public ReplicationInner create(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication) {
        return (ReplicationInner)((Object)this.createAsync(resourceGroupName, registryName, replicationName, replication).block());
    }

    @Override
    public ReplicationInner create(String resourceGroupName, String registryName, String replicationName, ReplicationInner replication, Context context) {
        return (ReplicationInner)((Object)this.createAsync(resourceGroupName, registryName, replicationName, replication, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String registryName, String replicationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (replicationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter replicationName is required and cannot be null."));
        }
        String apiVersion = "2019-05-01";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, replicationName, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String registryName, String replicationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (replicationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter replicationName is required and cannot be null."));
        }
        String apiVersion = "2019-05-01";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, replicationName, context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String registryName, String replicationName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, registryName, replicationName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String registryName, String replicationName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, registryName, replicationName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String registryName, String replicationName) {
        return this.beginDeleteAsync(resourceGroupName, registryName, replicationName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String registryName, String replicationName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, registryName, replicationName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String registryName, String replicationName) {
        return this.beginDeleteAsync(resourceGroupName, registryName, replicationName).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String registryName, String replicationName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, registryName, replicationName, context).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void delete(String resourceGroupName, String registryName, String replicationName) {
        this.deleteAsync(resourceGroupName, registryName, replicationName).block();
    }

    @Override
    public void delete(String resourceGroupName, String registryName, String replicationName, Context context) {
        this.deleteAsync(resourceGroupName, registryName, replicationName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (replicationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter replicationName is required and cannot be null."));
        }
        String apiVersion = "2019-05-01";
        ReplicationUpdateParameters replicationUpdateParameters = new ReplicationUpdateParameters();
        replicationUpdateParameters.withTags(tags);
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, replicationName, replicationUpdateParameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (replicationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter replicationName is required and cannot be null."));
        }
        String apiVersion = "2019-05-01";
        ReplicationUpdateParameters replicationUpdateParameters = new ReplicationUpdateParameters();
        replicationUpdateParameters.withTags(tags);
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, replicationName, replicationUpdateParameters, context);
    }

    @Override
    public PollerFlux<PollResult<ReplicationInner>, ReplicationInner> beginUpdateAsync(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, registryName, replicationName, tags);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ReplicationInner.class), (Type)((Object)ReplicationInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<ReplicationInner>, ReplicationInner> beginUpdateAsync(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, registryName, replicationName, tags, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ReplicationInner.class), (Type)((Object)ReplicationInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<ReplicationInner>, ReplicationInner> beginUpdate(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags) {
        return this.beginUpdateAsync(resourceGroupName, registryName, replicationName, tags).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<ReplicationInner>, ReplicationInner> beginUpdate(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags, Context context) {
        return this.beginUpdateAsync(resourceGroupName, registryName, replicationName, tags, context).getSyncPoller();
    }

    @Override
    public Mono<ReplicationInner> updateAsync(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags) {
        return this.beginUpdateAsync(resourceGroupName, registryName, replicationName, tags).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<ReplicationInner> updateAsync(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags, Context context) {
        return this.beginUpdateAsync(resourceGroupName, registryName, replicationName, tags, context).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<ReplicationInner> updateAsync(String resourceGroupName, String registryName, String replicationName) {
        Map<String, String> tags = null;
        return this.beginUpdateAsync(resourceGroupName, registryName, replicationName, tags).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public ReplicationInner update(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags) {
        return (ReplicationInner)((Object)this.updateAsync(resourceGroupName, registryName, replicationName, tags).block());
    }

    @Override
    public ReplicationInner update(String resourceGroupName, String registryName, String replicationName, Map<String, String> tags, Context context) {
        return (ReplicationInner)((Object)this.updateAsync(resourceGroupName, registryName, replicationName, tags, context).block());
    }

    @Override
    public ReplicationInner update(String resourceGroupName, String registryName, String replicationName) {
        Map<String, String> tags = null;
        return (ReplicationInner)((Object)this.updateAsync(resourceGroupName, registryName, replicationName, tags).block());
    }

    private Mono<PagedResponse<ReplicationInner>> listSinglePageAsync(String resourceGroupName, String registryName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        String apiVersion = "2019-05-01";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ReplicationListResult)res.getValue()).value(), ((ReplicationListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ReplicationInner>> listSinglePageAsync(String resourceGroupName, String registryName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        String apiVersion = "2019-05-01";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ReplicationListResult)res.getValue()).value(), ((ReplicationListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<ReplicationInner> listAsync(String resourceGroupName, String registryName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, registryName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<ReplicationInner> listAsync(String resourceGroupName, String registryName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, registryName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<ReplicationInner> list(String resourceGroupName, String registryName) {
        return new PagedIterable(this.listAsync(resourceGroupName, registryName));
    }

    @Override
    public PagedIterable<ReplicationInner> list(String resourceGroupName, String registryName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, registryName, context));
    }

    private Mono<PagedResponse<ReplicationInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ReplicationListResult)res.getValue()).value(), ((ReplicationListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ReplicationInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ReplicationListResult)res.getValue()).value(), ((ReplicationListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerRegistryMan")
    private static interface ReplicationsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ReplicationInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="replicationName") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="replicationName") String var6, @BodyParam(value="application/json") ReplicationInner var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="replicationName") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="replicationName") String var6, @BodyParam(value="application/json") ReplicationUpdateParameters var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ReplicationListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ReplicationListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, Context var3);
    }
}

