/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.AgentProperties;
import com.azure.resourcemanager.containerregistry.models.Credentials;
import com.azure.resourcemanager.containerregistry.models.IdentityProperties;
import com.azure.resourcemanager.containerregistry.models.PlatformUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.TaskStatus;
import com.azure.resourcemanager.containerregistry.models.TaskStepUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.TriggerUpdateParameters;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

@JsonFlatten
public class TaskUpdateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(TaskUpdateParameters.class);
    @JsonProperty(value="identity")
    private IdentityProperties identity;
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="properties.status")
    private TaskStatus status;
    @JsonProperty(value="properties.platform")
    private PlatformUpdateParameters platform;
    @JsonProperty(value="properties.agentConfiguration")
    private AgentProperties agentConfiguration;
    @JsonProperty(value="properties.timeout")
    private Integer timeout;
    @JsonProperty(value="properties.step")
    private TaskStepUpdateParameters step;
    @JsonProperty(value="properties.trigger")
    private TriggerUpdateParameters trigger;
    @JsonProperty(value="properties.credentials")
    private Credentials credentials;

    public IdentityProperties identity() {
        return this.identity;
    }

    public TaskUpdateParameters withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public TaskUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public TaskStatus status() {
        return this.status;
    }

    public TaskUpdateParameters withStatus(TaskStatus status) {
        this.status = status;
        return this;
    }

    public PlatformUpdateParameters platform() {
        return this.platform;
    }

    public TaskUpdateParameters withPlatform(PlatformUpdateParameters platform) {
        this.platform = platform;
        return this;
    }

    public AgentProperties agentConfiguration() {
        return this.agentConfiguration;
    }

    public TaskUpdateParameters withAgentConfiguration(AgentProperties agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
        return this;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public TaskUpdateParameters withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public TaskStepUpdateParameters step() {
        return this.step;
    }

    public TaskUpdateParameters withStep(TaskStepUpdateParameters step) {
        this.step = step;
        return this;
    }

    public TriggerUpdateParameters trigger() {
        return this.trigger;
    }

    public TaskUpdateParameters withTrigger(TriggerUpdateParameters trigger) {
        this.trigger = trigger;
        return this;
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public TaskUpdateParameters withCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.platform() != null) {
            this.platform().validate();
        }
        if (this.agentConfiguration() != null) {
            this.agentConfiguration().validate();
        }
        if (this.step() != null) {
            this.step().validate();
        }
        if (this.trigger() != null) {
            this.trigger().validate();
        }
        if (this.credentials() != null) {
            this.credentials().validate();
        }
    }
}

