/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.WebhookAction;
import com.azure.resourcemanager.containerregistry.models.WebhookStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class WebhookCreateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(WebhookCreateParameters.class);
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="location", required=true)
    private String location;
    @JsonProperty(value="properties.serviceUri")
    private String serviceUri;
    @JsonProperty(value="properties.customHeaders")
    private Map<String, String> customHeaders;
    @JsonProperty(value="properties.status")
    private WebhookStatus status;
    @JsonProperty(value="properties.scope")
    private String scope;
    @JsonProperty(value="properties.actions")
    private List<WebhookAction> actions;

    public Map<String, String> tags() {
        return this.tags;
    }

    public WebhookCreateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String location() {
        return this.location;
    }

    public WebhookCreateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public String serviceUri() {
        return this.serviceUri;
    }

    public WebhookCreateParameters withServiceUri(String serviceUri) {
        this.serviceUri = serviceUri;
        return this;
    }

    public Map<String, String> customHeaders() {
        return this.customHeaders;
    }

    public WebhookCreateParameters withCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
        return this;
    }

    public WebhookStatus status() {
        return this.status;
    }

    public WebhookCreateParameters withStatus(WebhookStatus status) {
        this.status = status;
        return this;
    }

    public String scope() {
        return this.scope;
    }

    public WebhookCreateParameters withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public List<WebhookAction> actions() {
        return this.actions;
    }

    public WebhookCreateParameters withActions(List<WebhookAction> actions) {
        this.actions = actions;
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property location in model WebhookCreateParameters"));
        }
    }
}

