// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.JobTarget;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** A group of job targets. */
@JsonFlatten
@Fluent
public class JobTargetGroupInner extends ProxyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(JobTargetGroupInner.class);

    /*
     * Members of the target group.
     */
    @JsonProperty(value = "properties.members")
    private List<JobTarget> members;

    /**
     * Get the members property: Members of the target group.
     *
     * @return the members value.
     */
    public List<JobTarget> members() {
        return this.members;
    }

    /**
     * Set the members property: Members of the target group.
     *
     * @param members the members value to set.
     * @return the JobTargetGroupInner object itself.
     */
    public JobTargetGroupInner withMembers(List<JobTarget> members) {
        this.members = members;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (members() != null) {
            members().forEach(e -> e.validate());
        }
    }
}
