/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator;

import com.baomidou.dynamic.datasource.creator.BasicDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DruidDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.HikariDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.JndiDataSourceCreator;
import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.dynamic.datasource.enums.SeataMode;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.support.ScriptRunner;
import com.p6spy.engine.spy.P6DataSource;
import io.seata.rm.datasource.DataSourceProxy;
import io.seata.rm.datasource.xa.DataSourceProxyXA;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DataSourceCreator {
    private static final Logger log = LoggerFactory.getLogger(DataSourceCreator.class);
    private static Boolean druidExists = false;
    private static Boolean hikariExists = false;
    private BasicDataSourceCreator basicDataSourceCreator;
    private JndiDataSourceCreator jndiDataSourceCreator;
    private HikariDataSourceCreator hikariDataSourceCreator;
    private DruidDataSourceCreator druidDataSourceCreator;
    private DynamicDataSourceProperties properties;

    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        Class<? extends DataSource> type;
        String jndiName = dataSourceProperty.getJndiName();
        DataSource dataSource = jndiName != null && !jndiName.isEmpty() ? this.createJNDIDataSource(jndiName) : ((type = dataSourceProperty.getType()) == null ? (druidExists.booleanValue() ? this.createDruidDataSource(dataSourceProperty) : (hikariExists.booleanValue() ? this.createHikariDataSource(dataSourceProperty) : this.createBasicDataSource(dataSourceProperty))) : ("com.alibaba.druid.pool.DruidDataSource".equals(type.getName()) ? this.createDruidDataSource(dataSourceProperty) : ("com.zaxxer.hikari.HikariDataSource".equals(type.getName()) ? this.createHikariDataSource(dataSourceProperty) : this.createBasicDataSource(dataSourceProperty))));
        this.runScrip(dataSource, dataSourceProperty);
        return this.wrapDataSource(dataSource, dataSourceProperty);
    }

    private void runScrip(DataSource dataSource, DataSourceProperty dataSourceProperty) {
        String schema = dataSourceProperty.getSchema();
        String data = dataSourceProperty.getData();
        if (StringUtils.hasText((String)schema) || StringUtils.hasText((String)data)) {
            ScriptRunner scriptRunner = new ScriptRunner(dataSourceProperty.isContinueOnError(), dataSourceProperty.getSeparator());
            if (StringUtils.hasText((String)schema)) {
                scriptRunner.runScript(dataSource, schema);
            }
            if (StringUtils.hasText((String)data)) {
                scriptRunner.runScript(dataSource, data);
            }
        }
    }

    private DataSource wrapDataSource(DataSource dataSource, DataSourceProperty dataSourceProperty) {
        String name = dataSourceProperty.getPoolName();
        DataSource targetDataSource = dataSource;
        Boolean enabledP6spy = this.properties.getP6spy() != false && dataSourceProperty.getP6spy() != false;
        if (enabledP6spy.booleanValue()) {
            targetDataSource = new P6DataSource(dataSource);
            log.debug("dynamic-datasource [{}] wrap p6spy plugin", (Object)name);
        }
        Boolean enabledSeata = this.properties.getSeata() != false && dataSourceProperty.getSeata() != false;
        SeataMode seataMode = this.properties.getSeataMode();
        if (enabledSeata.booleanValue()) {
            targetDataSource = SeataMode.XA == seataMode ? new DataSourceProxyXA(dataSource) : new DataSourceProxy(dataSource);
            log.debug("dynamic-datasource [{}] wrap seata plugin transaction mode [{}]", (Object)name, (Object)seataMode);
        }
        return new ItemDataSource(name, dataSource, targetDataSource, enabledP6spy, enabledSeata, seataMode);
    }

    public DataSource createBasicDataSource(DataSourceProperty dataSourceProperty) {
        if (StringUtils.isEmpty((Object)dataSourceProperty.getPublicKey())) {
            dataSourceProperty.setPublicKey(this.properties.getPublicKey());
        }
        return this.basicDataSourceCreator.createDataSource(dataSourceProperty);
    }

    public DataSource createJNDIDataSource(String jndiName) {
        return this.jndiDataSourceCreator.createDataSource(jndiName);
    }

    public DataSource createDruidDataSource(DataSourceProperty dataSourceProperty) {
        if (StringUtils.isEmpty((Object)dataSourceProperty.getPublicKey())) {
            dataSourceProperty.setPublicKey(this.properties.getPublicKey());
        }
        return this.druidDataSourceCreator.createDataSource(dataSourceProperty);
    }

    public DataSource createHikariDataSource(DataSourceProperty dataSourceProperty) {
        if (StringUtils.isEmpty((Object)dataSourceProperty.getPublicKey())) {
            dataSourceProperty.setPublicKey(this.properties.getPublicKey());
        }
        return this.hikariDataSourceCreator.createDataSource(dataSourceProperty);
    }

    public void setBasicDataSourceCreator(BasicDataSourceCreator basicDataSourceCreator) {
        this.basicDataSourceCreator = basicDataSourceCreator;
    }

    public void setJndiDataSourceCreator(JndiDataSourceCreator jndiDataSourceCreator) {
        this.jndiDataSourceCreator = jndiDataSourceCreator;
    }

    public void setHikariDataSourceCreator(HikariDataSourceCreator hikariDataSourceCreator) {
        this.hikariDataSourceCreator = hikariDataSourceCreator;
    }

    public void setDruidDataSourceCreator(DruidDataSourceCreator druidDataSourceCreator) {
        this.druidDataSourceCreator = druidDataSourceCreator;
    }

    public void setProperties(DynamicDataSourceProperties properties) {
        this.properties = properties;
    }

    static {
        try {
            Class.forName("com.alibaba.druid.pool.DruidDataSource");
            druidExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("com.zaxxer.hikari.HikariDataSource");
            hikariExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

