/**
 * hub-common-api
 *
 * Copyright (C) 2018 Black Duck Software, Inc.
 * http://www.blackducksoftware.com/
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.synopsys.integration.blackduck.api.generated.view;

import java.util.HashMap;
import java.util.Map;

import com.synopsys.integration.blackduck.api.core.HubView;
import com.synopsys.integration.blackduck.api.core.LinkResponse;
import com.synopsys.integration.blackduck.api.core.LinkSingleResponse;
import com.synopsys.integration.blackduck.api.generated.component.VulnerabilityV2ClassificationView;
import com.synopsys.integration.blackduck.api.generated.component.VulnerabilityV2Cvss2View;
import com.synopsys.integration.blackduck.api.generated.component.VulnerabilityV2Cvss3View;
import com.synopsys.integration.blackduck.api.generated.enumeration.VulnerabilityV1SourceType;
import com.synopsys.integration.blackduck.api.generated.response.CweView;
import com.synopsys.integration.blackduck.api.generated.view.VulnerabilityV2View;

//this file should not be edited - if changes are necessary, the generator should be updated, then this file should be re-created
public class VulnerabilityV2View extends HubView {
    public static final Map<String, LinkResponse> links = new HashMap<>();

    public static final String REFERENCE_LINK = "reference";
    public static final String CWES_LINK = "cwes";
    public static final String RELATED_VULNERABILITIES_LINK = "related-vulnerabilities";

    public static final LinkSingleResponse<CweView> CWES_LINK_RESPONSE = new LinkSingleResponse<CweView>(CWES_LINK, CweView.class);
    public static final LinkSingleResponse<VulnerabilityV2View> RELATED_VULNERABILITIES_LINK_RESPONSE = new LinkSingleResponse<VulnerabilityV2View>(RELATED_VULNERABILITIES_LINK, VulnerabilityV2View.class);

    static {
        links.put(CWES_LINK, CWES_LINK_RESPONSE);
        links.put(RELATED_VULNERABILITIES_LINK, RELATED_VULNERABILITIES_LINK_RESPONSE);
    }

    public java.util.List<VulnerabilityV2ClassificationView> classifications;
    public String credit;
    public VulnerabilityV2Cvss2View cvss2;
    public VulnerabilityV2Cvss3View cvss3;
    public String description;
    public java.util.Date disclosureDate;
    public java.util.Date discoveryDate;
    public java.util.Date exploitPublishDate;
    public String name;
    public Boolean parentAdvisory;
    public java.util.Date publishedDate;
    public String severity;
    public String solution;
    public java.util.Date solutionDate;
    public VulnerabilityV1SourceType source;
    public String technicalDescription;
    public String title;
    public Boolean underReview;
    public java.util.Date updatedDate;
    public java.util.Date vendorFixDate;
    public java.util.Date vendorNotifiedDate;
    public String workaround;
    public Boolean zeroDay;

}
